/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.dealerframe.forms.permissions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.projects.utmadmin.functions.dealer.dealer.permissions.PermissionFunctions;
import biz.netup.projects.utmadmin.functions.dealer.main.usersandgroups.users.UsersFunctions;
import biz.netup.swing.table.CheckboxCellEditor;
import biz.netup.swing.table.CheckboxCellRenderer;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.swing.tab.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class DealerUserPermissionsTab
extends TabPanel {
    private JPanel panel;
    private TablePanelImpl usersTableImpl;
    private JComboBox pageComboBox;
    private JLabel ofLabel;
    private JFormattedTextField usersPerPageTextField;
    private int usersFrom;
    private int usersTo;
    private int did;

    @Override
    public int getTabType() {
        return 3;
    }

    @Override
    public String getGroupName() {
        return "Permissions";
    }

    @Override
    public String getTabName() {
        return "Permissions over users";
    }

    @Override
    protected void refreshTab() throws UrfaException {
    }

    @Override
    protected Component getMainPanel() {
        return this.panel;
    }

    public DealerUserPermissionsTab(int n) {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/dealer/users_24.png")));
        this.$$$setupUI$$$();
        this.did = n;
    }

    @Override
    protected void init() {
        super.init();
        this.generatePagePanel();
        this.refreshTable();
        this.usersPerPageTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DealerUserPermissionsTab.this.generatePagePanel();
                DealerUserPermissionsTab.this.refreshTable();
            }
        });
        this.pageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DealerUserPermissionsTab.this.changePage();
                DealerUserPermissionsTab.this.refreshTable();
            }
        });
    }

    private void changePage() {
        try {
            int n = Integer.parseInt(this.usersPerPageTextField.getText());
            this.usersFrom = this.pageComboBox.getSelectedIndex() * n;
            this.usersTo = this.usersFrom + n;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Incorrect number");
        }
    }

    private void generatePagePanel() {
        try {
            int n = UsersFunctions.getUsersCount(false);
            int n2 = n % Integer.parseInt(this.usersPerPageTextField.getText()) == 0 ? n / Integer.parseInt(this.usersPerPageTextField.getText()) : n / Integer.parseInt(this.usersPerPageTextField.getText()) + 1;
            this.pageComboBox.removeAllItems();
            for (int i = 0; i < n2; ++i) {
                this.pageComboBox.addItem(i + 1);
            }
            this.usersFrom = 0;
            this.usersTo = Integer.parseInt(this.usersPerPageTextField.getText());
            this.ofLabel.setText(" " + n2);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Incorrect number");
        }
    }

    private void createUIComponents() {
        this.createTable();
        this.usersPerPageTextField = new JFormattedTextField(new DefaultFormatterFactory(new NumberFormatter()));
    }

    private void refreshTable() {
        this.usersTableImpl.getTableModel().removeAllRows();
        for (Map<String, Object> map : PermissionFunctions.getUserPerms(this.did, this.usersFrom, this.usersTo)) {
            this.usersTableImpl.getTableModel().addRow(map);
        }
    }

    private void createTable() {
        this.usersTableImpl = new TablePanelImpl(this.getClass().getName() + "_userperms", true, new CustomTableModel());
        MapTableModel mapTableModel = this.usersTableImpl.getTableModel();
        mapTableModel.addColumn("uid", "UID", true, false);
        mapTableModel.addColumn("login", "Login", true, false);
        mapTableModel.addColumn("master_account", "Master account", true, false);
        mapTableModel.addColumn("full_name", "Full name", true, false);
        mapTableModel.addColumn("check", "Permissions granted", true, true);
        this.usersTableImpl.setEditable(true);
        this.usersTableImpl.setAppendable(false);
        this.usersTableImpl.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public JMenuItem[] getTableContextMenuItems(Map<String, Object>[] mapArray) {
                JMenuItem jMenuItem = new JMenuItem(DealerUserPermissionsTab.this.resource.getString("Refresh"));
                JMenuItem jMenuItem2 = new JMenuItem(DealerUserPermissionsTab.this.resource.getString("Check"));
                JMenuItem jMenuItem3 = new JMenuItem(DealerUserPermissionsTab.this.resource.getString("Uncheck"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DealerUserPermissionsTab.this.refreshTable();
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DealerUserPermissionsTab.this.check();
                    }
                });
                jMenuItem3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DealerUserPermissionsTab.this.uncheck();
                    }
                });
                if (mapArray.length < 1) {
                    return new JMenuItem[]{jMenuItem};
                }
                if (mapArray.length > 1) {
                    return new JMenuItem[]{jMenuItem2, jMenuItem3, jMenuItem};
                }
                Map<String, Object> map = mapArray[0];
                Integer n = (Integer)map.get("check");
                ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
                if (null != n && n == 0 && (Integer)mapArray[0].get("dealer_id") == 0) {
                    arrayList.add(jMenuItem2);
                }
                if (null != n && n == 1 && (Integer)mapArray[0].get("dealer_id") == 0) {
                    arrayList.add(jMenuItem3);
                }
                arrayList.add(jMenuItem);
                return arrayList.toArray(new JMenuItem[arrayList.size()]);
            }

            @Override
            public void performTableRowDoubleClicked(Map<String, Object> map) {
                Integer n = (Integer)map.get("check");
                if (null != n && n == 0) {
                    DealerUserPermissionsTab.this.check();
                }
                if (null != n && n != 0) {
                    DealerUserPermissionsTab.this.uncheck();
                }
            }

            @Override
            public void performSelectionChanged(Map<String, Object>[] mapArray) {
            }

            @Override
            public void performRowModified(Map<String, Object> map) {
                map.put("X-STATUS", null);
                PermissionFunctions.changePerm(DealerUserPermissionsTab.this.did, 1, new int[]{(Integer)map.get("uid")}, (Integer)map.get("check"));
            }

            @Override
            public void performColumnVisibilityChanged(String string, boolean bl) {
            }
        });
        this.usersTableImpl.applyTableSettings();
        this.usersTableImpl.setCellRenderer("check", new CustomCheckboxCellRenderer());
        this.usersTableImpl.setCellEditor("check", new CheckboxCellEditor());
        this.usersTableImpl.setCellRenderer("uid", new CustomCellRenderer());
    }

    private void check() {
        for (Map<String, Object> map : this.usersTableImpl.getSelectedTableRows()) {
            int n = (Integer)map.get("dealer_id");
            if (n != 0 && n != this.did) {
                map.put("check", 0);
                continue;
            }
            map.put("check", 1);
            PermissionFunctions.changePerm(this.did, 1, new int[]{(Integer)map.get("uid")}, (Integer)map.get("check"));
            this.usersTableImpl.getTableModel().fireTableDataChanged();
        }
    }

    private void uncheck() {
        for (Map<String, Object> map : this.usersTableImpl.getSelectedTableRows()) {
            int n = (Integer)map.get("dealer_id");
            if (n != 0 && n != this.did) continue;
            map.put("check", 0);
            PermissionFunctions.changePerm(this.did, 1, new int[]{(Integer)map.get("uid")}, (Integer)map.get("check"));
            this.usersTableImpl.getTableModel().fireTableDataChanged();
        }
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.panel.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        this.panel.add((Component)jPanel2, "Center");
        jPanel2.add((Component)this.usersTableImpl, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        jPanel3.add((Component)jPanel4, "West");
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Users per page"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Page"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("of"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)jLabel3, gridBagConstraints);
        this.pageComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)this.pageComboBox, gridBagConstraints);
        this.ofLabel = new JLabel();
        this.ofLabel.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)this.ofLabel, gridBagConstraints);
        this.usersPerPageTextField.setText("100");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)this.usersPerPageTextField, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel4.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel4.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel4.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel4.add((Component)jPanel10, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel4.add((Component)jPanel11, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel4.add((Component)jPanel12, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    class CustomCellRenderer
    extends DefaultTableCellRenderer {
        CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Integer n3 = (Integer)DealerUserPermissionsTab.this.usersTableImpl.getTableModel().getRow(n).get("dealer_id");
            super.setForeground(Color.BLACK);
            if (n3 != 0 && n3 != DealerUserPermissionsTab.this.did) {
                super.setBackground(new Color(255, 153, 153));
            } else {
                super.setBackground(new Color(153, 255, 153));
            }
            return component;
        }

        @Override
        public void setBackground(Color color) {
        }

        @Override
        public void setForeground(Color color) {
        }
    }

    class CustomCheckboxCellRenderer
    extends CheckboxCellRenderer {
        CustomCheckboxCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component == null) {
                return component;
            }
            int n3 = (Integer)DealerUserPermissionsTab.this.usersTableImpl.getTableModel().getRow(n).get("dealer_id");
            if (n3 != 0 && n3 != DealerUserPermissionsTab.this.did) {
                component.setEnabled(false);
            } else {
                component.setEnabled(true);
            }
            return component;
        }
    }

    class CustomTableModel
    extends MapTableModel {
        @Override
        public int getRowCount() {
            return super.getRowCount() - 1;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (super.getColumnId(n2).compareTo("check") == 0) {
                int n3 = (Integer)super.getRow(n).get("dealer_id");
                return n3 == 0 || n3 == DealerUserPermissionsTab.this.did;
            }
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            super.setValueAt(object, n, n2);
            if (super.getColumnId(n2).compareTo("check") == 0) {
                if ((Integer)object != 0) {
                    DealerUserPermissionsTab.this.check();
                } else {
                    DealerUserPermissionsTab.this.uncheck();
                }
            }
        }
    }
}

