/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.dealerframe.forms.permissions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.projects.utmadmin.functions.dealer.dealer.permissions.PermissionFunctions;
import biz.netup.swing.table.CheckboxCellEditor;
import biz.netup.swing.table.CheckboxCellRenderer;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class DealerTariffPermissionsTab
extends TabPanel {
    private JPanel panel;
    private TablePanelImpl tariffsTablePanel;
    private int did;

    @Override
    public String getTabName() {
        return "Permissions over tariffs";
    }

    @Override
    public int getTabType() {
        return 3;
    }

    @Override
    public String getGroupName() {
        return "Permissions";
    }

    @Override
    protected void refreshTab() throws UrfaException {
    }

    @Override
    protected Component getMainPanel() {
        return this.panel;
    }

    public DealerTariffPermissionsTab(int n) {
        this.setSmallIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/dealer/tariff_plans_24.png")));
        this.$$$setupUI$$$();
        this.did = n;
    }

    @Override
    protected void init() {
        super.init();
        this.refreshTable();
    }

    private void createUIComponents() {
        this.createTable();
    }

    private void refreshTable() {
        this.tariffsTablePanel.getTableModel().removeAllRows();
        for (Map<String, Object> map : PermissionFunctions.getTariffPerms(this.did)) {
            this.tariffsTablePanel.getTableModel().addRow(map);
        }
    }

    private void createTable() {
        this.tariffsTablePanel = new TablePanelImpl(this.getClass().getName() + "_userperms", true);
        MapTableModel mapTableModel = this.tariffsTablePanel.getTableModel();
        mapTableModel.addColumn("id", "ID", true, false);
        mapTableModel.addColumn("name", "Tariff name", true, false);
        mapTableModel.addColumn("expire_date", "Expire date", true, false);
        mapTableModel.addColumn("rollover", "Rollover ballance", true, false);
        mapTableModel.addColumn("check", "Permissions granted", true, true);
        this.tariffsTablePanel.setEditable(true);
        this.tariffsTablePanel.setAppendable(false);
        this.tariffsTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public JMenuItem[] getTableContextMenuItems(Map<String, Object>[] mapArray) {
                JMenuItem jMenuItem = new JMenuItem(DealerTariffPermissionsTab.this.resource.getString("Refresh"));
                JMenuItem jMenuItem2 = new JMenuItem(DealerTariffPermissionsTab.this.resource.getString("Check"));
                JMenuItem jMenuItem3 = new JMenuItem(DealerTariffPermissionsTab.this.resource.getString("Uncheck"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DealerTariffPermissionsTab.this.refreshTable();
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DealerTariffPermissionsTab.this.check();
                    }
                });
                jMenuItem3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DealerTariffPermissionsTab.this.uncheck();
                    }
                });
                if (mapArray.length < 1) {
                    return new JMenuItem[]{jMenuItem};
                }
                if (mapArray.length > 1) {
                    return new JMenuItem[]{jMenuItem2, jMenuItem3, jMenuItem};
                }
                Map<String, Object> map = mapArray[0];
                Integer n = (Integer)map.get("check");
                ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
                if (null != n && n == 0) {
                    arrayList.add(jMenuItem2);
                }
                if (null != n && n == 1) {
                    arrayList.add(jMenuItem3);
                }
                arrayList.add(jMenuItem);
                return arrayList.toArray(new JMenuItem[arrayList.size()]);
            }

            @Override
            public void performTableRowDoubleClicked(Map<String, Object> map) {
                Integer n = (Integer)map.get("check");
                ArrayList arrayList = new ArrayList();
                if (null != n && n == 0) {
                    DealerTariffPermissionsTab.this.check();
                }
                if (null != n && n != 0) {
                    DealerTariffPermissionsTab.this.uncheck();
                }
            }

            @Override
            public void performSelectionChanged(Map<String, Object>[] mapArray) {
            }

            @Override
            public void performRowModified(Map<String, Object> map) {
                map.put("X-STATUS", null);
                PermissionFunctions.changePerm(DealerTariffPermissionsTab.this.did, 3, new int[]{(Integer)map.get("id")}, (Integer)map.get("check"));
                if ((Integer)map.get("check") == 1) {
                    if (Dialogs.showYesNoDialog("Add permissions for all services?")) {
                        PermissionFunctions.addPermissionsForServicesInTariff(DealerTariffPermissionsTab.this.did, (Integer)map.get("id"));
                    }
                } else {
                    PermissionFunctions.removePermissionsForServicesInTariff(DealerTariffPermissionsTab.this.did, (Integer)map.get("id"));
                }
            }

            @Override
            public void performColumnVisibilityChanged(String string, boolean bl) {
            }
        });
        this.tariffsTablePanel.applyTableSettings();
        this.tariffsTablePanel.setCellRenderer("check", new CheckboxCellRenderer());
        this.tariffsTablePanel.setCellRenderer("rollover", new CheckboxCellRenderer(false));
        this.tariffsTablePanel.setCellEditor("check", new CheckboxCellEditor());
    }

    private void check() {
        boolean bl = Dialogs.showYesNoDialog("Add permissions for all services?");
        for (Map<String, Object> map : this.tariffsTablePanel.getSelectedTableRows()) {
            map.put("check", 1);
            PermissionFunctions.changePerm(this.did, 3, new int[]{(Integer)map.get("id")}, (Integer)map.get("check"));
            this.tariffsTablePanel.getTableModel().fireTableDataChanged();
            if (!bl) continue;
            PermissionFunctions.addPermissionsForServicesInTariff(this.did, (Integer)map.get("id"));
        }
    }

    private void uncheck() {
        for (Map<String, Object> map : this.tariffsTablePanel.getSelectedTableRows()) {
            map.put("check", 0);
            PermissionFunctions.changePerm(this.did, 3, new int[]{(Integer)map.get("id")}, (Integer)map.get("check"));
            this.tariffsTablePanel.getTableModel().fireTableDataChanged();
            PermissionFunctions.removePermissionsForServicesInTariff(this.did, (Integer)map.get("id"));
        }
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout(0, 0));
        this.panel.add((Component)this.tariffsTablePanel, "Center");
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

