/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.dealerframe;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.projects.utmadmin.functions.dealer.dealer.dealer.DealerFunctions;
import biz.netup.projects.utmadmin.functions.objects.AddressWithMask;
import biz.netup.projects.utmadmin.functions.objects.UTMDealer;
import biz.netup.projects.utmadmin.gui.dealerframe.BottomButtons;
import biz.netup.projects.utmadmin.gui.dealerframe.forms.dealer.DealerAdditionalTab;
import biz.netup.projects.utmadmin.gui.dealerframe.forms.dealer.DealerContactsTab;
import biz.netup.projects.utmadmin.gui.dealerframe.forms.dealer.DealerMainTab;
import biz.netup.projects.utmadmin.gui.dealerframe.forms.dealer.DealerMiscTab;
import biz.netup.projects.utmadmin.gui.dealerframe.forms.permissions.DealerDiscountPeriodPermissionsTab;
import biz.netup.projects.utmadmin.gui.dealerframe.forms.permissions.DealerHousePermissionsTab;
import biz.netup.projects.utmadmin.gui.dealerframe.forms.permissions.DealerServicePermissionsTab;
import biz.netup.projects.utmadmin.gui.dealerframe.forms.permissions.DealerTariffPermissionsTab;
import biz.netup.projects.utmadmin.gui.dealerframe.forms.permissions.DealerUserPermissionsTab;
import biz.netup.projects.utmadmin.gui.mainframe.MainFrame;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.BlocksReportNew;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.DHSReportAdmin;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.GeneralReportDealer;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.InvoiceDocumentsTab;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.PaymentsReportAdmin;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.ServicesReportDealer;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.TelephonyReportAdmin;
import biz.netup.projects.utmadmin.gui.mainframe.forms.reports.TrafficReportAdmin;
import biz.netup.utmutils.control.Checkers;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import biz.netup.utmutils.swing.tab.TabPanel;
import biz.netup.utmutils.swing.tabbedwindow.TabbedWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.KeyStroke;

public class DealerFrame
extends TabbedWindow {
    private JButton buttonOK;
    private JButton buttonCancel;
    private JButton applyButton;
    private JButton refreshButton;
    private BottomButtons bb;
    private UTMDealer dealer;
    private DealerMainTab main;
    private DealerAdditionalTab additional;
    private DealerContactsTab contacts;
    private DealerMiscTab misc;
    private DealerUserPermissionsTab userPerms;
    private DealerDiscountPeriodPermissionsTab dpPerms;
    private DealerTariffPermissionsTab tariffPerms;
    private DealerServicePermissionsTab servicePerms;
    private DealerHousePermissionsTab housePerms;
    TabPanel blockReportAdmin;
    TabPanel trafficReportAdmin;
    TabPanel paymentsReportAdmin;
    TabPanel dhsReportAdmin;
    TabPanel generalReportAdmin;
    TabPanel telReportAdmin;
    TabPanel serviceReportAdmin;
    TabPanel documents;

    public DealerFrame(int n) {
        super(n);
    }

    private void refresh() {
        if (Dialogs.showYesNoDialog("All changes will be lost. Are you sure?")) {
            this.setDealerData(this.dealer);
        }
    }

    private void onApply() {
        if (this.propertiesIsOk()) {
            this.applyChanges();
            MainFrame.getInstance().refreshDealers();
        }
    }

    private void applyChanges() {
        try {
            DealerFunctions.editDealer(this.getDealerData());
        }
        catch (UrfaException urfaException) {
            log.error(urfaException);
        }
    }

    private boolean propertiesIsOk() {
        if (!this.loginIsOk()) {
            Dialogs.showErrorDialog("Login is incorrect");
            this.setTab(this.main, this.main.getSideMenuItem());
            return false;
        }
        if (this.main.getPassword().compareTo(this.main.getConfirmPassword()) != 0) {
            Dialogs.showErrorDialog("Password doesn't match");
            this.setTab(this.main, this.main.getSideMenuItem());
            return false;
        }
        return true;
    }

    private boolean loginIsOk() {
        return this.main.getLogin().length() != 0 && Checkers.loginOk(this.main.getLogin());
    }

    private void onOK() {
        if (this.propertiesIsOk()) {
            this.applyChanges();
            MainFrame.getInstance().refreshDealers();
            this.dispose();
        }
    }

    private void onCancel() {
        this.dispose();
    }

    private UTMDealer getDealerData() {
        AddressWithMask addressWithMask;
        UTMDealer uTMDealer = new UTMDealer();
        uTMDealer.dealerId = this.id;
        uTMDealer.login = this.main.getLogin();
        uTMDealer.password = this.main.getPassword();
        uTMDealer.fullName = this.main.getFullName();
        uTMDealer.actAddress = this.contacts.getActualAddress();
        uTMDealer.passport = this.additional.getPassport();
        uTMDealer.workTel = this.contacts.getWorkPhone();
        uTMDealer.homeTel = this.contacts.getHomePhone();
        uTMDealer.mobTel = this.contacts.getMobilePhone();
        uTMDealer.webPage = this.contacts.getWebPage();
        uTMDealer.icqNumber = this.contacts.getIcqNumber();
        uTMDealer.email = this.contacts.getEmail();
        uTMDealer.comments = this.additional.getComments();
        try {
            addressWithMask = Resolve.SubnetFromView(this.main.getIP4AddressTextField());
            uTMDealer.ipAddress4 = addressWithMask.address;
            uTMDealer.mask4 = addressWithMask.mask;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            addressWithMask = Resolve.SubnetFromView(this.main.getIP6AddressTextField());
            uTMDealer.ipAddress6 = addressWithMask.address;
            uTMDealer.mask6 = addressWithMask.mask;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return uTMDealer;
    }

    private void setDealerData(UTMDealer uTMDealer) {
        this.main.setLoginTextField(uTMDealer.login);
        this.main.setPasswordField(uTMDealer.password);
        this.main.setConfirmPasswordField(uTMDealer.password);
        this.main.setFullNameTextField(uTMDealer.fullName);
        this.additional.setCommentsTextArea(uTMDealer.comments);
        this.additional.setPassportField(uTMDealer.passport);
        this.main.setIP4AddressTextField(Resolve.SubnetToView(uTMDealer.ipAddress4, uTMDealer.mask4));
        this.main.setIP6AddressTextField(Resolve.SubnetToView(uTMDealer.ipAddress6, uTMDealer.mask6));
        this.contacts.setActualAddressTextField(uTMDealer.actAddress);
        this.contacts.setEmailTextField(uTMDealer.email);
        this.contacts.setHomePhoneTextField(uTMDealer.homeTel);
        this.contacts.setIcqNumberTextField(uTMDealer.icqNumber);
        this.contacts.setMobilePhoneTextField(uTMDealer.mobTel);
        this.contacts.setWebPageTextField(uTMDealer.webPage);
        this.contacts.setWorkPhoneTextField(uTMDealer.workTel);
        this.misc.setCreatedByTextField("" + uTMDealer.whoCreate);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        this.misc.setCreatedOnTextField(simpleDateFormat.format(new Date((long)uTMDealer.createDate * 1000L)));
        this.misc.setModifiedByTextField("" + uTMDealer.whoChange);
        this.misc.setModifiedLastTimeOnTextField(simpleDateFormat.format(new Date((long)uTMDealer.changeDate * 1000L)));
    }

    @Override
    protected void init() {
        this.bb = new BottomButtons();
        this.initButtons();
        this.userPerms = new DealerUserPermissionsTab(this.id);
        this.dpPerms = new DealerDiscountPeriodPermissionsTab(this.id);
        this.tariffPerms = new DealerTariffPermissionsTab(this.id);
        this.servicePerms = new DealerServicePermissionsTab(this.id);
        this.housePerms = new DealerHousePermissionsTab(this.id);
        this.main = new DealerMainTab();
        this.additional = new DealerAdditionalTab();
        this.contacts = new DealerContactsTab();
        this.misc = new DealerMiscTab();
        this.blockReportAdmin = new BlocksReportNew(this.id, true);
        this.trafficReportAdmin = new TrafficReportAdmin(this.id, true);
        this.paymentsReportAdmin = new PaymentsReportAdmin(this.id, true);
        this.dhsReportAdmin = new DHSReportAdmin(this.id, true);
        this.generalReportAdmin = new GeneralReportDealer(this.id, true);
        this.telReportAdmin = new TelephonyReportAdmin(this.id, true);
        this.serviceReportAdmin = new ServicesReportDealer(this.id, true);
        this.documents = new InvoiceDocumentsTab(this.id, true);
        if (this.id == 0) {
            return;
        }
        try {
            this.dealer = DealerFunctions.getDealer(this.id);
        }
        catch (UrfaException urfaException) {
            log.error(urfaException);
        }
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.setDealerData(this.dealer);
        this.setTitle(this.resource.getString("Edit dealer") + " " + this.dealer.getLogin());
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DealerFrame.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DealerFrame.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DealerFrame.this.onCancel();
            }
        });
        this.mainPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DealerFrame.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DealerFrame.this.onApply();
            }
        });
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DealerFrame.this.refresh();
            }
        });
    }

    @Override
    protected Dimension getWindowSize() {
        return new Dimension(1000, 600);
    }

    @Override
    protected String getWindowTitle() {
        return "Edit dealer";
    }

    @Override
    protected Vector<TabPanel> getTabPanels() {
        Vector<TabPanel> vector = new Vector<TabPanel>();
        vector.add(this.main);
        vector.add(this.additional);
        vector.add(this.contacts);
        vector.add(this.misc);
        vector.add(this.userPerms);
        vector.add(this.dpPerms);
        vector.add(this.servicePerms);
        vector.add(this.tariffPerms);
        vector.add(this.housePerms);
        vector.add(this.generalReportAdmin);
        vector.add(this.blockReportAdmin);
        vector.add(this.trafficReportAdmin);
        vector.add(this.telReportAdmin);
        vector.add(this.dhsReportAdmin);
        vector.add(this.paymentsReportAdmin);
        vector.add(this.serviceReportAdmin);
        vector.add(this.documents);
        return vector;
    }

    @Override
    protected Component getBottomPanel() {
        return this.bb.getPanel();
    }

    private void initButtons() {
        this.buttonOK = this.bb.getButtonOK();
        this.buttonCancel = this.bb.getButtonCancel();
        this.applyButton = this.bb.getApplyButton();
        this.refreshButton = this.bb.getRefreshButton();
    }
}

