/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.custom.tel;

import biz.netup.projects.utmadmin.functions.objects.TelDir;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.swing.table.TableFilter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class Dialog_SelectDirs
extends JDialog {
    private Logger log = Utils.getLogger();
    private JPanel jPanel;
    private JTextField jTextField_ID;
    private JTextField jTextField_Name;
    private TableModel dataModel;
    private Vector directions;
    private Vector dirs;
    private TableFilter sorter;
    private JPanel jPanel_Buttons;
    private JButton jButton_Ok;
    private JButton jButton_Cancel;
    private static final Dimension vskip = new Dimension(50, 10);
    private static final DateFormat dformat = DateFormat.getDateInstance(2);
    int res;
    private Vector column_names;
    private Vector res_vect;
    private JTable jTable;
    private JScrollPane jScrollPane = new JScrollPane();

    public boolean ok() {
        return this.res != 0;
    }

    public Vector getDirs() {
        return this.res_vect;
    }

    public Dialog_SelectDirs(JFrame jFrame, String string, Vector vector) {
        super(jFrame, string, true);
        this.setResizable(true);
        this.dirs = vector;
        this.res_vect = new Vector();
        try {
            this.init();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Dialog_SelectDirs(JDialog jDialog, String string, Vector vector) {
        super(jDialog, string, true);
        this.setResizable(true);
        this.dirs = vector;
        this.res_vect = new Vector();
        try {
            this.init();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.log = Utils.getLogger();
        Insets insets = new Insets(10, 10, 10, 10);
        this.jPanel = new InsetPanel(insets);
        this.jPanel.setBorder(BorderFactory.createTitledBorder(Utils.getResource().getString("Direction info")));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.jPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        this.addLabeledComponentToGBL("", Box.createRigidArea(vskip), gridBagLayout, gridBagConstraints, this.jPanel);
        this.addLabeledComponentToGBL("", Box.createRigidArea(vskip), gridBagLayout, gridBagConstraints, this.jPanel);
        this.addLabeledComponentToGBL("", Box.createRigidArea(vskip), gridBagLayout, gridBagConstraints, this.jPanel);
        this.addLabeledComponentToGBL("", Box.createRigidArea(vskip), gridBagLayout, gridBagConstraints, this.jPanel);
        gridBagConstraints.gridwidth = 0;
        this.addLabeledComponentToGBL("", Box.createRigidArea(vskip), gridBagLayout, gridBagConstraints, this.jPanel);
        this.column_names = new Vector();
        this.column_names.add(Utils.getResource().getString("ID"));
        this.column_names.add(Utils.getResource().getString("Prefix"));
        this.column_names.add(Utils.getResource().getString("Direction name"));
        this.column_names.add(Utils.getResource().getString("Created on"));
        this.column_names.add(Utils.getResource().getString("Select"));
        this.create_table();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add((Component)this.jPanel, "North");
        this.jScrollPane.getViewport().add(this.jTable);
        gridBagConstraints.gridwidth = 0;
        this.addLabeledComponentToGBL("", this.jScrollPane, gridBagLayout, gridBagConstraints, this.jPanel);
        this.getContentPane().add(Box.createRigidArea(new Dimension(1, 5)));
        this.jPanel_Buttons = new JPanel();
        this.jPanel_Buttons.setLayout(new BoxLayout(this.jPanel_Buttons, 0));
        this.jButton_Ok = new JButton(Utils.getResource().getString("Ok"));
        this.jButton_Cancel = new JButton(Utils.getResource().getString("Cancel"));
        JLabel jLabel = new JLabel("     ");
        this.jPanel_Buttons.add(this.jButton_Ok);
        this.jPanel_Buttons.add(jLabel);
        this.jPanel_Buttons.add(this.jButton_Cancel);
        this.getContentPane().add((Component)this.jPanel_Buttons, "South");
        this.getContentPane().add(Box.createRigidArea(new Dimension(1, 5)));
        this.jButton_Ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Dialog_SelectDirs.this.jButton_Ok_actionPerformed(actionEvent);
            }
        });
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Dialog_SelectDirs.this.jButton_Cancel_actionPerformed(actionEvent);
            }
        });
    }

    private void jButton_Ok_actionPerformed(ActionEvent actionEvent) {
        int n;
        this.res_vect = new Vector();
        for (n = 0; n < this.jTable.getRowCount(); ++n) {
            boolean bl = (Boolean)this.jTable.getValueAt(n, 4);
            if (!bl) continue;
            this.res_vect.add((Integer)this.jTable.getValueAt(n, 0));
        }
        for (n = 0; n < this.dirs.size(); ++n) {
            Integer n2 = (Integer)this.dirs.get(n);
            if (this.directions.contains(n2) || this.res_vect.contains(n2)) continue;
            this.res_vect.add(n2);
        }
        this.res = 1;
        this.setVisible(false);
        this.dispose();
    }

    private void jButton_Cancel_actionPerformed(ActionEvent actionEvent) {
        this.res = 0;
        this.setVisible(false);
        this.dispose();
    }

    private void addLabeledComponentToGBL(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Container container) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private void addLabeledComponentToGBL(String string, Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Container container) {
        JLabel jLabel = new JLabel(string);
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints2.insets = new Insets(2, 2, 2, 0);
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 0.0;
        if (component == null) {
            component = new JLabel("");
        }
        gridBagLayout.setConstraints(jLabel, gridBagConstraints2);
        container.add(jLabel);
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private boolean is_to_add(int n) {
        for (int i = 0; i < this.dirs.size(); ++i) {
            if (n != (Integer)this.dirs.get(i)) continue;
            return true;
        }
        return false;
    }

    int getSelectedRowTable() {
        return this.sorter.modelIndex(this.jTable.getSelectedRow());
    }

    private void create_table() {
        this.directions = TelDir.getTelDirs(true);
        this.dataModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return Dialog_SelectDirs.this.column_names.size();
            }

            @Override
            public int getRowCount() {
                return Dialog_SelectDirs.this.directions.size();
            }

            @Override
            public Object getValueAt(int n, int n2) {
                TelDir telDir = (TelDir)Dialog_SelectDirs.this.directions.get(n);
                if (n2 == 0) {
                    return new Integer(telDir.getID());
                }
                if (n2 == 1) {
                    return telDir.getPrefix();
                }
                if (n2 == 2) {
                    return telDir.getName();
                }
                if (n2 == 3) {
                    return dformat.format(telDir.getCreateDate());
                }
                if (n2 == 4) {
                    return new Boolean(Dialog_SelectDirs.this.is_to_add(telDir.getID()));
                }
                return "";
            }

            public Class getColumnClass(int n) {
                if (n == 4) {
                    return Boolean.class;
                }
                return super.getColumnClass(n);
            }

            @Override
            public String getColumnName(int n) {
                return (String)Dialog_SelectDirs.this.column_names.get(n);
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 4;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                TelDir telDir = (TelDir)Dialog_SelectDirs.this.directions.get(n);
                for (int i = 0; i < Dialog_SelectDirs.this.dirs.size(); ++i) {
                    if (telDir.getID() != ((Integer)Dialog_SelectDirs.this.dirs.get(i)).intValue()) continue;
                    Dialog_SelectDirs.this.dirs.removeElementAt(i);
                    return;
                }
                Dialog_SelectDirs.this.dirs.add(new Integer(telDir.getID()));
            }
        };
        this.sorter = new TableFilter(this.dataModel);
        this.jTable = new JTable(this.sorter);
        this.sorter.setTableHeader(this.jTable.getTableHeader());
        for (int i = 0; i < this.jTable.getColumnModel().getColumnCount(); ++i) {
            TableColumn tableColumn = this.jTable.getColumnModel().getColumn(i);
            tableColumn.setIdentifier(new Integer(1));
        }
        this.jTable.setSelectionMode(0);
        this.jScrollPane.getViewport().add(this.jTable);
    }

    class InsetPanel
    extends JPanel {
        Insets i;

        InsetPanel(Insets insets) {
            this.i = insets;
        }

        @Override
        public Insets getInsets() {
            return this.i;
        }
    }
}

