/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.custom.radius;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.projects.utmadmin.gui.custom.radius.RadiusAttrIdValidator;
import biz.netup.projects.utmadmin.gui.custom.radius.RadiusAttrValueValidator;
import biz.netup.swing.datetime.JDateTime;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DialogModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class RadiusDialogN
extends DialogModel {
    private JTextField vendorTextField;
    private JTextField attributeTextField;
    private JTextField valueTextField;
    private JRadioButton numberRadioButton;
    private JRadioButton stringRadioButton;
    private JRadioButton IPRadioButton;
    private JPanel panel;
    private JRadioButton BinaryRadioButton;
    private JCheckBox AccessAcceptCheckBox;
    private JCheckBox AccessRejectCheckBox;
    private JCheckBox DisconnectRequestCheckBox;
    private JCheckBox COARequestCheckBox;
    private JCheckBox ReplaceAttrCheckBox;
    private JCheckBox EnableScriptingCheckBox;
    private JCheckBox RemoveAttrCheckBox;
    private JCheckBox ActivateExpireCheckBox;
    private JDateTime ExpireDateTime;
    protected JPanel usagePanel;
    protected JPanel eventPanel;
    protected JPanel usagePanelSpacer;
    protected JPanel mainParamsPanel;
    private JPanel typePanel;
    private JCheckBox isValueTunnelParameterCheckBox;
    private JCheckBox addIfNotExistsCheckBox;
    protected int tag;
    RadiusAttrIdValidator idValiadator;
    RadiusAttrValueValidator valueValidator;

    public RadiusDialogN() {
        this.$$$setupUI$$$();
    }

    public RadiusDialogN(Map<String, Object> map) {
        super(map);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.numberRadioButton);
        buttonGroup.add(this.stringRadioButton);
        buttonGroup.add(this.IPRadioButton);
        buttonGroup.add(this.BinaryRadioButton);
    }

    private void setEnabledStateForContainer(Container container, boolean bl) {
        for (Component component : container.getComponents()) {
            if (component instanceof JPanel) {
                this.setEnabledStateForContainer((Container)component, bl);
                continue;
            }
            if (component instanceof JLabel) continue;
            if (component instanceof JButton) {
                component.setEnabled(bl);
                continue;
            }
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).setEditable(bl);
                continue;
            }
            component.setEnabled(bl);
        }
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        this.valueValidator = new RadiusAttrValueValidator(this.valueTextField, this.typePanel);
        this.valueValidator.setTypeRB(this.numberRadioButton, this.stringRadioButton, this.IPRadioButton, this.BinaryRadioButton);
        this.valueValidator.setTunnelCheckBox(this.isValueTunnelParameterCheckBox);
        this.valueValidator.setRemoveAttrCheckBox(this.RemoveAttrCheckBox);
        this.valueTextField.getDocument().addDocumentListener(this.valueValidator);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RadiusDialogN.this.valueValidator.setTunnel(RadiusDialogN.this.isValueTunnelParameterCheckBox.isSelected());
            }
        };
        this.isValueTunnelParameterCheckBox.addActionListener(actionListener);
        this.idValiadator = new RadiusAttrIdValidator(this.attributeTextField);
        this.attributeTextField.getDocument().addDocumentListener(this.idValiadator);
        this.idValiadator.setValueValidator(this.valueValidator);
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RadiusDialogN.this.numberRadioButton.isSelected()) {
                    RadiusDialogN.this.valueValidator.setDataType(0);
                } else if (RadiusDialogN.this.stringRadioButton.isSelected()) {
                    RadiusDialogN.this.valueValidator.setDataType(1);
                } else if (RadiusDialogN.this.IPRadioButton.isSelected()) {
                    RadiusDialogN.this.valueValidator.setDataType(2);
                } else if (RadiusDialogN.this.BinaryRadioButton.isSelected()) {
                    RadiusDialogN.this.valueValidator.setDataType(3);
                }
            }
        };
        this.numberRadioButton.addActionListener(actionListener2);
        this.stringRadioButton.addActionListener(actionListener2);
        this.IPRadioButton.addActionListener(actionListener2);
        this.BinaryRadioButton.addActionListener(actionListener2);
        return this.panel;
    }

    @Override
    public String getItemName() {
        return "Radius parameters";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        if (!this.isAddMode()) {
            if ((Integer)this.item.get("param") == 1) {
                this.stringRadioButton.setSelected(true);
            } else if ((Integer)this.item.get("param") == 0) {
                this.numberRadioButton.setSelected(true);
            } else if ((Integer)this.item.get("param") == 2) {
                this.IPRadioButton.setSelected(true);
            } else if ((Integer)this.item.get("param") == 3) {
                this.BinaryRadioButton.setSelected(true);
            }
            this.valueValidator.setDataType((Integer)this.item.get("param"));
            this.vendorTextField.setText("" + this.item.get("vendor"));
            this.attributeTextField.setText("" + this.item.get("attribute"));
            if ((Integer)this.item.get("param") == 2) {
                this.valueTextField.setText(Resolve.ip_toString((Integer)this.item.get("value")));
            } else {
                this.valueTextField.setText("" + this.item.get("value"));
            }
            if ((Integer)this.item.get("tag") != 0) {
                this.valueTextField.setText(":" + this.item.get("tag") + ":" + this.item.get("value"));
            }
            this.AccessAcceptCheckBox.setSelected((Boolean)this.item.get("access_accept_flag"));
            this.AccessRejectCheckBox.setSelected((Boolean)this.item.get("access_reject_flag"));
            this.DisconnectRequestCheckBox.setSelected((Boolean)this.item.get("disconnect_request_flag"));
            this.COARequestCheckBox.setSelected((Boolean)this.item.get("coa_request_flag"));
            this.ReplaceAttrCheckBox.setSelected((Boolean)this.item.get("replace_attr_flag"));
            this.EnableScriptingCheckBox.setSelected((Boolean)this.item.get("enable_scripting_flag"));
            this.RemoveAttrCheckBox.setSelected((Boolean)this.item.get("remove_attr_flag"));
            this.addIfNotExistsCheckBox.setSelected((Boolean)this.item.get("add_if_not_exists_flag"));
            this.valueValidator.setTunnel((Boolean)this.item.get("is_tunnel"));
            if ((Integer)this.item.get("expire_date") != 2000000000) {
                this.ActivateExpireCheckBox.setSelected(true);
                int n = (Integer)this.item.get("expire_date");
                this.ExpireDateTime.setDate(new Date((long)n * 1000L));
            }
        } else {
            this.AccessAcceptCheckBox.setSelected(true);
            this.stringRadioButton.setSelected(true);
            this.valueValidator.setDataType(1);
            this.valueValidator.setTunnel(false);
        }
    }

    private Object parseAttrValue(String string, int n) {
        if (n == 0) {
            return Integer.parseInt(string);
        }
        if (n == 2) {
            int n2 = 0;
            try {
                n2 = Resolve.parse_ip(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return n2;
        }
        return string;
    }

    @Override
    protected void saveInfo() throws UrfaException {
        this.item.put("vendor", Integer.parseInt(this.vendorTextField.getText()));
        this.item.put("attribute", Integer.parseInt(this.attributeTextField.getText()));
        this.item.put("param", this.valueValidator.getDataType());
        if (this.valueValidator.isTunnelAttr() && this.isValueTunnelParameterCheckBox.isSelected()) {
            String[] stringArray = this.valueTextField.getText().split(":");
            this.item.put("tag", Integer.parseInt(stringArray[1]));
            this.item.put("value", this.parseAttrValue(stringArray[2], this.valueValidator.getDataType()));
        } else {
            this.item.put("tag", 0);
            if (this.valueValidator.getDataType() == 2 && this.RemoveAttrCheckBox.isSelected()) {
                this.item.put("value", new Integer(0));
            } else {
                this.item.put("value", this.parseAttrValue(this.valueTextField.getText(), this.valueValidator.getDataType()));
            }
        }
        this.item.put("value_show", this.valueTextField.getText());
        this.item.put("access_accept_flag", this.AccessAcceptCheckBox.isSelected());
        this.item.put("access_reject_flag", this.AccessRejectCheckBox.isSelected());
        this.item.put("disconnect_request_flag", this.DisconnectRequestCheckBox.isSelected());
        this.item.put("coa_request_flag", this.COARequestCheckBox.isSelected());
        this.item.put("replace_attr_flag", this.ReplaceAttrCheckBox.isSelected());
        this.item.put("enable_scripting_flag", this.EnableScriptingCheckBox.isSelected());
        this.item.put("remove_attr_flag", this.RemoveAttrCheckBox.isSelected());
        this.item.put("add_if_not_exists_flag", this.addIfNotExistsCheckBox.isSelected());
        this.item.put("is_tunnel", this.valueValidator.getTunnel());
        if (this.ActivateExpireCheckBox.isSelected()) {
            this.item.put("expire_date", (int)(this.ExpireDateTime.getDate().getTime() / 1000L));
        } else {
            this.item.put("expire_date", 2000000000);
        }
    }

    protected void switchEnabledItems(boolean bl) {
        this.valueTextField.setEnabled(!bl);
        this.numberRadioButton.setEnabled(!bl);
        this.stringRadioButton.setEnabled(!bl);
        this.IPRadioButton.setEnabled(!bl);
        this.BinaryRadioButton.setEnabled(!bl);
        this.AccessAcceptCheckBox.setEnabled(!bl);
        this.AccessRejectCheckBox.setEnabled(!bl);
        this.DisconnectRequestCheckBox.setEnabled(!bl);
        this.COARequestCheckBox.setEnabled(!bl);
        this.ReplaceAttrCheckBox.setEnabled(!bl);
        this.EnableScriptingCheckBox.setEnabled(!bl);
        this.isValueTunnelParameterCheckBox.setEnabled(!bl);
        this.addIfNotExistsCheckBox.setEnabled(!bl);
    }

    private void checkRemoveAttrSwitch() {
        this.switchEnabledItems(this.RemoveAttrCheckBox.isSelected());
        this.RemoveAttrCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                RadiusDialogN.this.switchEnabledItems(abstractButton.getModel().isSelected());
            }
        });
    }

    private void checkExpiredUsage() {
        this.ExpireDateTime.setEnabled(this.ActivateExpireCheckBox.isSelected());
        this.ActivateExpireCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                RadiusDialogN.this.ExpireDateTime.setEnabled(abstractButton.getModel().isSelected());
            }
        });
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.checkExpiredUsage();
        this.checkRemoveAttrSwitch();
        this.checkInt(this.vendorTextField, "Vendor");
        if (this.item.get("tag") != null) {
            this.setEnabledStateForContainer(this.typePanel, (Integer)this.item.get("tag") == 0);
        } else {
            this.setEnabledStateForContainer(this.typePanel, true);
        }
        if (!this.settingListeners) {
            if (!this.valueValidator.check()) {
                Dialogs.showErrorDialog(this.resource.getString("Value") + " " + this.resource.getString("field is invalid"));
                throw new IllegalStateException("");
            }
            if (!this.idValiadator.check()) {
                Dialogs.showErrorDialog(this.resource.getString("ID") + " " + this.resource.getString("field is invalid"));
                throw new IllegalStateException("");
            }
        }
    }

    private void $$$setupUI$$$() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.panel, "Center");
        this.typePanel = new JPanel();
        this.typePanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.panel.add((Component)this.typePanel, gridBagConstraints);
        this.typePanel.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Type")));
        this.numberRadioButton = new JRadioButton();
        this.numberRadioButton.setSelected(true);
        this.$$$loadButtonText$$$(this.numberRadioButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.typePanel.add((Component)this.numberRadioButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.typePanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 3;
        this.typePanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.typePanel.add((Component)jPanel4, gridBagConstraints);
        this.stringRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(this.stringRadioButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("String"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.typePanel.add((Component)this.stringRadioButton, gridBagConstraints);
        this.IPRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(this.IPRadioButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("IP"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.typePanel.add((Component)this.IPRadioButton, gridBagConstraints);
        this.BinaryRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(this.BinaryRadioButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Binary"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.typePanel.add((Component)this.BinaryRadioButton, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 3;
        this.typePanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        this.typePanel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.typePanel.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)jPanel8, gridBagConstraints);
        this.eventPanel = new JPanel();
        this.eventPanel.setLayout(new GridBagLayout());
        this.eventPanel.setEnabled(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.panel.add((Component)this.eventPanel, gridBagConstraints);
        this.eventPanel.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Use In")));
        this.AccessAcceptCheckBox = new JCheckBox();
        this.AccessAcceptCheckBox.setText("Access-Accept");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.eventPanel.add((Component)this.AccessAcceptCheckBox, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.eventPanel.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 3;
        this.eventPanel.add((Component)jPanel10, gridBagConstraints);
        this.AccessRejectCheckBox = new JCheckBox();
        this.AccessRejectCheckBox.setText("Access-Reject");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.eventPanel.add((Component)this.AccessRejectCheckBox, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.eventPanel.add((Component)jPanel11, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        this.eventPanel.add((Component)jPanel12, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 3;
        this.eventPanel.add((Component)jPanel13, gridBagConstraints);
        this.DisconnectRequestCheckBox = new JCheckBox();
        this.DisconnectRequestCheckBox.setText("Disconnect-Request");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.eventPanel.add((Component)this.DisconnectRequestCheckBox, gridBagConstraints);
        this.COARequestCheckBox = new JCheckBox();
        this.COARequestCheckBox.setText("CoA-Request");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.eventPanel.add((Component)this.COARequestCheckBox, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.eventPanel.add((Component)jPanel14, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 3;
        this.panel.add((Component)jPanel15, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        this.panel.add((Component)jPanel16, gridBagConstraints);
        this.usagePanel = new JPanel();
        this.usagePanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.panel.add((Component)this.usagePanel, gridBagConstraints);
        this.usagePanel.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Usage Settings")));
        this.ReplaceAttrCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.ReplaceAttrCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Replace Attribute"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.usagePanel.add((Component)this.ReplaceAttrCheckBox, gridBagConstraints);
        JPanel jPanel17 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.usagePanel.add((Component)jPanel17, gridBagConstraints);
        JPanel jPanel18 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        this.usagePanel.add((Component)jPanel18, gridBagConstraints);
        this.EnableScriptingCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.EnableScriptingCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Enable Scripting"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.usagePanel.add((Component)this.EnableScriptingCheckBox, gridBagConstraints);
        this.RemoveAttrCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.RemoveAttrCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Remove Attribute"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.usagePanel.add((Component)this.RemoveAttrCheckBox, gridBagConstraints);
        JPanel jPanel19 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.usagePanel.add((Component)jPanel19, gridBagConstraints);
        this.addIfNotExistsCheckBox = new JCheckBox();
        this.addIfNotExistsCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(this.addIfNotExistsCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add if not exists"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.usagePanel.add((Component)this.addIfNotExistsCheckBox, gridBagConstraints);
        JPanel jPanel20 = new JPanel();
        jPanel20.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.panel.add((Component)jPanel20, gridBagConstraints);
        jPanel20.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Expire Settings")));
        this.ExpireDateTime = new JDateTime();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        jPanel20.add((Component)this.ExpireDateTime, gridBagConstraints);
        JPanel jPanel21 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel20.add((Component)jPanel21, gridBagConstraints);
        JPanel jPanel22 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel20.add((Component)jPanel22, gridBagConstraints);
        JPanel jPanel23 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel20.add((Component)jPanel23, gridBagConstraints);
        JPanel jPanel24 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel20.add((Component)jPanel24, gridBagConstraints);
        this.ActivateExpireCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.ActivateExpireCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Use Expire"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel20.add((Component)this.ActivateExpireCheckBox, gridBagConstraints);
        this.usagePanelSpacer = new JPanel();
        this.usagePanelSpacer.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.panel.add((Component)this.usagePanelSpacer, gridBagConstraints);
        JPanel jPanel25 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.usagePanelSpacer.add((Component)jPanel25, gridBagConstraints);
        this.mainParamsPanel = new JPanel();
        this.mainParamsPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.panel.add((Component)this.mainParamsPanel, gridBagConstraints);
        this.vendorTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainParamsPanel.add((Component)this.vendorTextField, gridBagConstraints);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Vendor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainParamsPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel26 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.mainParamsPanel.add((Component)jPanel26, gridBagConstraints);
        this.attributeTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainParamsPanel.add((Component)this.attributeTextField, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Attribute"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainParamsPanel.add((Component)jLabel2, gridBagConstraints);
        JPanel jPanel27 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 3;
        this.mainParamsPanel.add((Component)jPanel27, gridBagConstraints);
        JPanel jPanel28 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.mainParamsPanel.add((Component)jPanel28, gridBagConstraints);
        this.valueTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.mainParamsPanel.add((Component)this.valueTextField, gridBagConstraints);
        JPanel jPanel29 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        this.mainParamsPanel.add((Component)jPanel29, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Value"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        this.mainParamsPanel.add((Component)jLabel3, gridBagConstraints);
        this.isValueTunnelParameterCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.isValueTunnelParameterCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Is value tunnel parameter"));
        this.isValueTunnelParameterCheckBox.setVisible(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.mainParamsPanel.add((Component)this.isValueTunnelParameterCheckBox, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

