/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.custom.radius;

import biz.netup.utmutils.control.resolvers.Resolve;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

class RadiusAttrValueValidator
implements DocumentListener {
    private JTextField tf;
    private int dataType;
    private JPanel typePanel;
    private JRadioButton numberRadioButton;
    private JRadioButton stringRadioButton;
    private JRadioButton ipRadioButton;
    private JRadioButton binaryRadioButton;
    private JCheckBox isTunnelCheckBox_;
    private JCheckBox isRemoveAttrCheckBox_;
    private AttrDesc attrDesc;
    private int attrId;
    private boolean isTunnel_;
    private AttrDesc[] tunnelAttrs = new AttrDesc[]{new AttrDesc(64, 0), new AttrDesc(65, 0), new AttrDesc(66, 1), new AttrDesc(67, 1), new AttrDesc(69, 1), new AttrDesc(81, 1), new AttrDesc(82, 1), new AttrDesc(83, 0), new AttrDesc(90, 1), new AttrDesc(91, 1)};

    public int getDataType() {
        return this.dataType;
    }

    public void setTunnelCheckBox(JCheckBox jCheckBox) {
        this.isTunnelCheckBox_ = jCheckBox;
    }

    public void setRemoveAttrCheckBox(JCheckBox jCheckBox) {
        this.isRemoveAttrCheckBox_ = jCheckBox;
    }

    public void setTunnel(boolean bl) {
        this.isTunnel_ = bl;
        this.isTunnelCheckBox_.setSelected(bl);
        this.setAttrId(this.attrId);
    }

    public boolean getTunnel() {
        return this.isTunnel_;
    }

    public boolean isTunnelAttr() {
        for (AttrDesc attrDesc : this.tunnelAttrs) {
            if (attrDesc.id != this.attrId) continue;
            return true;
        }
        return false;
    }

    public void setTypeRB(JRadioButton jRadioButton, JRadioButton jRadioButton2, JRadioButton jRadioButton3, JRadioButton jRadioButton4) {
        this.numberRadioButton = jRadioButton;
        this.stringRadioButton = jRadioButton2;
        this.ipRadioButton = jRadioButton3;
        this.binaryRadioButton = jRadioButton4;
    }

    public RadiusAttrValueValidator(JTextField jTextField, JPanel jPanel) {
        this.tf = jTextField;
        this.typePanel = jPanel;
    }

    private void setEnabledStateForContainer(Container container, boolean bl) {
        for (Component component : container.getComponents()) {
            if (component instanceof JPanel) {
                this.setEnabledStateForContainer((Container)component, bl);
                continue;
            }
            if (component instanceof JLabel) continue;
            if (component instanceof JButton) {
                component.setEnabled(bl);
                continue;
            }
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).setEditable(bl);
                continue;
            }
            component.setEnabled(bl);
        }
    }

    public boolean setAttrId(int n) {
        this.attrId = n;
        this.isTunnelCheckBox_.setVisible(this.isTunnelAttr());
        if (!this.isTunnelAttr()) {
            this.isTunnel_ = false;
            this.isTunnelCheckBox_.setSelected(false);
        }
        this.attrDesc = null;
        if (this.isTunnel_) {
            for (int i = 0; i < this.tunnelAttrs.length; ++i) {
                if (this.tunnelAttrs[i].id != this.attrId) continue;
                this.attrDesc = this.tunnelAttrs[i];
            }
        }
        this.setEnabledStateForContainer(this.typePanel, this.attrDesc == null);
        if (this.attrDesc != null) {
            if (this.attrDesc.dataType == 0) {
                this.numberRadioButton.setSelected(true);
            } else if (this.attrDesc.dataType == 1) {
                this.stringRadioButton.setSelected(true);
            } else if (this.attrDesc.dataType == 2) {
                this.ipRadioButton.setSelected(true);
            } else if (this.attrDesc.dataType == 3) {
                this.binaryRadioButton.setSelected(true);
            }
        }
        this.check();
        return this.attrDesc != null;
    }

    public void setDataType(int n) {
        this.dataType = n;
        this.check();
    }

    private boolean checkInt(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.tf.setBackground(new Color(255, 204, 204));
            return false;
        }
        return true;
    }

    private boolean checkBinary(String string) {
        if (string.length() % 2 != 0 || !string.matches("\\p{XDigit}+")) {
            this.tf.setBackground(new Color(255, 204, 204));
            return false;
        }
        return true;
    }

    private boolean checkIp(String string) {
        this.tf.setBackground(Color.WHITE);
        try {
            if (this.tf.getText().isEmpty()) {
                throw new IllegalArgumentException("empty");
            }
            Resolve.IPAddressValidator iPAddressValidator = new Resolve.IPAddressValidator();
            if (!iPAddressValidator.validate(string, Resolve.IPAddressValidator.IpType.TYPE_IPV4)) {
                throw new IllegalArgumentException("illegal format");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.tf.setBackground(new Color(255, 204, 204));
            return false;
        }
        return true;
    }

    private boolean checkValue(String string, int n) {
        if (this.isRemoveAttrCheckBox_.isSelected()) {
            return true;
        }
        if (n == 0) {
            return this.checkInt(string);
        }
        if (n == 3) {
            return this.checkBinary(string);
        }
        if (n == 2) {
            return this.checkIp(string);
        }
        return string.length() != 0;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.check();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.check();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.check();
    }

    public boolean check() {
        this.tf.setBackground(Color.WHITE);
        if (this.isRemoveAttrCheckBox_.isSelected()) {
            return true;
        }
        String string = this.tf.getText();
        if (this.attrDesc != null) {
            Pattern pattern = Pattern.compile(":[0-9]{1,2}:.{1,}");
            if (!pattern.matcher(string).matches()) {
                this.tf.setBackground(new Color(255, 204, 204));
                return false;
            }
            String[] stringArray = string.split(":");
            int n = Integer.parseInt(stringArray[1]);
            if (n > 31) {
                this.tf.setBackground(new Color(255, 204, 204));
                return false;
            }
            this.dataType = this.attrDesc.dataType;
            return this.checkValue(stringArray[2], this.attrDesc.dataType);
        }
        return this.checkValue(string, this.dataType);
    }

    private class AttrDesc {
        public int id;
        public int dataType;

        AttrDesc(int n, int n2) {
            this.id = n;
            this.dataType = n2;
        }
    }
}

