/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.custom.radius;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.swing.table.ComboBoxCellEditor;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.swing.dialog.DialogModel;
import biz.netup.utmutils.swing.dialogs.Dialogs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public class NasSettingsDialog
extends DialogModel {
    private TablePanelImpl optionsTablePanel;
    private JPanel mainPanel;
    private JButton deleteButton;
    private JButton addButton;
    Variable[] variables;

    private boolean checkDublicates(String string) {
        int n = 0;
        MapTableModel mapTableModel = this.optionsTablePanel.getTableModel();
        int n2 = mapTableModel.getRowCount();
        for (int i = 0; i < n2; ++i) {
            String string2 = mapTableModel.getRow(i).get("name").toString();
            if (!string2.equals(string) || ++n <= 1) continue;
            return false;
        }
        return true;
    }

    public boolean checkValue(String string, String string2) {
        int n = 5;
        for (int i = 0; i < this.variables.length; ++i) {
            if (!this.variables[i].name.equals(string)) continue;
            n = this.variables[i].dataType;
        }
        if (string2.isEmpty() && n != 2) {
            return false;
        }
        String string3 = string2.toLowerCase();
        if (n == 3) {
            return string3.equals("true") || string3.equals("1") || string3.equals("false") || string3.equals("0");
        }
        if (n == 1) {
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (n == 4) {
            try {
                Pattern.compile(string2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return false;
            }
        }
        return true;
    }

    private void createUIComponents() {
        this.variables = new Variable[]{new Variable("radius_auth_vap", 3), new Variable("radius_auth_h323_remote_address", 3), new Variable("radius_card_autoadd", 3), new Variable("send_xpgk_ep_number", 3), new Variable("send_h323_ivr_in", 3), new Variable("radius_callback_avpair_enable", 3), new Variable("radius_acct_rewrite_login_answer", 3), new Variable("radius_acct_rewrite_login_originate", 3), new Variable("override_service_type", 3), new Variable("interim_update_interval", 1), new Variable("radius_default_session_timeout", 1), new Variable("radius_ippool_acct_timeout", 1), new Variable("radius_ippool_timeout", 1), new Variable("tel_session_timeout", 1), new Variable("blocked_pool_name", 2), new Variable("guest_pool_name", 2), new Variable("h323_currency", 2), new Variable("h323_origin_reject", 2), new Variable("incoming_trunk_format", 4), new Variable("outgoing_trunk_format", 4), new Variable("pbx_id_format", 4)};
        this.optionsTablePanel = new TablePanelImpl("NasSettingsTab", true);
        this.optionsTablePanel.getTable().getTableHeader().setReorderingAllowed(false);
        this.optionsTablePanel.setSortingEnabled(false);
        MapTableModel mapTableModel = this.optionsTablePanel.getTableModel();
        mapTableModel.addColumn("name", "Name", true, true);
        mapTableModel.addColumn("value", "Value", true, true);
        this.optionsTablePanel.setEditable(true);
        this.optionsTablePanel.setAppendable(false);
        this.optionsTablePanel.setColumnsMenuEnabled(false);
        this.optionsTablePanel.configureTable();
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setEditable(true);
        for (int i = 0; i < this.variables.length; ++i) {
            jComboBox.addItem(this.variables[i].name);
        }
        this.optionsTablePanel.setCellEditor("name", new ComboBoxCellEditor(jComboBox, true, true));
        ValidateCellRenderer validateCellRenderer = new ValidateCellRenderer(this);
        this.optionsTablePanel.setCellRenderer("name", validateCellRenderer);
        this.optionsTablePanel.setCellRenderer("value", validateCellRenderer);
        this.optionsTablePanel.addCellEditListeners(new ValidateCellEditor(this));
    }

    public NasSettingsDialog() {
        this.$$$setupUI$$$();
    }

    public NasSettingsDialog(Map<String, Object> map) {
        super(map);
        this.getSurroundPanel().setBorder(BorderFactory.createEmptyBorder());
        Dimension dimension = new Dimension(400, 400);
        this.setSize(dimension);
        this.setMinimumSize(dimension);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension3 = this.getSize();
        this.setLocation((dimension2.width - dimension3.width) / 2, (dimension2.height - dimension3.height) / 2);
    }

    public void setSettings(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("name", entry.getKey());
            hashMap.put("value", entry.getValue());
            this.optionsTablePanel.getTableModel().addRow(hashMap);
        }
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("name", "");
                hashMap.put("value", "");
                NasSettingsDialog.this.optionsTablePanel.getTableModel().addRow(hashMap);
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (Map<String, Object> map : NasSettingsDialog.this.optionsTablePanel.getSelectedTableRows()) {
                    NasSettingsDialog.this.optionsTablePanel.getTableModel().removeRow(map);
                }
            }
        });
        return this.mainPanel;
    }

    public Map<String, String> getSettings() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = this.optionsTablePanel.getTableModel().getRowCount();
        for (int i = 0; i < n; ++i) {
            Map<String, Object> map = this.optionsTablePanel.getTableModel().getRow(i);
            hashMap.put(map.get("name").toString(), map.get("value").toString());
        }
        return hashMap;
    }

    @Override
    public String getItemName() {
        return "NAS settings";
    }

    @Override
    protected void loadInfo() throws UrfaException {
    }

    @Override
    protected void saveInfo() throws UrfaException {
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        if (this.settingListeners) {
            return;
        }
        int n = this.optionsTablePanel.getTableModel().getRowCount();
        for (int i = 0; i < n; ++i) {
            String string = this.optionsTablePanel.getTableModel().getRow(i).get("name").toString();
            String string2 = this.optionsTablePanel.getTableModel().getRow(i).get("value").toString();
            if (string.equals("")) {
                Dialogs.showErrorDialog(this.resource.getString(this.getItemName()) + ": " + this.resource.getString("table data is invalid"));
                throw new IllegalArgumentException("");
            }
            if (!this.checkDublicates(string)) {
                Dialogs.showErrorDialog(this.resource.getString(this.getItemName()) + ": " + this.resource.getString("table data is invalid"));
                throw new IllegalArgumentException("");
            }
            if (this.checkValue(string, string2)) continue;
            Dialogs.showErrorDialog(this.resource.getString(this.getItemName()) + ": " + this.resource.getString("table data is invalid"));
            throw new IllegalArgumentException("");
        }
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout(0, 0));
        this.mainPanel.add((Component)this.optionsTablePanel, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)jPanel, "North");
        this.deleteButton = new JButton();
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/delete16.png")));
        this.$$$loadButtonText$$$(this.deleteButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Delete"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.deleteButton, gridBagConstraints);
        this.addButton = new JButton();
        this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/add16.png")));
        this.$$$loadButtonText$$$(this.addButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.addButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel6, gridBagConstraints);
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    class ValidateCellRenderer
    extends DefaultTableCellRenderer {
        private NasSettingsDialog owner;

        ValidateCellRenderer(NasSettingsDialog nasSettingsDialog2) {
            this.owner = nasSettingsDialog2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = NasSettingsDialog.this.optionsTablePanel.getTableModel().getRow(n).get("name").toString();
            String string2 = NasSettingsDialog.this.optionsTablePanel.getTableModel().getRow(n).get("value").toString();
            if (!this.owner.checkDublicates(string)) {
                super.setBackground(new Color(255, 110, 98));
            } else {
                boolean bl3 = !string.equals("") && this.owner.checkValue(string, string2);
                super.setBackground(bl3 ? Color.WHITE : new Color(255, 204, 204));
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        @Override
        public void setBackground(Color color) {
        }

        @Override
        public void setForeground(Color color) {
        }
    }

    class ValidateCellEditor
    implements TablePanelImpl.CellEditingListener {
        private boolean nameValidatorSet;
        private boolean valueValidatorSet;
        private ValueValidator valValidator;
        private VariableValidator varValidator;

        public ValidateCellEditor(NasSettingsDialog nasSettingsDialog2) {
            this.valValidator = new ValueValidator(nasSettingsDialog2);
            this.varValidator = new VariableValidator(nasSettingsDialog2);
        }

        @Override
        public void BeginCellEditing(int n, int n2, TableCellEditor tableCellEditor) {
            Object object;
            String string = NasSettingsDialog.this.optionsTablePanel.getTableModel().getColumnName(n);
            if (string.equals(NasSettingsDialog.this.resource.getString("Name"))) {
                if (!this.nameValidatorSet) {
                    object = (JComboBox)tableCellEditor.getTableCellEditorComponent(NasSettingsDialog.this.optionsTablePanel.getTable(), null, true, n2, n);
                    JTextField jTextField = (JTextField)((JComboBox)object).getEditor().getEditorComponent();
                    this.varValidator.init(jTextField, (JComboBox)object);
                    this.nameValidatorSet = true;
                }
                object = NasSettingsDialog.this.optionsTablePanel.getTableModel().getRow(n2).get("value").toString();
                this.varValidator.setValue((String)object);
            }
            if (string.equals(NasSettingsDialog.this.resource.getString("Value"))) {
                if (!this.valueValidatorSet) {
                    object = (JTextField)tableCellEditor.getTableCellEditorComponent(NasSettingsDialog.this.optionsTablePanel.getTable(), null, true, n2, n);
                    this.valValidator.init((JTextField)object);
                    this.valueValidatorSet = true;
                }
                object = NasSettingsDialog.this.optionsTablePanel.getTableModel().getRow(n2).get("name").toString();
                this.valValidator.setVariable((String)object);
            }
        }

        @Override
        public void EndCellEditing(int n, int n2, Object object) {
            NasSettingsDialog.this.optionsTablePanel.repaint();
        }
    }

    private class VariableValidator
    implements DocumentListener {
        private JTextField tf;
        private JComboBox cb;
        private NasSettingsDialog owner;
        private String value;

        public VariableValidator(NasSettingsDialog nasSettingsDialog2) {
            this.owner = nasSettingsDialog2;
        }

        public void setValue(String string) {
            this.value = string;
            this.check();
        }

        public void init(JTextField jTextField, JComboBox jComboBox) {
            this.tf = jTextField;
            this.cb = jComboBox;
            this.tf.setBackground(new Color(255, 204, 204));
            this.owner.setBackground(new Color(255, 204, 204));
            this.tf.getDocument().addDocumentListener(this);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.check();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.check();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.check();
        }

        public void check() {
            String string = this.tf.getText();
            if (!this.owner.checkDublicates(string)) {
                this.tf.setBackground(new Color(255, 110, 98));
                this.cb.setBackground(new Color(255, 110, 98));
            } else {
                boolean bl;
                boolean bl2 = bl = !string.equals("") && this.owner.checkDublicates(string) && this.owner.checkValue(string, this.value);
                if (!bl) {
                    this.tf.setBackground(new Color(255, 204, 204));
                    this.cb.setBackground(new Color(255, 204, 204));
                } else {
                    this.tf.setBackground(Color.WHITE);
                    this.cb.setBackground(Color.WHITE);
                }
            }
        }
    }

    private class ValueValidator
    implements DocumentListener {
        private JTextField tf;
        private NasSettingsDialog owner;
        private String variable;

        public ValueValidator(NasSettingsDialog nasSettingsDialog2) {
            this.owner = nasSettingsDialog2;
        }

        public void setVariable(String string) {
            this.variable = string;
            this.check();
        }

        public void init(JTextField jTextField) {
            this.tf = jTextField;
            this.tf.getDocument().addDocumentListener(this);
            this.tf.setBackground(new Color(255, 204, 204));
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.check();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.check();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.check();
        }

        public void check() {
            if (!this.owner.checkDublicates(this.variable)) {
                this.tf.setBackground(new Color(255, 110, 98));
            } else {
                boolean bl = !this.variable.equals("") && this.owner.checkValue(this.variable, this.tf.getText());
                this.tf.setBackground(!bl ? new Color(255, 204, 204) : Color.WHITE);
            }
        }
    }

    private class Variable {
        public String name;
        public int dataType;

        public Variable(String string, int n) {
            this.name = string;
            this.dataType = n;
        }
    }

    private class DataType {
        public static final int INT = 1;
        public static final int STRING = 2;
        public static final int BOOL = 3;
        public static final int REGEXP = 4;
        public static final int DEFAULT = 5;

        private DataType() {
        }
    }
}

