/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.custom.invoice;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaNewInvoice;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.user.doc.DocFunctions;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.ap.MainAPTab;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.ap.MainAllAPTab;
import biz.netup.swing.table.DoubleCellEditor;
import biz.netup.swing.table.IntegerCellEditor;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.ArrayFromVector;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DialogModel;
import biz.netup.utmutils.swing.dialog.SelectFromTableDialogModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InvoiceDialog
extends DialogModel {
    private JPanel panel1;
    private JButton removeButton;
    private JButton addButton;
    private TablePanelImpl mainTablePanel;
    private JPanel apPanel;
    private JCheckBox useAccPeriodCheckBox;
    private JTextField accPeriodTextField;
    private int accPeriod;

    public InvoiceDialog() {
        this.$$$setupUI$$$();
    }

    public InvoiceDialog(Map<String, Object> map) {
        super(map);
    }

    private void createUIComponents() {
        this.createTable();
    }

    private void createTable() {
        this.mainTablePanel = new TablePanelImpl(this.getClass().getName() + "_invoice", true);
        MapTableModel mapTableModel = this.mainTablePanel.getTableModel();
        mapTableModel.addColumn("position_name", "Position name", true, true);
        mapTableModel.addColumn("quantity", "Quantity", true, true);
        mapTableModel.addColumn("cost_per_unit", "Cost per unit", true, true);
        mapTableModel.addColumn("cost", "Cost", true, false);
        this.mainTablePanel.setEditable(true);
        this.mainTablePanel.setAppendable(false);
        this.mainTablePanel.applyTableSettings();
        this.mainTablePanel.setCellEditor("quantity", new IntegerCellEditor());
        this.mainTablePanel.setCellEditor("cost_per_unit", new DoubleCellEditor());
        this.mainTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public void performRowModified(Map<String, Object> map) {
                map.put("cost", (Double)map.get("cost_per_unit") * (double)((Integer)map.get("quantity")).intValue());
            }
        });
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        this.useAccPeriodCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!InvoiceDialog.this.useAccPeriodCheckBox.isSelected()) {
                    InvoiceDialog.this.accPeriod = 0;
                    InvoiceDialog.this.accPeriodTextField.setText("");
                    return;
                }
                SelectFromTableDialogModel selectFromTableDialogModel = UrfaManagerImpl.getInstance().isPermitted(9735) ? new SelectFromTableDialogModel(new MainAllAPTab()) : new SelectFromTableDialogModel(new MainAPTab());
                selectFromTableDialogModel.setVisible(true);
                if (selectFromTableDialogModel.isOkPressed()) {
                    InvoiceDialog.this.accPeriod = (Integer)selectFromTableDialogModel.getItem().get("serial_id");
                    InvoiceDialog.this.accPeriodTextField.setText(Resolve.getAPName(InvoiceDialog.this.accPeriod));
                } else {
                    InvoiceDialog.this.useAccPeriodCheckBox.setSelected(false);
                }
            }
        });
        return this.panel1;
    }

    @Override
    public String getItemName() {
        return "Invoice";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("position_name", "---");
                hashMap.put("quantity", 0);
                hashMap.put("cost_per_unit", 0.0);
                hashMap.put("cost", 0.0);
                InvoiceDialog.this.mainTablePanel.getTableModel().addRow(hashMap);
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (Map<String, Object> map : InvoiceDialog.this.mainTablePanel.getSelectedTableRows()) {
                    InvoiceDialog.this.mainTablePanel.getTableModel().removeRow(map);
                }
            }
        });
        this.mainTablePanel.registerMultiRowButton(this.removeButton);
    }

    @Override
    protected void saveInfo() throws UrfaException {
        UrfaNewInvoice urfaNewInvoice = new UrfaNewInvoice(UrfaManagerImpl.getInstance());
        urfaNewInvoice.setAccountId((Integer)this.item.get("aid"));
        urfaNewInvoice.setGenDate((int)(new Date().getTime() / 1000L));
        urfaNewInvoice.setApId(this.accPeriod);
        urfaNewInvoice.setName1(ArrayFromVector.getStringArrayFromData(this.mainTablePanel.getTableModel().data, "position_name"));
        urfaNewInvoice.setBaseCost1(ArrayFromVector.getDoubleArrayFromData(this.mainTablePanel.getTableModel().data, "cost_per_unit"));
        double[] dArray = new double[this.mainTablePanel.getTableModel().data.size()];
        for (int i = 0; i < this.mainTablePanel.getTableModel().data.size(); ++i) {
            dArray[i] = ArrayFromVector.getIntArrayFromData(this.mainTablePanel.getTableModel().data, "quantity")[i];
        }
        urfaNewInvoice.setQnt1(dArray);
        urfaNewInvoice.setSumCost1(ArrayFromVector.getDoubleArrayFromData(this.mainTablePanel.getTableModel().data, "cost"));
        urfaNewInvoice.call();
        if (urfaNewInvoice.getId() > 0) {
            try {
                DocFunctions.openDocument((Integer)this.item.get("uid"), 1, urfaNewInvoice.getId());
            }
            catch (UrfaException urfaException) {
                this.log.error(urfaException);
            }
        }
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.checkTablePanel(this.mainTablePanel, "Invoice");
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.panel1 = new JPanel();
        this.panel1.setLayout(new BorderLayout(0, 0));
        this.panel1.setMinimumSize(new Dimension(500, 300));
        this.panel1.setPreferredSize(new Dimension(500, 300));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.panel1.add((Component)jPanel, "North");
        this.apPanel = new JPanel();
        this.apPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.apPanel, gridBagConstraints);
        this.useAccPeriodCheckBox = new JCheckBox();
        this.useAccPeriodCheckBox.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.apPanel.add((Component)this.useAccPeriodCheckBox, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.apPanel.add((Component)jPanel2, gridBagConstraints);
        this.accPeriodTextField = new JTextField();
        this.accPeriodTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.apPanel.add((Component)this.accPeriodTextField, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.apPanel.add((Component)jPanel3, gridBagConstraints);
        this.addButton = new JButton();
        this.$$$loadButtonText$$$(this.addButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.addButton, gridBagConstraints);
        this.removeButton = new JButton();
        this.$$$loadButtonText$$$(this.removeButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Remove"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.removeButton, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel6, gridBagConstraints);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Accounting period"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel8, gridBagConstraints);
        this.panel1.add((Component)this.mainTablePanel, "Center");
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.panel1;
    }
}

