/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.functions.objects.telephonyServ;

import biz.netup.projects.utmadmin.functions.objects.Service;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.Utils;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;

public class TelephonyService
extends Service {
    private static final boolean debug = true;
    private int periodic_type;
    private int discount_method;
    private Date start_date;
    private Date expire_date;
    private int max_timeout;
    private double periodic_cost;
    private int radius_sessions_limit;
    public TreeMap costs;
    private Vector trs;
    public TreeMap borders;
    private Logger log = Utils.getLogger();
    private long unit_size;
    private long free_time;
    private long size_begin_interval;
    private long first_interval;
    private long incremental_interval;
    private double fixed_call_cost;

    public TelephonyService() {
        super(6);
        this.costs = new TreeMap();
        this.trs = new Vector();
        this.borders = new TreeMap();
    }

    public int getPeriodicType() {
        return this.periodic_type;
    }

    public int getDiscountMethod() {
        return this.discount_method;
    }

    public Date getStartDate() {
        return this.start_date;
    }

    public Date getExpireDate() {
        return this.expire_date;
    }

    public int getMaxTimeout() {
        return this.max_timeout;
    }

    public double getFixCallCost() {
        return this.fixed_call_cost;
    }

    public long getFreeTime() {
        return this.free_time;
    }

    public long getUnitSize() {
        return this.unit_size;
    }

    public long getSizeBegInt() {
        return this.size_begin_interval;
    }

    public long getFirstInt() {
        return this.first_interval;
    }

    public long getIncrInt() {
        return this.incremental_interval;
    }

    public int getRadSessLimit() {
        return this.radius_sessions_limit;
    }

    public void setDiscountMethod(int n) {
        this.discount_method = n;
    }

    public void setStartDate(Date date) {
        this.start_date = date;
    }

    public void setExpireDate(Date date) {
        this.expire_date = date;
    }

    public void setMaxTimeout(int n) {
        this.max_timeout = n;
    }

    public void setFixCallCost(double d) {
        this.fixed_call_cost = d;
    }

    public void setFreeTime(long l) {
        this.free_time = l;
    }

    public void setUnitSize(long l) {
        this.unit_size = l;
    }

    public void setSizeBegInt(long l) {
        this.size_begin_interval = l;
    }

    public void setFirstInt(long l) {
        this.first_interval = l;
    }

    public void setIncrInt(long l) {
        this.incremental_interval = l;
    }

    public void setRadSessLimit(int n) {
        this.radius_sessions_limit = n;
    }

    public void setPeriodicCost(double d) {
        this.periodic_cost = d;
    }

    public double getPeriodicCost() {
        return this.periodic_cost;
    }

    public int getDirsCount() {
        return this.costs.size();
    }

    public int getTRsCount() {
        return this.trs.size();
    }

    public int getDirID(int n) {
        if (this.costs.size() == 0) {
            return 0;
        }
        int n2 = n;
        for (Integer n3 : this.costs.keySet()) {
            if (n2-- != 0) continue;
            return n3;
        }
        System.out.println("request for illegal row " + n);
        return 0;
    }

    public int getTRID(int n) {
        int n2 = n - 1;
        if (this.trs.size() <= n2) {
            return 0;
        }
        return (Integer)this.trs.get(n2);
    }

    public Double getCost(int n, int n2) {
        return (Double)((TreeMap)this.costs.get(new Integer(n))).get(new Integer(n2));
    }

    public TreeMap getBorders(int n) {
        if (this.borders.containsKey(new Integer(n))) {
            return (TreeMap)this.borders.get(new Integer(n));
        }
        TreeMap<Long, Double> treeMap = new TreeMap<Long, Double>();
        treeMap.put(new Long(0L), new Double(1.0));
        return treeMap;
    }

    public boolean setBorders(int n, TreeMap treeMap) {
        Integer n2 = new Integer(n);
        if (!this.borders.containsKey(n2)) {
            this.borders.remove(n2);
        }
        this.borders.put(n2, treeMap);
        return true;
    }

    public boolean setCost(int n, int n2, double d) {
        Integer n3 = new Integer(n);
        Integer n4 = new Integer(n2);
        Double d2 = new Double(d);
        if (!this.costs.containsKey(n3)) {
            this.addDir(n);
        }
        if (!this.trs.contains(n4)) {
            this.addTR(n2);
        }
        ((TreeMap)this.costs.get(n3)).put(n4, d2);
        return true;
    }

    public void addDirZonesMultiple(Vector vector) {
        TreeMap treeMap = new TreeMap();
        for (Integer n : vector) {
            if (!this.costs.containsKey(n)) {
                System.out.println("Adding to tel service dir/zone:" + n);
                TreeMap<Integer, Double> treeMap2 = new TreeMap<Integer, Double>();
                Double d = new Double(0.0);
                for (int i = 0; i < this.trs.size(); ++i) {
                    treeMap2.put((Integer)this.trs.get(i), d);
                }
                treeMap.put(n, treeMap2);
                continue;
            }
            treeMap.put(n, this.costs.get(n));
        }
        this.costs = treeMap;
    }

    public Vector getCostKeys() {
        Vector<Integer> vector = new Vector<Integer>();
        Iterator iterator = this.costs.keySet().iterator();
        while (iterator.hasNext()) {
            vector.add((Integer)iterator.next());
        }
        return vector;
    }

    public boolean addDir(int n) {
        Integer n2 = new Integer(n);
        if (this.costs.containsKey(n2)) {
            System.out.println("Attempt to add one more dir/zone " + n);
            return false;
        }
        TreeMap<Integer, Double> treeMap = new TreeMap<Integer, Double>();
        Double d = new Double(0.0);
        for (int i = 0; i < this.trs.size(); ++i) {
            treeMap.put((Integer)this.trs.get(i), d);
        }
        this.costs.put(n2, treeMap);
        return true;
    }

    public boolean addTR(int n) {
        Integer n2 = new Integer(n);
        if (this.trs.contains(n2)) {
            System.out.println("Attempt to add one more timerange " + n);
            return false;
        }
        Double d = new Double(0.0);
        for (Integer n3 : this.costs.keySet()) {
            TreeMap treeMap = (TreeMap)this.costs.get(n3);
            treeMap.put(n2, d);
        }
        if (this.trs.size() == 0) {
            this.trs.add(n2);
        } else {
            boolean bl = false;
            for (int i = 0; i < this.trs.size(); ++i) {
                int n4 = (Integer)this.trs.get(i);
                if (n >= n4) continue;
                this.trs.add(i, n2);
                bl = true;
                break;
            }
            if (!bl) {
                this.trs.add(n2);
            }
        }
        return true;
    }

    public boolean removeDir(int n) {
        Integer n2 = new Integer(n);
        if (!this.costs.containsKey(n2)) {
            System.out.println("Attempt to remove not existing direction " + n);
            return false;
        }
        this.costs.remove(n2);
        return true;
    }

    public boolean removeTR(int n) {
        Integer n2 = new Integer(n);
        if (!this.trs.contains(n2)) {
            System.out.println("Attempt to remove not existing timerange " + n);
            return false;
        }
        for (Integer n3 : this.costs.keySet()) {
            TreeMap treeMap = (TreeMap)this.costs.get(n3);
            treeMap.remove(n2);
        }
        this.trs.remove(n2);
        return true;
    }

    public int Upload() {
        return this.Upload(this.sid);
    }

    public int Upload(int n) {
        this.costs.clear();
        if (n <= 0) {
            return -1;
        }
        this.sid = n;
        return 0;
    }

    public int Save() {
        return 0;
    }

    public void __save_stuff() throws Exception {
    }

    public void __save_costs() throws Exception {
    }

    public int Remove() {
        if (this.sid <= 0) {
            return -1;
        }
        if (Service.isUsed(this.sid)) {
            return -2;
        }
        return Service.__remove(this.sid);
    }

    @Override
    public String toString() {
        return "[TSD: sid=" + this.sid + " sn=" + this.service_name + " c=" + this.comment + "]";
    }

    public void print(String string) {
        System.out.println(string);
    }

    private void __error(String string) {
        System.out.println("[TelephonyService] Error: " + string);
    }

    private void DM(String string) {
        this.print(string);
    }

    private void dump() {
        this.print("Dump TelephonyService cost table:");
        this.print("Dirs count: " + this.costs.size());
        this.print("TRs count:  " + this.trs.size());
        for (Integer n : this.costs.keySet()) {
            TreeMap treeMap = (TreeMap)this.costs.get(n);
            this.print(" Dir: " + n.toString());
            for (Integer n2 : treeMap.keySet()) {
                Double d = (Double)treeMap.get(n2);
                this.print("   Dir: " + n.toString() + " tr: " + n2.toString() + " cost: " + d.toString());
            }
        }
        this.print("Dump end.");
    }
}

