/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.functions.objects;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetTelZones;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.utmutils.control.Utils;
import java.util.Date;
import java.util.Vector;

public class TelZone {
    protected int id = 0;
    protected String name;
    protected Date create_date;
    protected Vector dirs = new Vector();
    protected static Vector telzones;

    public boolean ok() {
        return this.id != 0;
    }

    public int getTZID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Date getCreateDate() {
        return this.create_date;
    }

    public int getDirsCnt() {
        return this.dirs.size();
    }

    public int getDir(int n) {
        return (Integer)this.dirs.get(n);
    }

    public Vector getDirs() {
        return this.dirs;
    }

    public void setTZID(int n) {
        this.id = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    private void setCreateDate(Date date) {
        this.create_date = date;
    }

    private void addDir(int n) {
        this.dirs.add(new Integer(n));
    }

    public boolean containsDir(int n) {
        for (int i = 0; i < this.dirs.size(); ++i) {
            if (n != (Integer)this.dirs.get(i)) continue;
            return true;
        }
        return false;
    }

    public boolean addDir(Vector vector) {
        if (vector.size() > 0) {
            Vector<Integer> vector2 = new Vector<Integer>();
            for (int i = 0; i < vector.size(); ++i) {
                int n = (Integer)vector.get(i);
                if (this.containsDir(n)) continue;
                vector2.add(new Integer(n));
            }
            if (vector2.size() > 0) {
                // empty if block
            }
        }
        return true;
    }

    public boolean removeDir(int n) {
        if (this.ok()) {
            // empty if block
        }
        for (int i = 0; i < this.dirs.size(); ++i) {
            if (this.getDir(i) != n) continue;
            this.dirs.removeElementAt(i);
            return true;
        }
        return true;
    }

    public int Save() {
        return 0;
    }

    public int Upload() {
        TelZone.uploadTelZones();
        for (int i = 0; i < telzones.size(); ++i) {
            TelZone telZone = (TelZone)telzones.get(i);
            if (telZone.getTZID() != this.id) continue;
            this.setTZID(telZone.getTZID());
            this.setName(telZone.getName());
            this.setCreateDate(telZone.getCreateDate());
            this.dirs = telZone.dirs;
            return 0;
        }
        return -1;
    }

    public static int parseTZName(String string, boolean bl) {
        TelZone.uploadTelZones(bl);
        for (int i = 0; i < telzones.size(); ++i) {
            TelZone telZone = (TelZone)telzones.get(i);
            if (string.compareTo(telZone.getName()) != 0) continue;
            return telZone.getTZID();
        }
        return 0;
    }

    public static String getTZName(int n, boolean bl) {
        TelZone.uploadTelZones(bl);
        for (int i = 0; i < telzones.size(); ++i) {
            TelZone telZone = (TelZone)telzones.get(i);
            if (n != telZone.getTZID()) continue;
            return telZone.getName();
        }
        return "Unknown tel zone";
    }

    public static Vector getTelZones(boolean bl) {
        if (telzones == null || bl) {
            TelZone.uploadTelZones();
        }
        return telzones;
    }

    public static void uploadTelZones(boolean bl) {
        if (telzones == null || bl) {
            TelZone.uploadTelZones();
        }
    }

    public static void uploadTelZones() {
        telzones = new Vector();
        try {
            UrfaGetTelZones urfaGetTelZones = new UrfaGetTelZones(UrfaManagerImpl.getInstance());
            urfaGetTelZones.call();
            int n = urfaGetTelZones.getZonesCount();
            for (int i = 0; i < n; ++i) {
                TelZone telZone = new TelZone();
                telZone.setTZID(urfaGetTelZones.getId1()[i]);
                telZone.setName(urfaGetTelZones.getName1()[i]);
                telZone.setCreateDate(new Date((long)urfaGetTelZones.getCreateDate1()[i] * 1000L));
                int n2 = urfaGetTelZones.getDirsSizeArray1()[i];
                for (int j = 0; j < n2; ++j) {
                    telZone.addDir(urfaGetTelZones.getDirsId2()[i][j]);
                }
                telzones.add(telZone);
            }
        }
        catch (UrfaException urfaException) {
            Utils.getLogger().log(0, "Error upload tel zones from server: " + urfaException.getMessage());
        }
    }

    public static boolean removeTelZone(int n) {
        return true;
    }
}

