/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.functions.dealer.main.usersandgroups.users;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDealerDeleteUser;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetUsersCount;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetUsersList;
import biz.netup.control.transport.urfa.functions.UrfaDealerSearchUsers;
import biz.netup.control.transport.urfa.functions.UrfaGetUsersCount;
import biz.netup.control.transport.urfa.functions.UrfaGetUsersList;
import biz.netup.control.transport.urfa.functions.UrfaRemoveUser;
import biz.netup.control.transport.urfa.functions.UrfaRemoveUserInt;
import biz.netup.control.transport.urfa.functions.UrfaSearchUsersInt;
import biz.netup.control.transport.urfa.functions.UrfaSearchUsersNew;
import biz.netup.control.transport.urfa.functions.UrfaUsersList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.objects.SearchConditions;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.resolvers.Resolve;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;

public class UsersFunctions {
    public static int getUsersCount(boolean bl) {
        if (Utils.isAdmin()) {
            UrfaGetUsersCount urfaGetUsersCount = new UrfaGetUsersCount(UrfaManagerImpl.getInstance());
            urfaGetUsersCount.setCardUser(bl ? 1 : 0);
            try {
                urfaGetUsersCount.call();
                return urfaGetUsersCount.getCount();
            }
            catch (UrfaException urfaException) {
                urfaException.printStackTrace();
                JOptionPane.showMessageDialog(null, "Error while getting users count: \n" + urfaException.getMessage(), "Error", 0);
                return 0;
            }
        }
        UrfaDealerGetUsersCount urfaDealerGetUsersCount = new UrfaDealerGetUsersCount(UrfaManagerImpl.getInstance());
        try {
            urfaDealerGetUsersCount.call();
            return urfaDealerGetUsersCount.getUsersCount();
        }
        catch (UrfaException urfaException) {
            urfaException.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error while getting users count: \n" + urfaException.getMessage(), "Error", 0);
            return 0;
        }
    }

    public static Vector<Map<String, Object>> getUsersTableData(int n, int n2, boolean bl) {
        Object object;
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        UrfaUsersList urfaUsersList = null;
        if (Utils.isAdmin()) {
            object = new UrfaGetUsersList(UrfaManagerImpl.getInstance());
            ((UrfaGetUsersList)object).setFrom(n);
            ((UrfaGetUsersList)object).setTo(n2 + 1);
            ((UrfaGetUsersList)object).setCardUser(bl ? 1 : 0);
            urfaUsersList = object;
        } else {
            object = new UrfaDealerGetUsersList(UrfaManagerImpl.getInstance());
            ((UrfaDealerGetUsersList)object).setFrom(n);
            ((UrfaDealerGetUsersList)object).setTo(n2);
            urfaUsersList = object;
        }
        try {
            urfaUsersList.call();
            object = urfaUsersList.getUsers();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                vector.add((Map<String, Object>)((Vector)object).get(i));
            }
        }
        catch (UrfaException urfaException) {
            urfaException.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error while getting users list: \n" + urfaException.getMessage(), "Error", 0);
        }
        return vector;
    }

    public static void deleteUser(int n) throws UrfaException {
        UrfaRemoveUserInt urfaRemoveUserInt = Utils.isAdmin() ? new UrfaRemoveUser(UrfaManagerImpl.getInstance()) : new UrfaDealerDeleteUser(UrfaManagerImpl.getInstance());
        urfaRemoveUserInt.setUserId(n);
        urfaRemoveUserInt.call();
        if (urfaRemoveUserInt.getResult() != 0) {
            throw new UrfaException("Remove all services first");
        }
    }

    public static Vector<Map<String, Object>> searchUsers(SearchConditions searchConditions) {
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        UrfaSearchUsersInt urfaSearchUsersInt = Utils.isAdmin() ? new UrfaSearchUsersNew(UrfaManagerImpl.getInstance()) : new UrfaDealerSearchUsers(UrfaManagerImpl.getInstance());
        urfaSearchUsersInt.setCriteriaId1(searchConditions.criteriaId.toArray(new Integer[0]));
        urfaSearchUsersInt.setDataPattern1(searchConditions.dataPattern.toArray(new Integer[0]));
        urfaSearchUsersInt.setPattern1(searchConditions.pattern.toArray(new String[0]));
        urfaSearchUsersInt.setPoleCodeArray1(searchConditions.poleCodeArray.toArray(new Integer[0]));
        urfaSearchUsersInt.setSelectType(searchConditions.selectType);
        urfaSearchUsersInt.setWhatId1(searchConditions.whatId.toArray(new Integer[0]));
        try {
            urfaSearchUsersInt.call();
            for (int i = 0; i < urfaSearchUsersInt.getUserDataSize(); ++i) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("Actual address", urfaSearchUsersInt.getActualAddress1()[i]);
                hashMap.put("address", urfaSearchUsersInt.getActualAddress1()[i]);
                hashMap.put("Building", urfaSearchUsersInt.getBuilding1()[i]);
                if (urfaSearchUsersInt.getCreateDate1()[i] != null) {
                    hashMap.put("Created on", new Date((long)urfaSearchUsersInt.getCreateDate1()[i].intValue() * 1000L));
                }
                hashMap.put("Accounting period ID", urfaSearchUsersInt.getDiscountPeriodId1()[i]);
                hashMap.put("District", urfaSearchUsersInt.getDistrict1()[i]);
                hashMap.put("E-mail", urfaSearchUsersInt.getEmail1()[i]);
                hashMap.put("Porch", urfaSearchUsersInt.getEntrance1()[i]);
                hashMap.put("Apartment #", urfaSearchUsersInt.getFlatNumber1()[i]);
                hashMap.put("Floor", urfaSearchUsersInt.getFloor1()[i]);
                hashMap.put("Home phone", urfaSearchUsersInt.getHomeTelephone1()[i]);
                hashMap.put("Building ID", urfaSearchUsersInt.getHouseId1()[i]);
                hashMap.put("ICQ number", urfaSearchUsersInt.getIcqNumber1()[i]);
                hashMap.put("Juridical", urfaSearchUsersInt.getIsJuridical1()[i]);
                hashMap.put("Juridical address", urfaSearchUsersInt.getJuridicalAddress1()[i]);
                hashMap.put("KPP number", urfaSearchUsersInt.getKppNumber1()[i]);
                if (urfaSearchUsersInt.getLastChangeDate1()[i] != null) {
                    hashMap.put("Modified last time on", new Date((long)urfaSearchUsersInt.getLastChangeDate1()[i].intValue() * 1000L));
                }
                if (urfaSearchUsersInt.getExternalId1()[i] != null) {
                    hashMap.put("External account ID", urfaSearchUsersInt.getExternalId1()[i]);
                }
                hashMap.put("Mobile phone", urfaSearchUsersInt.getMobileTelephone1()[i]);
                hashMap.put("Person's ID", urfaSearchUsersInt.getPassport1()[i]);
                hashMap.put("TAX number", urfaSearchUsersInt.getTaxNumber1()[i]);
                hashMap.put("Web page", urfaSearchUsersInt.getWebPage1()[i]);
                if (urfaSearchUsersInt.getWhoChange1()[i] != null) {
                    hashMap.put("Modified by", Resolve.getUserName(urfaSearchUsersInt.getWhoChange1()[i]));
                }
                if (urfaSearchUsersInt.getWhoCreate1()[i] != null) {
                    hashMap.put("Created by", Resolve.getUserName(urfaSearchUsersInt.getWhoCreate1()[i]));
                }
                hashMap.put("Work phone", urfaSearchUsersInt.getWorkTelephone1()[i]);
                hashMap.put("uid", urfaSearchUsersInt.getUserId1()[i]);
                hashMap.put("id", urfaSearchUsersInt.getUserId1()[i]);
                hashMap.put("login", urfaSearchUsersInt.getLogin1()[i]);
                hashMap.put("master_account", urfaSearchUsersInt.getBasicAccount1()[i]);
                hashMap.put("full_name", urfaSearchUsersInt.getFullName1()[i]);
                hashMap.put("status", Resolve.getBlockTypeName(urfaSearchUsersInt.getIsBlocked1()[i]));
                hashMap.put("ballance", urfaSearchUsersInt.getBalance1()[i]);
                String string = new String();
                String string2 = new String();
                int n = urfaSearchUsersInt.getIpAddressSizeArray1()[i];
                while (n-- > 0) {
                    int n2 = urfaSearchUsersInt.getIpGroupSizeArray2()[i][n];
                    while (n2-- > 0) {
                        InetAddress inetAddress = urfaSearchUsersInt.getIp3()[i][n][n2];
                        int n3 = urfaSearchUsersInt.getMask3()[i][n][n2];
                        int n4 = urfaSearchUsersInt.getType3()[i][n][n2];
                        if ((n4 & 1) == 1) {
                            string2 = string2 + Resolve.SubnetToView(inetAddress, n3) + "; ";
                            continue;
                        }
                        if ((n4 & 1) != 0) continue;
                        string = string + Resolve.SubnetToView(inetAddress, n3) + "; ";
                    }
                }
                hashMap.put("ip_vpn", string);
                hashMap.put("ip_not_vpn", string2);
                vector.add(hashMap);
            }
        }
        catch (UrfaException urfaException) {
            Utils.getLogger().error("Cannot proceed search", urfaException);
        }
        return vector;
    }
}

