/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.functions.dealer.custom;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaAddPaymentForAccountNotify;
import biz.netup.control.transport.urfa.functions.UrfaDealerAddPaymentForAccount;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetPaymentMethodsList;
import biz.netup.control.transport.urfa.functions.UrfaGetPaymentMethodsList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.objects.Payment;
import biz.netup.projects.utmadmin.functions.objects.PaymentMethod;
import biz.netup.utmutils.control.Utils;
import javax.swing.JOptionPane;

public class PaymentsFunctions {
    public static PaymentMethod[] getPMList() throws UrfaException {
        if (Utils.isAdmin()) {
            UrfaGetPaymentMethodsList urfaGetPaymentMethodsList = new UrfaGetPaymentMethodsList(UrfaManagerImpl.getInstance());
            urfaGetPaymentMethodsList.call();
            PaymentMethod[] paymentMethodArray = new PaymentMethod[urfaGetPaymentMethodsList.getPaymentsListCount()];
            for (int i = 0; i < urfaGetPaymentMethodsList.getPaymentsListCount(); ++i) {
                paymentMethodArray[i] = new PaymentMethod();
                paymentMethodArray[i].setId(urfaGetPaymentMethodsList.getId1()[i]);
                paymentMethodArray[i].setName(urfaGetPaymentMethodsList.getName1()[i]);
            }
            return paymentMethodArray;
        }
        UrfaDealerGetPaymentMethodsList urfaDealerGetPaymentMethodsList = new UrfaDealerGetPaymentMethodsList(UrfaManagerImpl.getInstance());
        urfaDealerGetPaymentMethodsList.call();
        PaymentMethod[] paymentMethodArray = new PaymentMethod[urfaDealerGetPaymentMethodsList.getPaymentsListCount()];
        for (int i = 0; i < urfaDealerGetPaymentMethodsList.getPaymentsListCount(); ++i) {
            paymentMethodArray[i] = new PaymentMethod();
            paymentMethodArray[i].setId(urfaDealerGetPaymentMethodsList.getId1()[i]);
            paymentMethodArray[i].setName(urfaDealerGetPaymentMethodsList.getName1()[i]);
        }
        return paymentMethodArray;
    }

    public static int newPayment(Payment payment) {
        if (Utils.isAdmin()) {
            UrfaAddPaymentForAccountNotify urfaAddPaymentForAccountNotify = new UrfaAddPaymentForAccountNotify(UrfaManagerImpl.getInstance());
            urfaAddPaymentForAccountNotify.setAccountId(payment.getAccountId());
            urfaAddPaymentForAccountNotify.setAdminComment(payment.getAdminComment());
            urfaAddPaymentForAccountNotify.setBurnTime(payment.getBurnDate());
            urfaAddPaymentForAccountNotify.setCurrencyId(payment.getCurrencyId());
            urfaAddPaymentForAccountNotify.setPaymentIncurrency(payment.getPayment());
            urfaAddPaymentForAccountNotify.setMethod(payment.getPaymentMethod());
            urfaAddPaymentForAccountNotify.setPaymentExtNumber(payment.getPaymentExtNumber());
            urfaAddPaymentForAccountNotify.setActualDate(payment.getPaymentDate());
            urfaAddPaymentForAccountNotify.setPaymentToInvoice(payment.getPaymentToInvoice());
            urfaAddPaymentForAccountNotify.setTurnOnInet(payment.getTurnOnInet());
            urfaAddPaymentForAccountNotify.setHash(payment.getHash());
            urfaAddPaymentForAccountNotify.setComment(payment.getComment());
            urfaAddPaymentForAccountNotify.setPaymentToInvoice(payment.getPaymentToInvoice());
            urfaAddPaymentForAccountNotify.setNotify(payment.isSendToEmail() ? 1 : 0);
            try {
                urfaAddPaymentForAccountNotify.call();
                return urfaAddPaymentForAccountNotify.getPaymentTransactionId();
            }
            catch (UrfaException urfaException) {
                urfaException.printStackTrace();
                JOptionPane.showMessageDialog(null, "Error while add payment: \n" + urfaException.getMessage(), "Error", 0);
                return urfaAddPaymentForAccountNotify.getPaymentTransactionId();
            }
        }
        UrfaDealerAddPaymentForAccount urfaDealerAddPaymentForAccount = new UrfaDealerAddPaymentForAccount(UrfaManagerImpl.getInstance());
        urfaDealerAddPaymentForAccount.setAccountId(payment.getAccountId());
        urfaDealerAddPaymentForAccount.setAdminComment(payment.getAdminComment());
        urfaDealerAddPaymentForAccount.setBurnDate(payment.getBurnDate());
        urfaDealerAddPaymentForAccount.setCurrencyId(payment.getCurrencyId());
        urfaDealerAddPaymentForAccount.setPayment(payment.getPayment());
        urfaDealerAddPaymentForAccount.setPaymentMethod(payment.getPaymentMethod());
        urfaDealerAddPaymentForAccount.setPaymentExtNumber(payment.getPaymentExtNumber());
        urfaDealerAddPaymentForAccount.setPaymentDate(payment.getPaymentDate());
        urfaDealerAddPaymentForAccount.setPaymentToInvoice(payment.getPaymentToInvoice());
        urfaDealerAddPaymentForAccount.setTurnOnInet(payment.getTurnOnInet());
        urfaDealerAddPaymentForAccount.setComment(payment.getComment());
        try {
            urfaDealerAddPaymentForAccount.call();
            return urfaDealerAddPaymentForAccount.getPaymentTransactionId();
        }
        catch (UrfaException urfaException) {
            urfaException.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error while add payment: \n" + urfaException.getMessage(), "Error", 0);
            return 0;
        }
    }
}

