/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.xml.serializer.impl;

import biz.netup.control.event.Event;
import biz.netup.control.event.Header;
import biz.netup.control.event.TemplateParameter;
import biz.netup.control.event.Transaction;
import biz.netup.control.handler.TransactionListenerException;
import biz.netup.control.storage.DictionaryWord;
import biz.netup.control.xml.serializer.SerializationException;
import biz.netup.control.xml.serializer.TransactionStreamSerializer;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XML11Serializer;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class TransactionStreamSerializerImpl_v2
extends TransactionStreamSerializer {
    private static final Logger logger = Logger.getLogger(TransactionStreamSerializerImpl_v2.class);
    private Transaction transaction;
    private Writer w;
    private static final String xmlHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String transactionHeaderBegin = "<transaction xmlns=\"http://www.netup.ru/transaction/2.0\"";
    private static final String transactionHeaderEnd = ">";
    private static final String eventsStart = "<events>";
    private static final String eventsEnd = "</events>";
    private static final String transactionFooter = "</transaction>\n";

    @Override
    public synchronized void onTransaction(Transaction transaction) throws TransactionListenerException {
        if (this.outputStream == null) {
            throw new IllegalStateException("not initialized");
        }
        if (transaction == null || transaction.getTransactionSize() == 0) {
            throw new IllegalArgumentException("transaction");
        }
        this.transaction = transaction;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.w = new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        try {
            this.serialize();
            this.w.flush();
            this.outputStream.write(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            logger.error("Cant't serialize transaction: " + iOException.getMessage(), iOException);
            throw new TransactionListenerException(iOException);
        }
    }

    @Override
    protected TransactionStreamSerializer newTransactionStreamSerializer() {
        return new TransactionStreamSerializerImpl_v2();
    }

    private void serialize() throws IOException {
        this.w.write(xmlHeader);
        this.w.write(transactionHeaderBegin);
        this.serializeHeader(this.transaction);
        this.w.write(transactionHeaderEnd);
        this.w.write(eventsStart);
        this.serializeBody(this.transaction);
        this.w.write(eventsEnd);
        this.w.write(transactionFooter);
    }

    private void serializeBody(Transaction transaction) throws IOException {
        Iterator<Event> iterator = transaction.getEventIterator();
        while (iterator.hasNext()) {
            this.serializeEvent(iterator.next());
        }
    }

    private void serializeHeader(Header header) throws IOException {
        if (header == null) {
            throw new IllegalArgumentException("header");
        }
        if (header.getHeaderSize() == 0) {
            return;
        }
        Iterator<String> iterator = header.getHeaderIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            this.writeAttribute(string, header.getHeader(string));
        }
    }

    private void serializeEvent(Event event) throws IOException {
        String string = event.getName();
        String string2 = null;
        String string3 = event.getVersion();
        int n = string.lastIndexOf(58);
        if (n >= 0) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        if (string.length() == 0) {
            throw new SerializationException("An event with an empty name");
        }
        Map<String, Object> map = event.getParameters();
        this.w.write(60);
        this.w.write(string);
        if (string2 != null) {
            this.writeAttribute("family", string2);
        }
        if (string3 != null) {
            this.writeAttribute("version", string3);
        }
        if (event.isTemplate()) {
            this.writeAttribute("type", "template");
        }
        if (0 != event.getReturnIndex()) {
            this.writeAttribute("return_index", Integer.toString(event.getReturnIndex()));
        }
        if (map.size() == 0) {
            this.w.write("/>");
        } else {
            this.w.write(62);
        }
        if (map.size() > 0) {
            for (String string4 : map.keySet()) {
                Object object = map.get(string4);
                this.serializeParameter(string4, object);
            }
            this.writeElementEnd(string);
        }
    }

    private void serializeParameter(String string, Object object) throws IOException {
        if (object instanceof Integer || object instanceof Double || object instanceof Long || object instanceof String) {
            this.serializeSimpleTypeParameter(string, object);
        } else if (object instanceof Date) {
            this.serializeSimpleTypeParameter(string, ((Date)object).getTime() / 1000L);
        } else if (object instanceof Integer[]) {
            this.serializeSimpleTypeArray(string, (Integer[])object, SimpleType.INTEGER);
        } else if (object instanceof Long[]) {
            this.serializeSimpleTypeArray(string, (Long[])object, SimpleType.LONG);
        } else if (object instanceof Double[]) {
            this.serializeSimpleTypeArray(string, (Double[])object, SimpleType.DOUBLE);
        } else if (object instanceof String[]) {
            this.serializeSimpleTypeArray(string, (String[])object, SimpleType.STRING);
        } else if (object instanceof int[]) {
            this.serializeIntArray(string, (int[])object);
        } else if (object instanceof long[]) {
            this.serializeLongArray(string, (long[])object);
        } else if (object instanceof double[]) {
            this.serializeDoubleArray(string, (double[])object);
        } else if (object instanceof Collection) {
            this.serializeCollection(string, (Collection)object);
        } else if (object instanceof DictionaryWord) {
            this.serializeSimpleTypeParameter(string, object);
        } else if (object instanceof DictionaryWord[]) {
            this.serializeDictionaryWordArray(string, (DictionaryWord[])object);
        } else if (object instanceof TemplateParameter) {
            this.serializeTemplatePatameter(string, (TemplateParameter)object);
        } else {
            throw new IllegalArgumentException("Can't serialize parameter '" + string + "' of type: " + object.getClass().getName());
        }
    }

    private void serializeSimpleTypeParameter(String string, Object object) throws IOException {
        this.w.write(60);
        this.w.write(string);
        SimpleType simpleType = this.determineObjectType(object);
        this.writeAttribute("type", this.simpleTypeString(simpleType));
        this.w.write(62);
        if (!(object instanceof String)) {
            if (object instanceof DictionaryWord) {
                object = ((DictionaryWord)object).id;
            }
            this.w.write(object.toString());
        } else {
            XML11Serializer xML11Serializer = new XML11Serializer(this.w, new OutputFormat());
            try {
                xML11Serializer.startDocument();
                char[] cArray = new char[((String)object).length()];
                ((String)object).getChars(0, cArray.length, cArray, 0);
                xML11Serializer.characters(cArray, 0, cArray.length);
                xML11Serializer.endDocument();
            }
            catch (SAXException sAXException) {
                logger.error("Error while serializing string", sAXException);
            }
        }
        this.writeElementEnd(string);
    }

    private void serializeDictionaryWordArray(String string, DictionaryWord[] dictionaryWordArray) throws IOException {
        this.writeArray(string, dictionaryWordArray.length, this.arrayTypeString(SimpleType.DICTIONARY_WORD));
        if (dictionaryWordArray.length > 0) {
            for (DictionaryWord dictionaryWord : dictionaryWordArray) {
                this.writeItem(dictionaryWord);
            }
            this.writeElementEnd(string);
        }
    }

    private void serializeIntArray(String string, int[] nArray) throws IOException {
        this.writeArray(string, nArray.length, this.arrayTypeString(SimpleType.INTEGER));
        if (nArray.length > 0) {
            for (int n : nArray) {
                this.writeItem(n);
            }
            this.writeElementEnd(string);
        }
    }

    private void serializeLongArray(String string, long[] lArray) throws IOException {
        this.writeArray(string, lArray.length, this.arrayTypeString(SimpleType.LONG));
        if (lArray.length > 0) {
            for (long l : lArray) {
                this.writeItem(l);
            }
            this.writeElementEnd(string);
        }
    }

    private void serializeDoubleArray(String string, double[] dArray) throws IOException {
        this.writeArray(string, dArray.length, this.arrayTypeString(SimpleType.DOUBLE));
        if (dArray.length > 0) {
            for (double d : dArray) {
                this.writeItem(d);
            }
            this.writeElementEnd(string);
        }
    }

    private void serializeSimpleTypeArray(String string, Object[] objectArray, SimpleType simpleType) throws IOException {
        this.writeArray(string, objectArray.length, this.arrayTypeString(simpleType));
        if (objectArray.length > 0) {
            for (Object object : objectArray) {
                this.writeItem(object);
            }
            this.writeElementEnd(string);
        }
    }

    private void serializeTemplatePatameter(String string, TemplateParameter templateParameter) throws IOException {
        this.w.write(60);
        this.w.write(string);
        this.writeAttribute("return_index", Integer.toString(templateParameter.return_index));
        this.writeAttribute("family", templateParameter.family);
        this.writeAttribute("name", templateParameter.name);
        this.writeAttribute("version", templateParameter.version);
        this.writeAttribute("parameter", templateParameter.parameter);
        this.w.write(" />");
    }

    private void serializeCollection(String string, Collection collection) throws IOException {
        SimpleType simpleType = this.determineType(collection);
        if (simpleType == null) {
            throw new SerializationException("Cannot determine '" + string + "' parameter type");
        }
        if (simpleType == SimpleType.UNKNOWN) {
            throw new SerializationException("Cannot serialize '" + string + "' parameter: type is not supported");
        }
        this.writeArray(string, collection.size(), this.arrayTypeString(simpleType));
        for (Object e : collection) {
            this.writeItem(e);
        }
        this.writeElementEnd(string);
    }

    private SimpleType determineType(Collection collection) {
        SimpleType simpleType = null;
        for (Object e : collection) {
            SimpleType simpleType2 = this.determineObjectType(e);
            if (simpleType == null) {
                simpleType = simpleType2;
                continue;
            }
            if (simpleType.equals((Object)simpleType2)) continue;
            return SimpleType.UNKNOWN;
        }
        return simpleType;
    }

    private SimpleType determineObjectType(Object object) {
        if (object instanceof Double) {
            return SimpleType.DOUBLE;
        }
        if (object instanceof Integer) {
            return SimpleType.INTEGER;
        }
        if (object instanceof Long) {
            return SimpleType.LONG;
        }
        if (object instanceof String) {
            return SimpleType.STRING;
        }
        if (object instanceof DictionaryWord) {
            return SimpleType.DICTIONARY_WORD;
        }
        return SimpleType.UNKNOWN;
    }

    private String simpleTypeString(SimpleType simpleType) {
        switch (simpleType) {
            case INTEGER: {
                return "int";
            }
            case DOUBLE: {
                return "double";
            }
            case LONG: {
                return "long";
            }
            case STRING: {
                return "string";
            }
            case DICTIONARY_WORD: {
                return "word";
            }
        }
        return null;
    }

    private String arrayTypeString(SimpleType simpleType) {
        switch (simpleType) {
            case INTEGER: {
                return "arrayOfInt";
            }
            case DOUBLE: {
                return "arrayOfDouble";
            }
            case LONG: {
                return "arrayOfLong";
            }
            case STRING: {
                return "arrayOfString";
            }
            case DICTIONARY_WORD: {
                return "arrayOfWord";
            }
        }
        return null;
    }

    private void writeItem(Object object) throws IOException {
        if (!(object instanceof String)) {
            if (object instanceof DictionaryWord) {
                object = ((DictionaryWord)object).id;
            }
            this.writeElement("item", object.toString());
        } else {
            StringWriter stringWriter = new StringWriter();
            XML11Serializer xML11Serializer = new XML11Serializer(stringWriter, new OutputFormat());
            try {
                xML11Serializer.startDocument();
                char[] cArray = new char[((String)object).length()];
                ((String)object).getChars(0, cArray.length, cArray, 0);
                xML11Serializer.characters(cArray, 0, cArray.length);
                xML11Serializer.endDocument();
            }
            catch (SAXException sAXException) {
                logger.error("Can't serialize string", sAXException);
            }
            this.writeElement("item", stringWriter.toString());
        }
    }

    private void writeArray(String string, int n, String string2) throws IOException {
        this.w.write(60);
        this.w.write(string);
        this.writeAttribute("type", string2);
        this.writeAttribute("size", String.valueOf(n));
        if (n == 0) {
            this.w.write("/>");
        } else {
            this.w.write(62);
        }
    }

    private void writeAttribute(String string, String string2) throws IOException {
        this.w.write(32);
        this.w.write(string);
        this.w.write("=\"");
        this.w.write(string2);
        this.w.write("\"");
    }

    private void writeElement(String string, String string2) throws IOException {
        this.writeElementStart(string);
        this.w.write(string2);
        this.writeElementEnd(string);
    }

    private void writeElementStart(String string) throws IOException {
        this.w.write(60);
        this.w.write(string);
        this.w.write(62);
    }

    private void writeElementEnd(String string) throws IOException {
        this.w.write("</");
        this.w.write(string);
        this.w.write(62);
    }

    static enum SimpleType {
        UNKNOWN,
        INTEGER,
        LONG,
        DOUBLE,
        STRING,
        DICTIONARY_WORD;

    }
}

