/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.xml.parser.impl;

import biz.netup.control.xml.parser.impl.DoubleArrayParser;
import biz.netup.control.xml.parser.impl.DoubleParser;
import biz.netup.control.xml.parser.impl.IntArrayParser;
import biz.netup.control.xml.parser.impl.IntParser;
import biz.netup.control.xml.parser.impl.LongArrayParser;
import biz.netup.control.xml.parser.impl.LongParser;
import biz.netup.control.xml.parser.impl.StringArrayParser;
import biz.netup.control.xml.parser.impl.StringParser;
import biz.netup.control.xml.parser.impl.TypeParser;
import biz.netup.control.xml.parser.impl.WordArrayParser;
import biz.netup.control.xml.parser.impl.WordParser;
import java.util.HashMap;
import java.util.Map;

public class TypeParserFactory {
    private static TypeParserFactory instance = null;
    protected Map<String, TypeParser> parsers = new HashMap<String, TypeParser>();

    protected TypeParserFactory() {
        this.parsers.put("string", new StringParser());
        this.parsers.put("int", new IntParser());
        this.parsers.put("word", new WordParser());
        this.parsers.put("long", new LongParser());
        this.parsers.put("double", new DoubleParser());
        this.parsers.put("arrayOfString", new StringArrayParser());
        this.parsers.put("arrayOfInt", new IntArrayParser());
        this.parsers.put("arrayOfWord", new WordArrayParser());
        this.parsers.put("arrayOfLong", new LongArrayParser());
        this.parsers.put("arrayOfDouble", new DoubleArrayParser());
    }

    public static synchronized TypeParserFactory getInstance() {
        if (instance == null) {
            instance = new TypeParserFactory();
        }
        return instance;
    }

    public TypeParser getParser(String string) {
        if (string == null) {
            throw new IllegalArgumentException("type");
        }
        TypeParser typeParser = this.parsers.get(string);
        return typeParser != null ? typeParser.newInstance() : null;
    }
}

