/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.impl;

import biz.netup.control.transport.ssl.SSLManager;
import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.impl.ConnectionImpl;
import java.net.InetAddress;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.log4j.Logger;

class ConnectionFactory
extends BasePoolableObjectFactory {
    private InetAddress ip;
    private int port;
    private String login;
    private String password;
    private SSLManager sslManager;
    private Logger logger = Logger.getLogger(ConnectionFactory.class);

    public ConnectionFactory(InetAddress inetAddress, int n, String string, String string2, SSLManager sSLManager) {
        this.ip = inetAddress;
        this.port = n;
        this.login = string;
        this.password = string2;
        this.sslManager = sSLManager;
    }

    @Override
    public Object makeObject() throws UrfaException {
        ConnectionImpl connectionImpl = new ConnectionImpl(this.sslManager);
        try {
            connectionImpl.open(this.ip, this.port, this.login, this.password);
        }
        catch (UrfaException urfaException) {
            this.logger.error("error opening connection");
            throw urfaException;
        }
        this.logger.debug("new instance created");
        return connectionImpl;
    }

    @Override
    public void destroyObject(Object object) throws UrfaException {
        try {
            this.logger.info("connection closed");
            ((ConnectionImpl)object).close();
        }
        catch (UrfaException urfaException) {
            this.logger.error("close() failed");
            throw urfaException;
        }
    }

    @Override
    public void activateObject(Object object) {
        this.logger.debug("Borrowing connection from pool");
    }

    @Override
    public void passivateObject(Object object) {
        this.logger.debug("Returning object to the pool");
    }

    @Override
    public boolean validateObject(Object object) {
        return true;
    }
}

