/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.impl;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.impl.Header;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;

class Attribute {
    public static final int ATTRIBUTE_LOGIN_TYPE = 1;
    public static final int ATTRIBUTE_LOGIN = 2;
    public static final int ATTRIBUTE_CALL = 3;
    public static final int ATTRIBUTE_TERMINATION = 4;
    public static final int ATTRIBUTE_DATA = 5;
    public static final int ATTRIBUTE_KEY = 6;
    public static final int ATTRIBUTE_CHAP_CHALLENGE = 8;
    public static final int ATTRIBUTE_CHAP_RESPONSE = 9;
    public static final int ATTRIBUTE_SSL_REQUEST = 10;
    public static final int LOGIN_REGULAR = 1;
    public static final int LOGIN_SYSTEM = 2;
    public static final int LOGIN_CARD = 3;
    public static final int SSL_NONE = 0;
    public static final int SSL_SSL3 = 2;
    public static final int SSL_SSL3_CERT = 3;
    public static final int SSL_SSL3_RSA_CERT = 4;
    public static final int SSL_TLS1_CERT = 5;
    public static final int VERSION = 35;
    public static final String UNSUPPORTED_VERSION_EXCEPTION = "UnsupportedProtocolVersionException";
    protected Header header;
    protected ByteBuffer value;
    protected Charset charset_;
    public static final boolean debug = false;
    private static final Logger LOG = Logger.getLogger(Attribute.class);

    Attribute(Header header) {
        if (header == null) {
            throw new IllegalArgumentException();
        }
        this.charset_ = Charset.forName("UTF8");
        this.header = header;
    }

    Attribute(int n, int n2) throws UrfaException {
        this(Attribute.newHeader(n, n2));
    }

    static Header newHeader(int n, int n2) throws UrfaException {
        if (n2 != 35) {
            throw new UrfaException(UNSUPPORTED_VERSION_EXCEPTION);
        }
        Header header = new Header();
        header.setCode(n);
        return header;
    }

    public Header getHeader() {
        return this.header;
    }

    public int getType() {
        return this.header.getCode();
    }

    public byte getByte() throws UrfaException {
        try {
            this.value.rewind();
            byte by = this.value.get();
            if (this.value.remaining() > 0) {
                throw new UrfaException("GetAttributeValueException");
            }
            return by;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UrfaException("GetAttributeValueException", bufferUnderflowException);
        }
    }

    public void putByte(byte by) throws UrfaException {
        try {
            this.header.setPacketSize(1);
            this.allocateBuffer(1);
            this.value.put(by);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new UrfaException("PutAttributeValueException", bufferOverflowException);
        }
        catch (ReadOnlyBufferException readOnlyBufferException) {
            throw new UrfaException("PutAttributeValueException", readOnlyBufferException);
        }
    }

    public byte[] getByteArray() throws UrfaException {
        try {
            this.value.rewind();
            byte[] byArray = new byte[this.value.remaining()];
            this.value.get(byArray);
            return byArray;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UrfaException("GetAttributeValueException", bufferUnderflowException);
        }
    }

    public void putByteArray(byte[] byArray) throws UrfaException {
        try {
            this.header.setPacketSize(byArray.length);
            this.allocateBuffer(byArray.length);
            this.value.put(byArray);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new UrfaException("PutAttributeValueException", bufferOverflowException);
        }
        catch (ReadOnlyBufferException readOnlyBufferException) {
            throw new UrfaException("PutAttributeValueException", readOnlyBufferException);
        }
    }

    public char getChar() throws UrfaException {
        try {
            this.value.rewind();
            char c = this.value.getChar();
            if (this.value.remaining() > 0) {
                throw new UrfaException("GetAttributeValueException");
            }
            return c;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UrfaException("GetAttributeValueException", bufferUnderflowException);
        }
    }

    public void putChar(char c) throws UrfaException {
        try {
            this.header.setPacketSize(2);
            this.allocateBuffer(2);
            this.value.putChar(c);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new UrfaException("PutAttributeValueException", bufferOverflowException);
        }
        catch (ReadOnlyBufferException readOnlyBufferException) {
            throw new UrfaException("PutAttributeValueException", readOnlyBufferException);
        }
    }

    public double getDouble() throws UrfaException {
        try {
            this.value.rewind();
            double d = this.value.getDouble();
            if (this.value.remaining() > 0) {
                throw new UrfaException("GetAttributeValueException");
            }
            return d;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UrfaException("GetAttributeValueException", bufferUnderflowException);
        }
    }

    public void putDouble(double d) throws UrfaException {
        try {
            this.header.setPacketSize(8);
            this.allocateBuffer(8);
            this.value.putDouble(d);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new UrfaException("PutAttributeValueException", bufferOverflowException);
        }
        catch (ReadOnlyBufferException readOnlyBufferException) {
            throw new UrfaException("PutAttributeValueException", readOnlyBufferException);
        }
    }

    public float getFloat() throws UrfaException {
        try {
            this.value.rewind();
            float f = this.value.getFloat();
            if (this.value.remaining() > 0) {
                throw new UrfaException("GetAttributeValueException");
            }
            return f;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UrfaException("GetAttributeValueException", bufferUnderflowException);
        }
    }

    public void putFloat(float f) throws UrfaException {
        try {
            this.header.setPacketSize(4);
            this.allocateBuffer(4);
            this.value.putFloat(f);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new UrfaException("PutAttributeValueException", bufferOverflowException);
        }
        catch (ReadOnlyBufferException readOnlyBufferException) {
            throw new UrfaException("PutAttributeValueException", readOnlyBufferException);
        }
    }

    public int getInt() throws UrfaException {
        try {
            this.value.rewind();
            int n = this.value.getInt();
            if (this.value.remaining() > 0) {
                throw new UrfaException("GetAttributeValueException");
            }
            return n;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UrfaException("GetAttributeValueException", bufferUnderflowException);
        }
    }

    public void putInt(int n) throws UrfaException {
        try {
            this.header.setPacketSize(4);
            this.allocateBuffer(4);
            this.value.putInt(n);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new UrfaException("PutAttributeValueException", bufferOverflowException);
        }
        catch (ReadOnlyBufferException readOnlyBufferException) {
            throw new UrfaException("PutAttributeValueException", readOnlyBufferException);
        }
    }

    public long getLong() throws UrfaException {
        try {
            this.value.rewind();
            long l = this.value.getLong();
            if (this.value.remaining() > 0) {
                throw new UrfaException("GetAttributeValueException");
            }
            return l;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UrfaException("GetAttributeValueException", bufferUnderflowException);
        }
    }

    public void putLong(long l) throws UrfaException {
        try {
            this.header.setPacketSize(8);
            this.allocateBuffer(8);
            this.value.putLong(l);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new UrfaException("PutAttributeValueException", bufferOverflowException);
        }
        catch (ReadOnlyBufferException readOnlyBufferException) {
            throw new UrfaException("PutAttributeValueException", readOnlyBufferException);
        }
    }

    public short getShort() throws UrfaException {
        try {
            this.value.rewind();
            short s = this.value.getShort();
            if (this.value.remaining() > 0) {
                throw new UrfaException("GetAttributeValueException");
            }
            return s;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UrfaException("GetAttributeValueException", bufferUnderflowException);
        }
    }

    public void putShort(short s) throws UrfaException {
        try {
            this.header.setPacketSize(2);
            this.allocateBuffer(2);
            this.value.putShort(s);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new UrfaException("PutAttributeValueException", bufferOverflowException);
        }
        catch (ReadOnlyBufferException readOnlyBufferException) {
            throw new UrfaException("PutAttributeValueException", readOnlyBufferException);
        }
    }

    public String getString() throws UrfaException {
        this.value.rewind();
        String string = this.charset_.decode(this.value).toString();
        if (this.value.remaining() > 0) {
            throw new UrfaException("GetAttributeValueException");
        }
        return string;
    }

    public void putString(String string) throws UrfaException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.value = this.charset_.encode(string);
        try {
            this.header.setPacketSize(string.getBytes(this.charset_.displayName()).length);
        }
        catch (Exception exception) {
            throw new UrfaException("Unsupported encoding");
        }
    }

    public void parse(ByteBuffer byteBuffer) throws UrfaException {
        this.allocateBuffer(this.header.getPacketSize());
        byteBuffer.get(this.value.array());
    }

    public void unparse(ByteBuffer byteBuffer) throws UrfaException {
        this.header.unparse(byteBuffer);
        if (this.value != null) {
            this.value.rewind();
            byteBuffer.put(this.value);
        }
    }

    private void allocateBuffer(int n) {
        this.value = ByteBuffer.allocate(n);
        this.value.order(ByteOrder.BIG_ENDIAN);
    }

    private String printBuffer(ByteBuffer byteBuffer) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = ' ';
        String string = "0123456789ABCDEF";
        byteBuffer.rewind();
        while (byteBuffer.remaining() > 0) {
            byte by = byteBuffer.get();
            char c2 = string.charAt(by >> 4 & 0xF);
            char c3 = string.charAt(by & 0xF);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(c);
            }
            stringBuffer.append(c2);
            stringBuffer.append(c3);
        }
        return stringBuffer.toString();
    }
}

