/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.functions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;
import biz.netup.control.transport.urfa.functions.UrfaPushToReport;
import biz.netup.utmutils.swing.tab.ReportTab;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class UrfaTelSupplierUsersReport
extends UrfaPushToReport {
    private boolean invoked = false;
    private int inSupplierId = 0;
    private int inStartDate;
    private int inEndDate = (int)(System.currentTimeMillis() / 1000L);
    private int outUsersCount;

    public UrfaTelSupplierUsersReport(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    public UrfaTelSupplierUsersReport(UrfaManager urfaManager, ReportTab reportTab) {
        super(urfaManager, reportTab);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call() throws UrfaException {
        this.invoked = true;
        UrfaInvocation urfaInvocation = this.manager.startInvocation(66341);
        try {
            urfaInvocation.putInt(this.inSupplierId);
            urfaInvocation.putInt(this.inStartDate);
            urfaInvocation.putInt(this.inEndDate);
            urfaInvocation.invoke();
            int n = urfaInvocation.getInt();
            if (n != -1) {
                this.outUsersCount = urfaInvocation.getInt();
                for (int i = 0; i < this.outUsersCount; ++i) {
                    this.row = new HashMap();
                    this.row.put("row number", urfaInvocation.getInt());
                    this.row.put("contract number", urfaInvocation.getString());
                    this.row.put("full name", urfaInvocation.getString());
                    this.row.put("juridical address", urfaInvocation.getString());
                    this.row.put("inn", urfaInvocation.getString());
                    this.row.put("kpp", urfaInvocation.getString());
                    this.row.put("is diplomat", urfaInvocation.getInt());
                    this.row.put("is juridical", urfaInvocation.getInt());
                    this.row.put("is resident", urfaInvocation.getInt());
                    this.row.put("nationality", urfaInvocation.getInt());
                    Long l = Long.parseLong(String.valueOf(urfaInvocation.getInt()));
                    Date date = new Date(l * 1000L);
                    String string = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(date);
                    this.row.put("begin contract date", string);
                    l = Long.parseLong(String.valueOf(urfaInvocation.getInt()));
                    date = new Date(l * 1000L);
                    string = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(date);
                    this.row.put("end contract date", string);
                    this.row.put("contract type", urfaInvocation.getInt());
                    this.row.put("contract place", urfaInvocation.getString());
                    this.row.put("agreement", urfaInvocation.getInt());
                    if (this.addToReport(this.row)) continue;
                    return;
                }
            }
        }
        finally {
            if (!this.exit) {
                urfaInvocation.close();
            }
        }
    }

    public void setSupplierId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inSupplierId = n;
    }

    public void setStartDate(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inStartDate = n;
    }

    public void setEndDate(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inEndDate = n;
    }

    public int getUsersCount() {
        if (this.invoked) {
            return this.outUsersCount;
        }
        throw new IllegalStateException("Didn't invoke");
    }
}

