/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.functions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;

public class UrfaMakePymentForSupplier {
    private UrfaManager manager;
    private boolean invoked = false;
    private int inSupplierId;
    private int outSupplierId;
    private int inType;
    private int inCurrencyType;
    private double inSumm;
    private double outSumm;
    private String inReason;
    private String outErrorStr;

    public UrfaMakePymentForSupplier(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    public void call() throws UrfaException {
        this.invoked = true;
        UrfaInvocation urfaInvocation = this.manager.startInvocation(32792);
        try {
            urfaInvocation.putInt(this.inSupplierId);
            urfaInvocation.putDouble(this.inSumm);
            urfaInvocation.putString(this.inReason);
            urfaInvocation.putInt(this.inCurrencyType);
            urfaInvocation.putInt(this.inType);
            urfaInvocation.invoke();
            this.outSupplierId = urfaInvocation.getInt();
            if (this.outSupplierId == -1) {
                this.outErrorStr = urfaInvocation.getString();
            } else {
                this.outSumm = urfaInvocation.getDouble();
            }
        }
        finally {
            urfaInvocation.close();
        }
    }

    public void setSupplierId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inSupplierId = n;
    }

    public int getSupplierId() {
        if (this.invoked) {
            return this.outSupplierId;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public String getErrorString() {
        if (this.invoked) {
            return this.outErrorStr;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public Double getAbsSumm() {
        if (this.invoked) {
            return this.outSumm;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public void setPaymentType(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inType = n;
    }

    public void setSumm(double d) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inSumm = d;
    }

    public void setReason(String string) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inReason = string;
    }

    public void setCurrencyType(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inCurrencyType = n;
    }
}

