/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.functions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;
import java.net.InetAddress;

public class UrfaGetSwitchDhcpPoolLinks {
    private UrfaManager manager;
    private boolean invoked = false;
    private Integer switch_id;
    private Integer num_of_pools;
    private int[] poolId;
    private InetAddress[] gateway;
    private InetAddress[] netmask;
    private InetAddress[] dns1_server;
    private InetAddress[] dns2_server;
    private InetAddress[] ntp_server;
    private String[] domain_name;
    private Integer[] block_pool_id;
    private Integer[] lease_time;
    private Integer[] block_action_type;
    private Integer[] ranges_size;
    private InetAddress[][] first_addr;
    private InetAddress[][] last_addr;

    public UrfaGetSwitchDhcpPoolLinks(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call() throws UrfaException {
        UrfaInvocation urfaInvocation = this.manager.startInvocation(4448);
        try {
            urfaInvocation.putInt(this.switch_id);
            urfaInvocation.invoke();
            this.num_of_pools = urfaInvocation.getInt();
            this.poolId = new int[this.num_of_pools.intValue()];
            this.gateway = new InetAddress[this.num_of_pools.intValue()];
            this.netmask = new InetAddress[this.num_of_pools.intValue()];
            this.dns1_server = new InetAddress[this.num_of_pools.intValue()];
            this.dns2_server = new InetAddress[this.num_of_pools.intValue()];
            this.ntp_server = new InetAddress[this.num_of_pools.intValue()];
            this.domain_name = new String[this.num_of_pools.intValue()];
            this.block_pool_id = new Integer[this.num_of_pools.intValue()];
            this.lease_time = new Integer[this.num_of_pools.intValue()];
            this.block_action_type = new Integer[this.num_of_pools.intValue()];
            this.ranges_size = new Integer[this.num_of_pools.intValue()];
            this.first_addr = new InetAddress[this.num_of_pools.intValue()][];
            this.last_addr = new InetAddress[this.num_of_pools.intValue()][];
            for (int i = 0; i < this.num_of_pools; ++i) {
                this.poolId[i] = urfaInvocation.getInt();
                this.gateway[i] = urfaInvocation.getIpAddress();
                this.netmask[i] = urfaInvocation.getIpAddress();
                this.dns1_server[i] = urfaInvocation.getIpAddress();
                this.dns2_server[i] = urfaInvocation.getIpAddress();
                this.ntp_server[i] = urfaInvocation.getIpAddress();
                this.domain_name[i] = urfaInvocation.getString();
                this.block_pool_id[i] = urfaInvocation.getInt();
                this.lease_time[i] = urfaInvocation.getInt();
                this.block_action_type[i] = urfaInvocation.getInt();
                this.ranges_size[i] = urfaInvocation.getInt();
                this.first_addr[i] = new InetAddress[this.ranges_size[i].intValue()];
                this.last_addr[i] = new InetAddress[this.ranges_size[i].intValue()];
                for (int j = 0; j < this.ranges_size[i]; ++j) {
                    this.first_addr[i][j] = urfaInvocation.getIpAddress();
                    this.last_addr[i][j] = urfaInvocation.getIpAddress();
                }
            }
            this.invoked = true;
        }
        finally {
            urfaInvocation.close();
        }
    }

    public void setSwitchId(int n) {
        this.switch_id = n;
    }

    public int getNumberPools() {
        if (this.invoked) {
            return this.num_of_pools;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int[] getPoolId() {
        if (this.invoked) {
            return this.poolId;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public InetAddress[] getGetways() {
        if (this.invoked) {
            return this.gateway;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public InetAddress[] getNetmasks() {
        if (this.invoked) {
            return this.netmask;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public String getNameOfPool(int n) {
        if (this.invoked) {
            return this.gateway[n].getHostAddress().toString() + "/" + this.netmask[n].getHostAddress().toString();
        }
        throw new IllegalStateException("Didn't invoke");
    }
}

