/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.functions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;
import java.net.InetAddress;

public class UrfaGetIppool {
    private UrfaManager manager;
    private boolean invoked = false;
    private int inId;
    private int outId;
    private String outName;
    private InetAddress outAddress;
    private int outMask;

    public UrfaGetIppool(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    public void call() throws UrfaException {
        this.invoked = true;
        UrfaInvocation urfaInvocation = this.manager.startInvocation(4198);
        try {
            urfaInvocation.putInt(this.inId);
            urfaInvocation.invoke();
            this.outId = urfaInvocation.getInt();
            this.outName = urfaInvocation.getString();
            this.outAddress = urfaInvocation.getIpAddress();
            this.outMask = urfaInvocation.getInt();
        }
        finally {
            urfaInvocation.close();
        }
    }

    public void setId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inId = n;
    }

    public int getId() {
        if (this.invoked) {
            return this.outId;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public String getName() {
        if (this.invoked) {
            return this.outName;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public InetAddress getAddress() {
        if (this.invoked) {
            return this.outAddress;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getMask() {
        if (this.invoked) {
            return this.outMask;
        }
        throw new IllegalStateException("Didn't invoke");
    }
}

