/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.functions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;

public class UrfaEditOnceSlinkEx {
    private UrfaManager manager;
    private boolean invoked = false;
    private int inSlinkId = 0;
    private int inDiscountDate = (int)(System.currentTimeMillis() / 1000L);
    private double inCostCoef;
    private int outSlinkId;

    public UrfaEditOnceSlinkEx(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    public void call() throws UrfaException {
        this.invoked = true;
        UrfaInvocation urfaInvocation = this.manager.startInvocation(10529);
        try {
            urfaInvocation.putInt(this.inSlinkId);
            urfaInvocation.putInt(this.inDiscountDate);
            urfaInvocation.putDouble(this.inCostCoef);
            urfaInvocation.invoke();
            this.outSlinkId = urfaInvocation.getInt();
        }
        finally {
            urfaInvocation.close();
        }
    }

    public void setSlinkId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inSlinkId = n;
    }

    public void setDiscountDate(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inDiscountDate = n;
    }

    public void setCostCoef(double d) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inCostCoef = d;
    }

    public int getSlinkId() {
        if (this.invoked) {
            return this.outSlinkId;
        }
        throw new IllegalStateException("Didn't invoke");
    }
}

