/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.functions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;

public class UrfaDealerSaveAccount {
    private UrfaManager manager;
    private boolean invoked = false;
    private int inAccountId;
    private int inDiscountPeriodId;
    private double inCredit;
    private int inIsBlocked;
    private int inBlockStartDate = (int)(System.currentTimeMillis() / 1000L);
    private int inBlockEndDate = 2000000000;
    private double inVatRate;
    private double inSaleTaxRate;
    private int inIntStatus;
    private int inBlockRecalcAbon;
    private int inBlockRecalcPrepaid;
    private int inUnlimited;
    private String inIrdetoAccessCurdNumber;
    private String inIrdetoSTBSerialNumber;
    private int outAid;

    public UrfaDealerSaveAccount(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    public void call() throws UrfaException {
        this.invoked = true;
        UrfaInvocation urfaInvocation = this.manager.startInvocation(1879048213);
        try {
            urfaInvocation.putInt(this.inAccountId);
            urfaInvocation.putInt(this.inDiscountPeriodId);
            urfaInvocation.putDouble(this.inCredit);
            urfaInvocation.putInt(this.inIsBlocked);
            if (this.inIsBlocked != 0) {
                urfaInvocation.putInt(this.inBlockStartDate);
                urfaInvocation.putInt(this.inBlockEndDate);
            }
            urfaInvocation.putDouble(this.inVatRate);
            urfaInvocation.putDouble(this.inSaleTaxRate);
            urfaInvocation.putInt(this.inIntStatus);
            urfaInvocation.putInt(this.inBlockRecalcAbon);
            urfaInvocation.putInt(this.inBlockRecalcPrepaid);
            urfaInvocation.putInt(this.inUnlimited);
            urfaInvocation.putString(this.inIrdetoAccessCurdNumber);
            urfaInvocation.putString(this.inIrdetoSTBSerialNumber);
            urfaInvocation.invoke();
            this.outAid = urfaInvocation.getInt();
            if (this.outAid == 0) {
                // empty if block
            }
        }
        finally {
            urfaInvocation.close();
        }
    }

    public void setAccountId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inAccountId = n;
    }

    public void setDiscountPeriodId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inDiscountPeriodId = n;
    }

    public void setCredit(double d) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inCredit = d;
    }

    public void setIsBlocked(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inIsBlocked = n;
    }

    public void setBlockStartDate(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inBlockStartDate = n;
    }

    public void setBlockEndDate(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inBlockEndDate = n;
    }

    public void setVatRate(double d) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inVatRate = d;
    }

    public void setSaleTaxRate(double d) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inSaleTaxRate = d;
    }

    public void setIntStatus(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inIntStatus = n;
    }

    public void setBlockRecalcAbon(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inBlockRecalcAbon = n;
    }

    public void setBlockRecalcPrepaid(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inBlockRecalcPrepaid = n;
    }

    public void setUnlimited(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inUnlimited = n;
    }

    public int getAid() {
        if (this.invoked) {
            return this.outAid;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public void setIrdetoAccessCurdNumber(String string) {
        this.inIrdetoAccessCurdNumber = string;
    }

    public void setIrdetoSTBSerialNumber(String string) {
        this.inIrdetoSTBSerialNumber = string;
    }
}

