/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.functions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;

public class UrfaDealerGetAccountInfo {
    private UrfaManager manager;
    private boolean invoked = false;
    private int inAccountId;
    private int outAccountId;
    private int outDiscountPeriodId;
    private int outIsBlocked;
    private double outVatRate;
    private double outSaleTaxRate;
    private double outComissionCoefficient;
    private double outDefaultComissionValue;
    private double outCredit;
    private double outBalance;
    private int outIntStatus;
    private int outBlockRecalcAbon;
    private int outBlockRecalcPrepaid;
    private int outUnlimited;
    private String outIrdetoAccessCardNumber;
    private String outIrdetoSTBSerialNumber;

    public UrfaDealerGetAccountInfo(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    public void call() throws UrfaException {
        this.invoked = true;
        UrfaInvocation urfaInvocation = this.manager.startInvocation(1879048211);
        try {
            urfaInvocation.putInt(this.inAccountId);
            urfaInvocation.invoke();
            this.outAccountId = urfaInvocation.getInt();
            if (this.outAccountId == 0) {
                // empty if block
            }
            this.outDiscountPeriodId = urfaInvocation.getInt();
            this.outIsBlocked = urfaInvocation.getInt();
            this.outVatRate = urfaInvocation.getDouble();
            this.outSaleTaxRate = urfaInvocation.getDouble();
            this.outComissionCoefficient = urfaInvocation.getDouble();
            this.outDefaultComissionValue = urfaInvocation.getDouble();
            this.outCredit = urfaInvocation.getDouble();
            this.outBalance = urfaInvocation.getDouble();
            this.outIntStatus = urfaInvocation.getInt();
            this.outBlockRecalcAbon = urfaInvocation.getInt();
            this.outBlockRecalcPrepaid = urfaInvocation.getInt();
            this.outUnlimited = urfaInvocation.getInt();
            this.outIrdetoAccessCardNumber = urfaInvocation.getString();
            this.outIrdetoSTBSerialNumber = urfaInvocation.getString();
        }
        finally {
            urfaInvocation.close();
        }
    }

    public void setAccountId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inAccountId = n;
    }

    public int getAccountId() {
        if (this.invoked) {
            return this.outAccountId;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getDiscountPeriodId() {
        if (this.invoked) {
            return this.outDiscountPeriodId;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getIsBlocked() {
        if (this.invoked) {
            return this.outIsBlocked;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public double getVatRate() {
        if (this.invoked) {
            return this.outVatRate;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public double getSaleTaxRate() {
        if (this.invoked) {
            return this.outSaleTaxRate;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public double getComissionCoefficient() {
        if (this.invoked) {
            return this.outComissionCoefficient;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public double getDefaultComissionValue() {
        if (this.invoked) {
            return this.outDefaultComissionValue;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public double getCredit() {
        if (this.invoked) {
            return this.outCredit;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public double getBalance() {
        if (this.invoked) {
            return this.outBalance;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getIntStatus() {
        if (this.invoked) {
            return this.outIntStatus;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getBlockRecalcAbon() {
        if (this.invoked) {
            return this.outBlockRecalcAbon;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getBlockRecalcPrepaid() {
        if (this.invoked) {
            return this.outBlockRecalcPrepaid;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getUnlimited() {
        if (this.invoked) {
            return this.outUnlimited;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public String getIrdetoAccessCardNumber() {
        return this.outIrdetoAccessCardNumber;
    }

    public String getIrdetoSTBSerialNumber() {
        return this.outIrdetoSTBSerialNumber;
    }
}

