/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.functions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;

public class UrfaAddDocTemplate {
    private UrfaManager manager;
    private boolean invoked = false;
    private int inDocTypeId;
    private int inDocTemplateId;
    private String inDocName;
    private String inDocText;
    private int outResult;

    public UrfaAddDocTemplate(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    public void call() throws UrfaException {
        this.invoked = true;
        UrfaInvocation urfaInvocation = this.manager.startInvocation(28704);
        try {
            urfaInvocation.putInt(this.inDocTypeId);
            urfaInvocation.putInt(this.inDocTemplateId);
            urfaInvocation.putString(this.inDocName);
            urfaInvocation.putInt(this.inDocText.length() / 2048 + 1);
            for (int i = 0; i < this.inDocText.length() / 2048 + 1; ++i) {
                if (this.inDocText.length() == i * 2048) {
                    urfaInvocation.putString("");
                } else if (i == this.inDocText.length() / 2048) {
                    urfaInvocation.putString(this.inDocText.substring(i * 2048));
                } else {
                    urfaInvocation.putString(this.inDocText.substring(i * 2048, (i + 1) * 2048));
                }
                urfaInvocation.send();
            }
            urfaInvocation.invoke();
            this.outResult = urfaInvocation.getInt();
        }
        finally {
            urfaInvocation.close();
        }
    }

    public void setDocTypeId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inDocTypeId = n;
    }

    public void setDocTemplateId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inDocTemplateId = n;
    }

    public void setDocName(String string) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inDocName = string;
    }

    public void setDocText(String string) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inDocText = string;
    }

    public int getResult() {
        if (this.invoked) {
            return this.outResult;
        }
        throw new IllegalStateException("Didn't invoke");
    }
}

