/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.functions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;
import java.net.InetAddress;

public class UrfaAddDhcpPool {
    private UrfaManager manager;
    private boolean invoked = false;
    private InetAddress inGateway;
    private InetAddress inNetmask;
    private InetAddress inDns1Server;
    private InetAddress inDns2Server;
    private InetAddress inNtpServer;
    private String inDomainName;
    private int inBlockPoolId;
    private int inLeaseTime;
    private int inFlags;
    private int inRangesSize;
    private InetAddress[] inFirstAddr;
    private InetAddress[] inLastAddr;
    private int outId;

    public UrfaAddDhcpPool(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    public void call() throws UrfaException {
        this.invoked = true;
        UrfaInvocation urfaInvocation = this.manager.startInvocation(1793);
        try {
            urfaInvocation.putIpAddress(this.inGateway);
            urfaInvocation.putIpAddress(this.inNetmask);
            urfaInvocation.putIpAddress(this.inDns1Server);
            urfaInvocation.putIpAddress(this.inDns2Server);
            urfaInvocation.putIpAddress(this.inNtpServer);
            urfaInvocation.putString(this.inDomainName);
            urfaInvocation.putInt(this.inBlockPoolId);
            urfaInvocation.putInt(this.inLeaseTime);
            urfaInvocation.putInt(this.inFlags);
            urfaInvocation.putInt(this.inRangesSize);
            for (int i = 0; i < this.inRangesSize; ++i) {
                urfaInvocation.putIpAddress(this.inFirstAddr[i]);
                urfaInvocation.putIpAddress(this.inLastAddr[i]);
            }
            urfaInvocation.invoke();
            this.outId = urfaInvocation.getInt();
        }
        finally {
            urfaInvocation.close();
        }
    }

    public void setGateway(InetAddress inetAddress) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inGateway = inetAddress;
    }

    public void setNetmask(InetAddress inetAddress) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inNetmask = inetAddress;
    }

    public void setDns1Server(InetAddress inetAddress) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inDns1Server = inetAddress;
    }

    public void setDns2Server(InetAddress inetAddress) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inDns2Server = inetAddress;
    }

    public void setNtpServer(InetAddress inetAddress) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inNtpServer = inetAddress;
    }

    public void setDomainName(String string) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inDomainName = string;
    }

    public void setBlockPoolId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inBlockPoolId = n;
    }

    public void setLeaseTime(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inLeaseTime = n;
    }

    public void setFlags(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inFlags = n;
    }

    public void setRangesSize(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inRangesSize = n;
    }

    public void setFirstAddr(InetAddress[] inetAddressArray) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inFirstAddr = inetAddressArray;
    }

    public void setLastAddr(InetAddress[] inetAddressArray) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inLastAddr = inetAddressArray;
    }

    public int getId() {
        if (this.invoked) {
            return this.outId;
        }
        throw new IllegalStateException("Didn't invoke");
    }
}

