/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.functions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;

public class UrfaAddAccount {
    private UrfaManager manager;
    private boolean invoked = false;
    private int inUserId;
    private int inIsBasic = 1;
    private int inIsBlocked = 0;
    private double inBalance = 0.0;
    private double inCredit = 0.0;
    private double inVatRate = 0.0;
    private double inSaleTaxRate = 0.0;
    private int inIntStatus = 1;
    private int inUnlimited = 0;
    private int inAutoEnableInet = 0;
    private String externalId = "";
    private int outAccountId;

    public UrfaAddAccount(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    public void call() throws UrfaException {
        this.invoked = true;
        UrfaInvocation urfaInvocation = this.manager.startInvocation(86282);
        try {
            urfaInvocation.putInt(this.inUserId);
            urfaInvocation.putInt(this.inIsBasic);
            urfaInvocation.putInt(this.inIsBlocked);
            urfaInvocation.putDouble(this.inBalance);
            urfaInvocation.putDouble(this.inCredit);
            urfaInvocation.putDouble(this.inVatRate);
            urfaInvocation.putDouble(this.inSaleTaxRate);
            urfaInvocation.putInt(this.inIntStatus);
            urfaInvocation.putInt(this.inUnlimited);
            urfaInvocation.putInt(this.inAutoEnableInet);
            urfaInvocation.putString(this.externalId);
            urfaInvocation.invoke();
            this.outAccountId = urfaInvocation.getInt();
            if (this.outAccountId == 0) {
                // empty if block
            }
        }
        finally {
            urfaInvocation.close();
        }
    }

    public void setUserId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inUserId = n;
    }

    public void setIsBasic(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inIsBasic = n;
    }

    public void setIsBlocked(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inIsBlocked = n;
    }

    public void setBalance(double d) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inBalance = d;
    }

    public void setCredit(double d) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inCredit = d;
    }

    public void setVatRate(double d) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inVatRate = d;
    }

    public void setSaleTaxRate(double d) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inSaleTaxRate = d;
    }

    public void setIntStatus(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inIntStatus = n;
    }

    public void setManager(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    public void setExternalId(String string) {
        this.externalId = string;
    }

    public void setInAutoEnableInet(int n) {
        this.inAutoEnableInet = n;
    }

    public void setUnlimited(int n) {
        this.inUnlimited = n;
    }

    public int getAccountId() {
        if (this.invoked) {
            return this.outAccountId;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public UrfaManager getManager() {
        return this.manager;
    }
}

