/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import org.garret.perst.Assert;
import org.garret.perst.impl.BitIndexImpl;
import org.garret.perst.impl.Btree;
import org.garret.perst.impl.BtreeFieldIndex;
import org.garret.perst.impl.BtreeMultiFieldIndex;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.ClassDescriptor;
import org.garret.perst.impl.ObjectHeader;
import org.garret.perst.impl.PersistentSet;
import org.garret.perst.impl.StorageImpl;
import org.garret.perst.impl.XMLImporter;

public class XMLExporter {
    static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private StorageImpl storage;
    private Writer writer;
    private int[] markedBitmap;
    private int[] exportedBitmap;
    private int[] compoundKeyTypes;

    public XMLExporter(StorageImpl storage, Writer writer) {
        this.storage = storage;
        this.writer = writer;
    }

    public void exportDatabase(int rootOid) throws IOException {
        int nExportedObjects;
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.writer.write("<database root=\"" + rootOid + "\">\n");
        this.exportedBitmap = new int[(this.storage.currIndexSize + 31) / 32];
        this.markedBitmap = new int[(this.storage.currIndexSize + 31) / 32];
        int n = rootOid >> 5;
        this.markedBitmap[n] = this.markedBitmap[n] | 1 << (rootOid & 0x1F);
        do {
            nExportedObjects = 0;
            for (int i = 0; i < this.markedBitmap.length; ++i) {
                int mask = this.markedBitmap[i];
                if (mask == 0) continue;
                int j = 0;
                int bit = 1;
                while (j < 32) {
                    if ((mask & bit) != 0) {
                        int oid = (i << 5) + j;
                        int n2 = i;
                        this.exportedBitmap[n2] = this.exportedBitmap[n2] | bit;
                        int n3 = i;
                        this.markedBitmap[n3] = this.markedBitmap[n3] & ~bit;
                        byte[] obj = this.storage.get(oid);
                        int typeOid = ObjectHeader.getType(obj, 0);
                        ClassDescriptor desc = this.storage.findClassDescriptor(typeOid);
                        if (desc.cls == Btree.class) {
                            this.exportIndex(oid, obj, "org.garret.perst.impl.Btree");
                        } else if (desc.cls == BitIndexImpl.class) {
                            this.exportIndex(oid, obj, "org.garret.perst.impl.BitIndexImpl");
                        } else if (desc.cls == PersistentSet.class) {
                            this.exportSet(oid, obj);
                        } else if (desc.cls == BtreeFieldIndex.class) {
                            this.exportFieldIndex(oid, obj);
                        } else if (desc.cls == BtreeMultiFieldIndex.class) {
                            this.exportMultiFieldIndex(oid, obj);
                        } else {
                            String className = this.exportIdentifier(desc.name);
                            this.writer.write(" <" + className + " id=\"" + oid + "\">\n");
                            this.exportObject(desc, obj, 8, 2);
                            this.writer.write(" </" + className + ">\n");
                        }
                        ++nExportedObjects;
                    }
                    ++j;
                    bit <<= 1;
                }
            }
        } while (nExportedObjects != 0);
        this.writer.write("</database>\n");
        this.writer.flush();
    }

    final String exportIdentifier(String name) {
        return name.replace('$', '-');
    }

    final void exportSet(int oid, byte[] data) throws IOException {
        Btree btree = new Btree(data, 8);
        this.storage.assignOid(btree, oid);
        this.writer.write(" <org.garret.perst.impl.PersistentSet id=\"" + oid + "\">\n");
        btree.export(this);
        this.writer.write(" </org.garret.perst.impl.PersistentSet>\n");
    }

    final void exportIndex(int oid, byte[] data, String name) throws IOException {
        Btree btree = new Btree(data, 8);
        this.storage.assignOid(btree, oid);
        this.writer.write(" <" + name + " id=\"" + oid + "\" unique=\"" + (btree.unique ? (char)'1' : '0') + "\" type=\"" + ClassDescriptor.signature[btree.type] + "\">\n");
        btree.export(this);
        this.writer.write(" </" + name + ">\n");
    }

    final void exportFieldIndex(int oid, byte[] data) throws IOException {
        Btree btree = new Btree(data, 8);
        this.storage.assignOid(btree, oid);
        this.writer.write(" <org.garret.perst.impl.BtreeFieldIndex id=\"" + oid + "\" unique=\"" + (btree.unique ? (char)'1' : '0') + "\" class=");
        int offs = this.exportString(data, 25);
        this.writer.write(" field=");
        offs = this.exportString(data, offs);
        this.writer.write(" autoinc=\"" + Bytes.unpack8(data, offs) + "\">\n");
        btree.export(this);
        this.writer.write(" </org.garret.perst.impl.BtreeFieldIndex>\n");
    }

    final void exportMultiFieldIndex(int oid, byte[] data) throws IOException {
        Btree btree = new Btree(data, 8);
        this.storage.assignOid(btree, oid);
        this.writer.write(" <org.garret.perst.impl.BtreeMultiFieldIndex id=\"" + oid + "\" unique=\"" + (btree.unique ? (char)'1' : '0') + "\" class=");
        int offs = this.exportString(data, 25);
        int nFields = Bytes.unpack4(data, offs);
        offs += 4;
        for (int i = 0; i < nFields; ++i) {
            this.writer.write(" field" + i + "=");
            offs = this.exportString(data, offs);
        }
        this.writer.write(">\n");
        int nTypes = Bytes.unpack4(data, offs);
        offs += 4;
        this.compoundKeyTypes = new int[nTypes];
        for (int i = 0; i < nTypes; ++i) {
            this.compoundKeyTypes[i] = Bytes.unpack4(data, offs);
            offs += 4;
        }
        btree.export(this);
        this.compoundKeyTypes = null;
        this.writer.write(" </org.garret.perst.impl.BtreeMultiFieldIndex>\n");
    }

    final int exportKey(byte[] body, int offs, int size, int type) throws IOException {
        switch (type) {
            case 0: {
                this.writer.write(body[offs++] != 0 ? "1" : "0");
                break;
            }
            case 1: {
                this.writer.write(Integer.toString(body[offs++]));
                break;
            }
            case 2: {
                this.writer.write(Integer.toString((char)Bytes.unpack2(body, offs)));
                offs += 2;
                break;
            }
            case 3: {
                this.writer.write(Integer.toString(Bytes.unpack2(body, offs)));
                offs += 2;
                break;
            }
            case 4: 
            case 10: 
            case 14: {
                this.writer.write(Integer.toString(Bytes.unpack4(body, offs)));
                offs += 4;
                break;
            }
            case 5: {
                this.writer.write(Long.toString(Bytes.unpack8(body, offs)));
                offs += 8;
                break;
            }
            case 6: {
                this.writer.write(Float.toString(Float.intBitsToFloat(Bytes.unpack4(body, offs))));
                offs += 4;
                break;
            }
            case 7: {
                this.writer.write(Double.toString(Double.longBitsToDouble(Bytes.unpack8(body, offs))));
                offs += 8;
                break;
            }
            case 8: {
                for (int i = 0; i < size; ++i) {
                    this.exportChar((char)Bytes.unpack2(body, offs));
                    offs += 2;
                }
                break;
            }
            case 21: {
                for (int i = 0; i < size; ++i) {
                    byte b = body[offs++];
                    this.writer.write(hexDigit[b >>> 4 & 0xF]);
                    this.writer.write(hexDigit[b & 0xF]);
                }
                break;
            }
            case 9: {
                long msec = Bytes.unpack8(body, offs);
                offs += 8;
                if (msec >= 0L) {
                    this.writer.write(XMLImporter.httpFormatter.format(new Date(msec)));
                    break;
                }
                this.writer.write("null");
                break;
            }
            default: {
                Assert.that(false);
            }
        }
        return offs;
    }

    final void exportCompoundKey(byte[] body, int offs, int size, int type) throws IOException {
        Assert.that(type == 21);
        int end = offs + size;
        for (int i = 0; i < this.compoundKeyTypes.length; ++i) {
            type = this.compoundKeyTypes[i];
            if (type == 21 || type == 8) {
                size = Bytes.unpack4(body, offs);
                offs += 4;
            }
            this.writer.write(" key" + i + "=\"");
            offs = this.exportKey(body, offs, size, type);
            this.writer.write("\"");
        }
        Assert.that(offs == end);
    }

    final void exportAssoc(int oid, byte[] body, int offs, int size, int type) throws IOException {
        this.writer.write("  <ref id=\"" + oid + "\"");
        if ((this.exportedBitmap[oid >> 5] & 1 << (oid & 0x1F)) == 0) {
            int n = oid >> 5;
            this.markedBitmap[n] = this.markedBitmap[n] | 1 << (oid & 0x1F);
        }
        if (this.compoundKeyTypes != null) {
            this.exportCompoundKey(body, offs, size, type);
        } else {
            this.writer.write(" key=\"");
            this.exportKey(body, offs, size, type);
            this.writer.write("\"");
        }
        this.writer.write("/>\n");
    }

    final void indentation(int indent) throws IOException {
        while (--indent >= 0) {
            this.writer.write(32);
        }
    }

    final void exportChar(char ch) throws IOException {
        switch (ch) {
            case '<': {
                this.writer.write("&lt;");
                break;
            }
            case '>': {
                this.writer.write("&gt;");
                break;
            }
            case '&': {
                this.writer.write("&amp;");
                break;
            }
            case '\"': {
                this.writer.write("&quot;");
                break;
            }
            default: {
                this.writer.write(ch);
            }
        }
    }

    final int exportString(byte[] body, int offs) throws IOException {
        int len = Bytes.unpack4(body, offs);
        offs += 4;
        if (len >= 0) {
            this.writer.write("\"");
            while (--len >= 0) {
                this.exportChar((char)Bytes.unpack2(body, offs));
                offs += 2;
            }
            this.writer.write("\"");
        } else if (len < -1) {
            this.writer.write("\"");
            String s = this.storage.encoding != null ? new String(body, offs, -len - 2, this.storage.encoding) : new String(body, offs, -len - 2);
            offs -= len + 2;
            int n = s.length();
            for (int i = 0; i < n; ++i) {
                this.exportChar(s.charAt(i));
            }
        } else {
            this.writer.write("null");
        }
        return offs;
    }

    final int exportBinary(byte[] body, int offs) throws IOException {
        int len = Bytes.unpack4(body, offs);
        offs += 4;
        if (len < 0) {
            if (len == -12) {
                this.exportRef(Bytes.unpack4(body, offs));
                offs += 4;
            } else if (len < -1) {
                this.writer.write("\"#");
                this.writer.write(hexDigit[-2 - len]);
                len = ClassDescriptor.sizeof[-2 - len];
                while (--len >= 0) {
                    byte b = body[offs++];
                    this.writer.write(hexDigit[b >>> 4 & 0xF]);
                    this.writer.write(hexDigit[b & 0xF]);
                }
                this.writer.write(34);
            } else {
                this.writer.write("null");
            }
        } else {
            this.writer.write(34);
            while (--len >= 0) {
                byte b = body[offs++];
                this.writer.write(hexDigit[b >>> 4 & 0xF]);
                this.writer.write(hexDigit[b & 0xF]);
            }
            this.writer.write(34);
        }
        return offs;
    }

    final void exportRef(int oid) throws IOException {
        this.writer.write("<ref id=\"" + oid + "\"/>");
        if (oid != 0 && (this.exportedBitmap[oid >> 5] & 1 << (oid & 0x1F)) == 0) {
            int n = oid >> 5;
            this.markedBitmap[n] = this.markedBitmap[n] | 1 << (oid & 0x1F);
        }
    }

    final int exportObject(ClassDescriptor desc, byte[] body, int offs, int indent) throws IOException {
        for (ClassDescriptor.FieldDescriptor fd : desc.allFields) {
            this.indentation(indent);
            String fieldName = this.exportIdentifier(fd.fieldName);
            this.writer.write("<" + fieldName + ">");
            switch (fd.type) {
                case 0: {
                    this.writer.write(body[offs++] != 0 ? "1" : "0");
                    break;
                }
                case 1: {
                    this.writer.write(Integer.toString(body[offs++]));
                    break;
                }
                case 2: {
                    this.writer.write(Integer.toString((char)Bytes.unpack2(body, offs)));
                    offs += 2;
                    break;
                }
                case 3: {
                    this.writer.write(Integer.toString(Bytes.unpack2(body, offs)));
                    offs += 2;
                    break;
                }
                case 4: {
                    this.writer.write(Integer.toString(Bytes.unpack4(body, offs)));
                    offs += 4;
                    break;
                }
                case 5: {
                    this.writer.write(Long.toString(Bytes.unpack8(body, offs)));
                    offs += 8;
                    break;
                }
                case 6: {
                    this.writer.write(Float.toString(Float.intBitsToFloat(Bytes.unpack4(body, offs))));
                    offs += 4;
                    break;
                }
                case 7: {
                    this.writer.write(Double.toString(Double.longBitsToDouble(Bytes.unpack8(body, offs))));
                    offs += 8;
                    break;
                }
                case 14: {
                    int ordinal = Bytes.unpack4(body, offs);
                    if (ordinal < 0) {
                        this.writer.write("null");
                    } else {
                        this.writer.write("\"" + ((Enum)fd.field.getType().getEnumConstants()[ordinal]).name() + "\"");
                    }
                    offs += 4;
                    break;
                }
                case 8: {
                    offs = this.exportString(body, offs);
                    break;
                }
                case 9: {
                    long msec = Bytes.unpack8(body, offs);
                    offs += 8;
                    if (msec >= 0L) {
                        this.writer.write("\"" + XMLImporter.httpFormatter.format(new Date(msec)) + "\"");
                        break;
                    }
                    this.writer.write("null");
                    break;
                }
                case 10: {
                    this.exportRef(Bytes.unpack4(body, offs));
                    offs += 4;
                    break;
                }
                case 11: {
                    this.writer.write(10);
                    offs = this.exportObject(fd.valueDesc, body, offs, indent + 1);
                    this.indentation(indent);
                    break;
                }
                case 12: 
                case 21: {
                    offs = this.exportBinary(body, offs);
                    break;
                }
                case 20: {
                    int len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--len >= 0) {
                        this.indentation(indent + 1);
                        this.writer.write("<element>" + (body[offs++] != 0 ? "1" : "0") + "</element>\n");
                    }
                    this.indentation(indent);
                    break;
                }
                case 22: {
                    int len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--len >= 0) {
                        this.indentation(indent + 1);
                        this.writer.write("<element>" + (Bytes.unpack2(body, offs) & 0xFFFF) + "</element>\n");
                        offs += 2;
                    }
                    this.indentation(indent);
                    break;
                }
                case 23: {
                    int len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--len >= 0) {
                        this.indentation(indent + 1);
                        this.writer.write("<element>" + Bytes.unpack2(body, offs) + "</element>\n");
                        offs += 2;
                    }
                    this.indentation(indent);
                    break;
                }
                case 24: {
                    int len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    Enum[] enumConstants = (Enum[])fd.field.getType().getEnumConstants();
                    while (--len >= 0) {
                        this.indentation(indent + 1);
                        int ordinal = Bytes.unpack4(body, offs);
                        if (ordinal < 0) {
                            this.writer.write("null");
                        } else {
                            this.writer.write("<element>\"" + enumConstants[ordinal].name() + "\"</element>\n");
                        }
                        offs += 4;
                    }
                    this.indentation(indent);
                    break;
                }
                case 25: {
                    int len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--len >= 0) {
                        this.indentation(indent + 1);
                        this.writer.write("<element>" + Bytes.unpack8(body, offs) + "</element>\n");
                        offs += 8;
                    }
                    this.indentation(indent);
                    break;
                }
                case 26: {
                    int len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--len >= 0) {
                        this.indentation(indent + 1);
                        this.writer.write("<element>" + Float.intBitsToFloat(Bytes.unpack4(body, offs)) + "</element>\n");
                        offs += 4;
                    }
                    this.indentation(indent);
                    break;
                }
                case 27: {
                    int len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--len >= 0) {
                        this.indentation(indent + 1);
                        this.writer.write("<element>" + Double.longBitsToDouble(Bytes.unpack8(body, offs)) + "</element>\n");
                        offs += 8;
                    }
                    this.indentation(indent);
                    break;
                }
                case 29: {
                    int len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--len >= 0) {
                        this.indentation(indent + 1);
                        long msec = Bytes.unpack8(body, offs);
                        offs += 8;
                        if (msec >= 0L) {
                            this.writer.write("<element>\"");
                            this.writer.write(XMLImporter.httpFormatter.format(new Date(msec)));
                            this.writer.write("\"</element>\n");
                            continue;
                        }
                        this.writer.write("<element>null</element>\n");
                    }
                    break;
                }
                case 28: {
                    int len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--len >= 0) {
                        this.indentation(indent + 1);
                        this.writer.write("<element>");
                        offs = this.exportString(body, offs);
                        this.writer.write("</element>\n");
                    }
                    this.indentation(indent);
                    break;
                }
                case 13: 
                case 30: {
                    int len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--len >= 0) {
                        this.indentation(indent + 1);
                        int oid = Bytes.unpack4(body, offs);
                        if (oid != 0 && (this.exportedBitmap[oid >> 5] & 1 << (oid & 0x1F)) == 0) {
                            int n = oid >> 5;
                            this.markedBitmap[n] = this.markedBitmap[n] | 1 << (oid & 0x1F);
                        }
                        this.writer.write("<element><ref id=\"" + oid + "\"/></element>\n");
                        offs += 4;
                    }
                    this.indentation(indent);
                    break;
                }
                case 31: {
                    int len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--len >= 0) {
                        this.indentation(indent + 1);
                        this.writer.write("<element>\n");
                        offs = this.exportObject(fd.valueDesc, body, offs, indent + 2);
                        this.indentation(indent + 1);
                        this.writer.write("</element>\n");
                    }
                    this.indentation(indent);
                    break;
                }
                case 32: {
                    int len = Bytes.unpack4(body, offs);
                    offs += 4;
                    if (len < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--len >= 0) {
                        this.indentation(indent + 1);
                        this.writer.write("<element>");
                        offs = this.exportBinary(body, offs);
                        this.writer.write("</element>\n");
                    }
                    this.indentation(indent);
                    break;
                }
            }
            this.writer.write("</" + fieldName + ">\n");
        }
        return offs;
    }
}

