/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.garret.perst.Assert;
import org.garret.perst.IPersistent;
import org.garret.perst.Index;
import org.garret.perst.IterableIterator;
import org.garret.perst.Key;
import org.garret.perst.PersistentCollection;
import org.garret.perst.Storage;
import org.garret.perst.StorageError;
import org.garret.perst.TimeSeries;
import org.garret.perst.impl.ClassDescriptor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeSeriesImpl<T extends TimeSeries.Tick>
extends PersistentCollection<T>
implements TimeSeries<T> {
    private Index index;
    private long maxBlockTimeInterval;
    private String blockClassName;
    private transient Class blockClass;

    @Override
    public ArrayList<T> elements() {
        return new ArrayList(this);
    }

    @Override
    public Object[] toArray() {
        return this.elements().toArray();
    }

    @Override
    public <E> E[] toArray(E[] arr) {
        return this.elements().toArray(arr);
    }

    @Override
    public boolean add(T tick) {
        long time = tick.getTime();
        IPersistent[] blocks = this.index.get(new Key(time - this.maxBlockTimeInterval), new Key(time));
        if (blocks.length != 0) {
            this.insertInBlock((TimeSeries.Block)blocks[blocks.length - 1], (TimeSeries.Tick)tick);
        } else {
            this.addNewBlock((TimeSeries.Tick)tick);
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(null, null, true);
    }

    @Override
    public IterableIterator<T> iterator(Date from, Date till) {
        return this.iterator(from, till, true);
    }

    @Override
    public IterableIterator<T> iterator(boolean ascent) {
        return this.iterator(null, null, ascent);
    }

    @Override
    public IterableIterator<T> iterator(Date from, Date till, boolean ascent) {
        long low = from == null ? 0L : from.getTime();
        long high = till == null ? Long.MAX_VALUE : till.getTime();
        return ascent ? new TimeSeriesIterator(low, high) : new TimeSeriesReverseIterator(low, high);
    }

    @Override
    public Date getFirstTime() {
        Iterator blockIterator = this.index.iterator();
        if (blockIterator.hasNext()) {
            TimeSeries.Block block = (TimeSeries.Block)blockIterator.next();
            return new Date(block.timestamp);
        }
        return null;
    }

    @Override
    public Date getLastTime() {
        IterableIterator blockIterator = this.index.iterator(null, null, 1);
        if (blockIterator.hasNext()) {
            TimeSeries.Block block = (TimeSeries.Block)blockIterator.next();
            return new Date(block.getTicks()[block.used - 1].getTime());
        }
        return null;
    }

    @Override
    public int size() {
        return (int)this.countTicks();
    }

    @Override
    public long countTicks() {
        long n = 0L;
        for (TimeSeries.Block block : this.index) {
            n += (long)block.used;
        }
        return n;
    }

    @Override
    public T getTick(Date timestamp) {
        long time = timestamp.getTime();
        IterableIterator blockIterator = this.index.iterator(new Key(time - this.maxBlockTimeInterval), new Key(time), 0);
        while (blockIterator.hasNext()) {
            TimeSeries.Block block = (TimeSeries.Block)blockIterator.next();
            int n = block.used;
            TimeSeries.Tick[] e = block.getTicks();
            int l = 0;
            int r = n;
            while (l < r) {
                int i = l + r >> 1;
                if (time > e[i].getTime()) {
                    l = i + 1;
                    continue;
                }
                r = i;
            }
            Assert.that(l == r && (l == n || e[l].getTime() >= time));
            if (l >= n || e[l].getTime() != time) continue;
            return (T)e[l];
        }
        return null;
    }

    @Override
    public boolean has(Date timestamp) {
        return this.getTick(timestamp) != null;
    }

    @Override
    public int remove(Date from, Date till) {
        long low = from == null ? 0L : from.getTime();
        long high = till == null ? Long.MAX_VALUE : till.getTime();
        int nRemoved = 0;
        Key fromKey = new Key(low - this.maxBlockTimeInterval);
        Key tillKey = new Key(high);
        IterableIterator blockIterator = this.index.iterator(fromKey, tillKey, 0);
        while (blockIterator.hasNext()) {
            TimeSeries.Block block = (TimeSeries.Block)blockIterator.next();
            int n = block.used;
            TimeSeries.Tick[] e = block.getTicks();
            int l = 0;
            int r = n;
            while (l < r) {
                int i = l + r >> 1;
                if (low > e[i].getTime()) {
                    l = i + 1;
                    continue;
                }
                r = i;
            }
            Assert.that(l == r && (l == n || e[l].getTime() >= low));
            while (r < n && e[r].getTime() <= high) {
                ++r;
                ++nRemoved;
            }
            if (l == 0 && r == n) {
                this.index.remove(new Key(block.timestamp), block);
                blockIterator = this.index.iterator(fromKey, tillKey, 0);
                block.deallocate();
                continue;
            }
            if (l >= n || l == r) continue;
            if (l == 0) {
                this.index.remove(new Key(block.timestamp), block);
                block.timestamp = e[r].getTime();
                this.index.put(new Key(block.timestamp), block);
                blockIterator = this.index.iterator(fromKey, tillKey, 0);
            }
            while (r < n) {
                e[l++] = e[r++];
            }
            block.used = l;
            block.modify();
        }
        return nRemoved;
    }

    private void addNewBlock(TimeSeries.Tick t) {
        TimeSeries.Block block;
        try {
            block = (TimeSeries.Block)this.blockClass.newInstance();
        }
        catch (Exception x) {
            throw new StorageError(12, this.blockClass, x);
        }
        block.timestamp = t.getTime();
        block.used = 1;
        block.getTicks()[0] = t;
        this.index.put(new Key(block.timestamp), block);
    }

    void insertInBlock(TimeSeries.Block block, TimeSeries.Tick tick) {
        int i;
        long t = tick.getTime();
        int n = block.used;
        TimeSeries.Tick[] e = block.getTicks();
        int l = 0;
        int r = n;
        while (l < r) {
            i = l + r >> 1;
            if (t > e[i].getTime()) {
                l = i + 1;
                continue;
            }
            r = i;
        }
        Assert.that(l == r && (l == n || e[l].getTime() >= t));
        if (r == 0) {
            if (e[n - 1].getTime() - t > this.maxBlockTimeInterval || n == e.length) {
                this.addNewBlock(tick);
                return;
            }
            block.timestamp = t;
        } else if (r == n && (t - e[0].getTime() > this.maxBlockTimeInterval || n == e.length)) {
            this.addNewBlock(tick);
            return;
        }
        if (n == e.length) {
            this.addNewBlock(e[n - 1]);
            i = n;
            while (--i > r) {
                e[i] = e[i - 1];
            }
        } else {
            for (i = n; i > r; --i) {
                e[i] = e[i - 1];
            }
            ++block.used;
        }
        e[r] = tick;
        block.modify();
    }

    TimeSeriesImpl(Storage storage, Class blockClass, long maxBlockTimeInterval) {
        this.blockClass = blockClass;
        this.maxBlockTimeInterval = maxBlockTimeInterval;
        this.blockClassName = blockClass.getName();
        this.index = storage.createIndex(Long.TYPE, true);
    }

    TimeSeriesImpl() {
    }

    @Override
    public void onLoad() {
        this.blockClass = ClassDescriptor.loadClass(this.getStorage(), this.blockClassName);
    }

    @Override
    public void clear() {
        for (TimeSeries.Block block : this.index) {
            block.deallocate();
        }
        this.index.clear();
    }

    @Override
    public void deallocate() {
        this.clear();
        this.index.deallocate();
        super.deallocate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TimeSeriesReverseIterator
    extends IterableIterator<T> {
        private Iterator blockIterator;
        private TimeSeries.Block currBlock;
        private int pos = -1;
        private long from;

        TimeSeriesReverseIterator(long from, long till) {
            this.from = from;
            this.blockIterator = TimeSeriesImpl.this.index.iterator(new Key(from - TimeSeriesImpl.this.maxBlockTimeInterval), new Key(till), 1);
            while (this.blockIterator.hasNext()) {
                TimeSeries.Block block = (TimeSeries.Block)this.blockIterator.next();
                int n = block.used;
                TimeSeries.Tick[] e = block.getTicks();
                int l = 0;
                int r = n;
                while (l < r) {
                    int i = l + r >> 1;
                    if (till >= e[i].getTime()) {
                        l = i + 1;
                        continue;
                    }
                    r = i;
                }
                Assert.that(l == r && (l == n || e[l].getTime() > till));
                if (l <= 0) continue;
                if (e[l - 1].getTime() >= from) {
                    this.pos = l - 1;
                    this.currBlock = block;
                }
                return;
            }
        }

        @Override
        public boolean hasNext() {
            return this.pos >= 0;
        }

        @Override
        public T next() {
            if (this.pos < 0) {
                throw new NoSuchElementException();
            }
            TimeSeries.Tick tick = this.currBlock.getTicks()[this.pos];
            if (--this.pos < 0) {
                if (this.blockIterator.hasNext()) {
                    this.currBlock = (TimeSeries.Block)this.blockIterator.next();
                    this.pos = this.currBlock.used - 1;
                } else {
                    this.pos = -1;
                    return tick;
                }
            }
            if (this.currBlock.getTicks()[this.pos].getTime() < this.from) {
                this.pos = -1;
            }
            return tick;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TimeSeriesIterator
    extends IterableIterator<T> {
        private Iterator blockIterator;
        private TimeSeries.Block currBlock;
        private int pos = -1;
        private long till;

        TimeSeriesIterator(long from, long till) {
            this.till = till;
            this.blockIterator = TimeSeriesImpl.this.index.iterator(new Key(from - TimeSeriesImpl.this.maxBlockTimeInterval), new Key(till), 0);
            while (this.blockIterator.hasNext()) {
                TimeSeries.Block block = (TimeSeries.Block)this.blockIterator.next();
                int n = block.used;
                TimeSeries.Tick[] e = block.getTicks();
                int l = 0;
                int r = n;
                while (l < r) {
                    int i = l + r >> 1;
                    if (from > e[i].getTime()) {
                        l = i + 1;
                        continue;
                    }
                    r = i;
                }
                Assert.that(l == r && (l == n || e[l].getTime() >= from));
                if (l >= n) continue;
                if (e[l].getTime() <= till) {
                    this.pos = l;
                    this.currBlock = block;
                }
                return;
            }
        }

        @Override
        public boolean hasNext() {
            return this.pos >= 0;
        }

        @Override
        public T next() {
            if (this.pos < 0) {
                throw new NoSuchElementException();
            }
            TimeSeries.Tick tick = this.currBlock.getTicks()[this.pos];
            if (++this.pos == this.currBlock.used) {
                if (this.blockIterator.hasNext()) {
                    this.currBlock = (TimeSeries.Block)this.blockIterator.next();
                    this.pos = 0;
                } else {
                    this.pos = -1;
                    return tick;
                }
            }
            if (this.currBlock.getTicks()[this.pos].getTime() > this.till) {
                this.pos = -1;
            }
            return tick;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

