/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.garret.perst.IPersistent;
import org.garret.perst.IPersistentSet;
import org.garret.perst.Index;
import org.garret.perst.IterableIterator;
import org.garret.perst.Key;
import org.garret.perst.PersistentCollection;
import org.garret.perst.Relation;
import org.garret.perst.StorageError;
import org.garret.perst.impl.Btree;
import org.garret.perst.impl.StorageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThickIndex<T extends IPersistent>
extends PersistentCollection<T>
implements Index<T> {
    private Index<IPersistent> index;
    private int nElems;
    static final int BTREE_THRESHOLD = 128;

    ThickIndex(Class keyType, StorageImpl db) {
        super(db);
        this.index = db.createIndex(keyType, true);
    }

    ThickIndex() {
    }

    @Override
    public T get(Key key) {
        Relation r;
        IPersistent s = (IPersistent)this.index.get(key);
        if (s == null) {
            return null;
        }
        if (s instanceof Relation && (r = (Relation)s).size() == 1) {
            return r.get(0);
        }
        throw new StorageError(4);
    }

    @Override
    public T get(Object key) {
        return (T)this.get(Btree.getKeyFromObject(key));
    }

    @Override
    public ArrayList<T> getList(Key from, Key till) {
        return this.extendList(this.index.getList(from, till));
    }

    @Override
    public ArrayList<T> getList(Object from, Object till) {
        return this.extendList(this.index.getList(from, till));
    }

    @Override
    public IPersistent[] get(Key from, Key till) {
        return this.extend(this.index.get(from, till));
    }

    @Override
    public IPersistent[] get(Object from, Object till) {
        return this.extend(this.index.get(from, till));
    }

    private ArrayList<T> extendList(ArrayList s) {
        ArrayList list = new ArrayList();
        int n = s.size();
        for (int i = 0; i < n; ++i) {
            list.addAll((Collection)s.get(i));
        }
        return list;
    }

    private IPersistent[] extend(IPersistent[] s) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < s.length; ++i) {
            list.addAll((Collection)((Object)s[i]));
        }
        return list.toArray(new IPersistent[list.size()]);
    }

    public T get(String key) {
        return (T)this.get(new Key(key));
    }

    @Override
    public IPersistent[] getPrefix(String prefix) {
        return this.extend(this.index.getPrefix(prefix));
    }

    @Override
    public ArrayList<T> getPrefixList(String prefix) {
        return this.extendList(this.index.getPrefixList(prefix));
    }

    @Override
    public IPersistent[] prefixSearch(String word) {
        return this.extend(this.index.prefixSearch(word));
    }

    @Override
    public ArrayList<T> prefixSearchList(String word) {
        return this.extendList(this.index.prefixSearchList(word));
    }

    @Override
    public int size() {
        return this.nElems;
    }

    @Override
    public void clear() {
        for (IPersistent p : this.index) {
            p.deallocate();
        }
        this.index.clear();
        this.nElems = 0;
        this.modify();
    }

    @Override
    public IPersistent[] toPersistentArray() {
        return this.extend(this.index.toPersistentArray());
    }

    @Override
    public Object[] toArray() {
        return this.toPersistentArray();
    }

    @Override
    public <E> E[] toArray(E[] arr) {
        ArrayList list = new ArrayList();
        for (IPersistent c : this.index) {
            list.addAll((Collection)((Object)c));
        }
        return list.toArray(arr);
    }

    @Override
    public Iterator<T> iterator() {
        return new ExtendIterator(this.index.iterator());
    }

    @Override
    public IterableIterator<Map.Entry<Object, T>> entryIterator() {
        return new ExtendEntryIterator(this.index.entryIterator());
    }

    @Override
    public IterableIterator<T> iterator(Key from, Key till, int order) {
        return new ExtendIterator(this.index.iterator(from, till, order));
    }

    @Override
    public IterableIterator<T> iterator(Object from, Object till, int order) {
        return new ExtendIterator(this.index.iterator(from, till, order));
    }

    @Override
    public IterableIterator<Map.Entry<Object, T>> entryIterator(Key from, Key till, int order) {
        return new ExtendEntryIterator(this.index.entryIterator(from, till, order));
    }

    @Override
    public IterableIterator<Map.Entry<Object, T>> entryIterator(Object from, Object till, int order) {
        return new ExtendEntryIterator(this.index.entryIterator(from, till, order));
    }

    @Override
    public IterableIterator<T> prefixIterator(String prefix) {
        return new ExtendIterator(this.index.prefixIterator(prefix));
    }

    @Override
    public Class getKeyType() {
        return this.index.getKeyType();
    }

    @Override
    public boolean put(Key key, T obj) {
        IPersistent s = (IPersistent)this.index.get(key);
        if (s == null) {
            Relation r = this.getStorage().createRelation(null);
            r.add(obj);
            this.index.put(key, r);
        } else if (s instanceof Relation) {
            Relation r = (Relation)s;
            if (r.size() == 128) {
                IPersistentSet ps = this.getStorage().createSet();
                for (int i = 0; i < 128; ++i) {
                    ps.add(r.get(i));
                }
                ps.add(obj);
                this.index.set(key, ps);
                r.deallocate();
            } else {
                r.add(obj);
            }
        } else {
            ((IPersistentSet)s).add(obj);
        }
        ++this.nElems;
        this.modify();
        return true;
    }

    @Override
    public T set(Key key, T obj) {
        Relation r;
        IPersistent s = (IPersistent)this.index.get(key);
        if (s == null) {
            Relation r2 = this.getStorage().createRelation(null);
            r2.add(obj);
            this.index.put(key, r2);
            ++this.nElems;
            this.modify();
            return null;
        }
        if (s instanceof Relation && (r = (Relation)s).size() == 1) {
            Object prev = r.get(0);
            r.set(0, obj);
            return prev;
        }
        throw new StorageError(4);
    }

    @Override
    public void remove(Key key, T obj) {
        IPersistentSet ps;
        IPersistent s = (IPersistent)this.index.get(key);
        if (s instanceof Relation) {
            Relation r = (Relation)s;
            int i = r.indexOf(obj);
            if (i >= 0) {
                r.remove(i);
                if (r.size() == 0) {
                    this.index.remove(key, (IPersistent)r);
                    r.deallocate();
                }
                --this.nElems;
                this.modify();
                return;
            }
        } else if (s instanceof IPersistentSet && (ps = (IPersistentSet)s).remove(obj)) {
            if (ps.size() == 0) {
                this.index.remove(key, (IPersistent)ps);
                ps.deallocate();
            }
            --this.nElems;
            this.modify();
            return;
        }
        throw new StorageError(5);
    }

    @Override
    public T remove(Key key) {
        throw new StorageError(4);
    }

    @Override
    public boolean put(Object key, T obj) {
        return this.put(Btree.getKeyFromObject(key), obj);
    }

    @Override
    public T set(Object key, T obj) {
        return this.set(Btree.getKeyFromObject(key), obj);
    }

    @Override
    public void remove(Object key, T obj) {
        this.remove(Btree.getKeyFromObject(key), obj);
    }

    @Override
    public T remove(String key) {
        throw new StorageError(4);
    }

    @Override
    public T removeKey(Object key) {
        throw new StorageError(4);
    }

    @Override
    public void deallocate() {
        this.clear();
        this.index.deallocate();
        super.deallocate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExtendEntryIterator<E extends IPersistent>
    extends IterableIterator<Map.Entry<Object, E>> {
        private Iterator outer;
        private Iterator<E> inner;
        private Object key;

        @Override
        public boolean hasNext() {
            return this.inner != null;
        }

        @Override
        public Map.Entry<Object, E> next() {
            ExtendEntry<IPersistent> curr = new ExtendEntry<IPersistent>(this.key, (IPersistent)this.inner.next());
            if (!this.inner.hasNext()) {
                if (this.outer.hasNext()) {
                    Map.Entry entry = (Map.Entry)this.outer.next();
                    this.key = entry.getKey();
                    this.inner = ((Iterable)entry.getValue()).iterator();
                } else {
                    this.inner = null;
                }
            }
            return curr;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        ExtendEntryIterator(IterableIterator<?> iterator) {
            this.outer = iterator;
            if (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                this.key = entry.getKey();
                this.inner = ((Iterable)entry.getValue()).iterator();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExtendEntry<E extends IPersistent>
    implements Map.Entry<Object, E> {
        private Object key;
        private E value;

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public E getValue() {
            return this.value;
        }

        @Override
        public E setValue(E value) {
            throw new UnsupportedOperationException();
        }

        ExtendEntry(Object key, E value) {
            this.key = key;
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExtendIterator<E extends IPersistent>
    extends IterableIterator<E> {
        private Iterator outer;
        private Iterator<E> inner;

        @Override
        public boolean hasNext() {
            return this.inner != null;
        }

        @Override
        public E next() {
            IPersistent obj = (IPersistent)this.inner.next();
            if (!this.inner.hasNext()) {
                this.inner = this.outer.hasNext() ? ((Iterable)this.outer.next()).iterator() : null;
            }
            return (E)obj;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        ExtendIterator(IterableIterator<?> iterable) {
            this(iterable.iterator());
        }

        ExtendIterator(Iterator<?> iterator) {
            this.outer = iterator;
            if (iterator.hasNext()) {
                this.inner = ((Iterable)iterator.next()).iterator();
            }
        }
    }
}

