/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.garret.perst.IFile;
import org.garret.perst.IResource;
import org.garret.perst.PersistentResource;
import org.garret.perst.ReplicationSlaveStorage;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.Page;
import org.garret.perst.impl.PagePool;
import org.garret.perst.impl.StorageImpl;

public class ReplicationSlaveStorageImpl
extends StorageImpl
implements ReplicationSlaveStorage,
Runnable {
    private static final int DB_HDR_CURR_INDEX_OFFSET = 0;
    private static final int DB_HDR_DIRTY_OFFSET = 1;
    private static final int DB_HDR_INITIALIZED_OFFSET = 2;
    private static final int PAGE_DATA_OFFSET = 8;
    public static int LINGER_TIME = 10;
    protected InputStream in;
    protected OutputStream out;
    protected Socket socket;
    protected int port;
    protected IFile file;
    protected boolean initialized;
    protected boolean listening;
    protected Object init;
    protected Object done;
    protected Object commit;
    protected int prevIndex;
    protected IResource lock;
    protected ServerSocket acceptor;
    protected Thread thread;

    public ReplicationSlaveStorageImpl(int port) {
        this.port = port;
    }

    public void open(IFile file, int pagePoolSize) {
        try {
            this.acceptor = new ServerSocket(this.port);
        }
        catch (IOException x) {
            return;
        }
        byte[] rootPage = new byte[4096];
        int rc = file.read(0L, rootPage);
        if (rc == 4096) {
            this.prevIndex = rootPage[0];
            this.initialized = rootPage[2] != 0;
        } else {
            this.initialized = false;
            this.prevIndex = -1;
        }
        this.file = file;
        this.lock = new PersistentResource();
        this.init = new Object();
        this.done = new Object();
        this.commit = new Object();
        this.listening = true;
        this.connect();
        this.pool = new PagePool(pagePoolSize / 4096);
        this.pool.open(file);
        this.thread = new Thread(this);
        this.thread.start();
        this.waitInitializationCompletion();
        super.open(file, pagePoolSize);
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    public void beginThreadTransaction(int mode) {
        if (mode != 3) {
            throw new IllegalArgumentException("Illegal transaction mode");
        }
        this.lock.sharedLock();
        Page pg = this.pool.getPage(0L);
        this.header.unpack(pg.data);
        this.pool.unfix(pg);
        this.currIndex = 1 - this.header.curr;
        this.committedIndexSize = this.currIndexSize = this.header.root[1 - this.currIndex].indexUsed;
        this.usedSize = this.header.root[this.currIndex].size;
    }

    public void endThreadTransaction(int maxDelay) {
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitInitializationCompletion() {
        try {
            Object object = this.init;
            synchronized (object) {
                while (!this.initialized) {
                    this.init.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForModification() {
        try {
            Object object = this.commit;
            synchronized (object) {
                if (this.socket != null) {
                    this.commit.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void connect() {
        try {
            this.socket = this.acceptor.accept();
            try {
                this.socket.setSoLinger(true, LINGER_TIME);
            }
            catch (NoSuchMethodError er) {
                // empty catch block
            }
            try {
                this.socket.setTcpNoDelay(true);
            }
            catch (Exception x) {
                // empty catch block
            }
            this.in = this.socket.getInputStream();
            if (this.replicationAck) {
                this.out = this.socket.getOutputStream();
            }
        }
        catch (IOException x) {
            this.socket = null;
            this.in = null;
        }
    }

    public boolean handleError() {
        return this.listener != null ? this.listener.replicationError(null) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        byte[] buf = new byte[4104];
        byte[] page = new byte[4096];
        while (this.listening) {
            Object object;
            int offs = 0;
            do {
                int rc;
                try {
                    rc = this.in.read(buf, offs, buf.length - offs);
                }
                catch (IOException x) {
                    rc = -1;
                }
                Object object2 = this.done;
                synchronized (object2) {
                    if (!this.listening) {
                        return;
                    }
                }
                if (rc < 0) {
                    if (this.handleError()) {
                        this.connect();
                        continue;
                    }
                    return;
                }
                offs += rc;
            } while (offs < buf.length);
            long pos = Bytes.unpack8(buf, 0);
            boolean transactionCommit = false;
            if (pos == 0L) {
                if (this.replicationAck) {
                    try {
                        this.out.write(buf, 0, 1);
                    }
                    catch (IOException x) {
                        this.handleError();
                    }
                }
                if (buf[8] != this.prevIndex) {
                    this.prevIndex = buf[8];
                    this.lock.exclusiveLock();
                    transactionCommit = true;
                }
            } else if (pos < 0L) {
                Object x = this.commit;
                synchronized (x) {
                    this.hangup();
                    this.commit.notifyAll();
                }
                return;
            }
            Page pg = this.pool.putPage(pos);
            System.arraycopy(buf, 8, pg.data, 0, 4096);
            this.pool.unfix(pg);
            if (pos != 0L) continue;
            if (!this.initialized && buf[10] != 0) {
                object = this.init;
                synchronized (object) {
                    this.initialized = true;
                    this.init.notify();
                }
            }
            if (!transactionCommit) continue;
            this.lock.unlock();
            object = this.commit;
            synchronized (object) {
                this.commit.notifyAll();
            }
            this.pool.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.done;
        synchronized (object) {
            this.listening = false;
        }
        try {
            this.thread.interrupt();
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.hangup();
        this.pool.flush();
        super.close();
    }

    private void hangup() {
        if (this.socket != null) {
            try {
                this.in.close();
                if (this.out != null) {
                    this.out.close();
                }
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.in = null;
            this.socket = null;
        }
    }

    protected boolean isDirty() {
        return false;
    }
}

