/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.garret.perst.Assert;
import org.garret.perst.IPersistent;
import org.garret.perst.Index;
import org.garret.perst.IterableIterator;
import org.garret.perst.Key;
import org.garret.perst.PersistentCollection;
import org.garret.perst.StorageError;
import org.garret.perst.impl.BtreeKey;
import org.garret.perst.impl.BtreePage;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.ClassDescriptor;
import org.garret.perst.impl.Page;
import org.garret.perst.impl.StorageImpl;
import org.garret.perst.impl.XMLExporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Btree<T extends IPersistent>
extends PersistentCollection<T>
implements Index<T> {
    int root;
    int height;
    int type;
    int nElems;
    boolean unique;
    transient int updateCounter;
    static final int sizeof = 25;
    static final int op_done = 0;
    static final int op_overflow = 1;
    static final int op_underflow = 2;
    static final int op_not_found = 3;
    static final int op_duplicate = 4;
    static final int op_overwrite = 5;

    Btree() {
    }

    static int checkType(Class c) {
        int elemType = ClassDescriptor.getTypeCode(c);
        if (elemType > 10 && elemType != 14 && elemType != 21) {
            throw new StorageError(8, c);
        }
        return elemType;
    }

    int compareByteArrays(byte[] key, byte[] item, int offs, int length) {
        int n = key.length >= length ? length : key.length;
        for (int i = 0; i < n; ++i) {
            int diff = key[i] - item[i + offs];
            if (diff == 0) continue;
            return diff;
        }
        return key.length - length;
    }

    Btree(Class cls, boolean unique) {
        this.unique = unique;
        this.type = Btree.checkType(cls);
    }

    Btree(int type, boolean unique) {
        this.type = type;
        this.unique = unique;
    }

    Btree(byte[] obj, int offs) {
        this.root = Bytes.unpack4(obj, offs);
        this.height = Bytes.unpack4(obj, offs += 4);
        this.type = Bytes.unpack4(obj, offs += 4);
        this.nElems = Bytes.unpack4(obj, offs += 4);
        this.unique = obj[offs += 4] != 0;
    }

    @Override
    public Class getKeyType() {
        switch (this.type) {
            case 0: {
                return Boolean.TYPE;
            }
            case 1: {
                return Byte.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 3: {
                return Short.TYPE;
            }
            case 4: {
                return Integer.TYPE;
            }
            case 5: {
                return Long.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Double.TYPE;
            }
            case 14: {
                return Enum.class;
            }
            case 8: {
                return String.class;
            }
            case 9: {
                return Date.class;
            }
            case 10: {
                return IPersistent.class;
            }
            case 21: {
                return byte[].class;
            }
        }
        return null;
    }

    Key checkKey(Key key) {
        if (key != null) {
            if (key.type != this.type) {
                throw new StorageError(9);
            }
            if (key.oval instanceof String) {
                key = new Key(((String)key.oval).toCharArray(), key.inclusion != 0);
            }
        }
        return key;
    }

    @Override
    public T get(Key key) {
        key = this.checkKey(key);
        if (this.root != 0) {
            ArrayList list = new ArrayList();
            BtreePage.find((StorageImpl)this.getStorage(), this.root, key, key, this, this.height, list);
            if (list.size() > 1) {
                throw new StorageError(4);
            }
            if (list.size() == 0) {
                return null;
            }
            return (T)((IPersistent)list.get(0));
        }
        return null;
    }

    @Override
    public ArrayList<T> prefixSearchList(String key) {
        if (8 != this.type) {
            throw new StorageError(9);
        }
        ArrayList list = new ArrayList();
        if (this.root != 0) {
            BtreePage.prefixSearch((StorageImpl)this.getStorage(), this.root, key.toCharArray(), this.height, list);
        }
        return list;
    }

    @Override
    public IPersistent[] prefixSearch(String key) {
        ArrayList<IPersistent> list = this.prefixSearchList(key);
        return list.toArray(new IPersistent[list.size()]);
    }

    @Override
    public ArrayList<T> getList(Key from, Key till) {
        ArrayList list = new ArrayList();
        if (this.root != 0) {
            BtreePage.find((StorageImpl)this.getStorage(), this.root, this.checkKey(from), this.checkKey(till), this, this.height, list);
        }
        return list;
    }

    @Override
    public ArrayList<T> getList(Object from, Object till) {
        return this.getList(Btree.getKeyFromObject(from), Btree.getKeyFromObject(till));
    }

    @Override
    public T get(Object key) {
        return (T)this.get(Btree.getKeyFromObject(key));
    }

    @Override
    public IPersistent[] get(Key from, Key till) {
        ArrayList<IPersistent> list = this.getList(from, till);
        return list.toArray(new IPersistent[list.size()]);
    }

    @Override
    public IPersistent[] get(Object from, Object till) {
        return this.get(Btree.getKeyFromObject(from), Btree.getKeyFromObject(till));
    }

    @Override
    public boolean put(Key key, T obj) {
        return this.insert(key, obj, false) >= 0;
    }

    @Override
    public T set(Key key, T obj) {
        int oid = this.insert(key, obj, true);
        return (T)(oid != 0 ? ((StorageImpl)this.getStorage()).lookupObject(oid, null) : null);
    }

    final int insert(Key key, T obj, boolean overwrite) {
        StorageImpl db = (StorageImpl)this.getStorage();
        if (db == null) {
            throw new StorageError(16);
        }
        key = this.checkKey(key);
        if (!obj.isPersistent()) {
            db.makePersistent((IPersistent)obj);
        }
        BtreeKey ins = new BtreeKey(key, obj.getOid());
        if (this.root == 0) {
            this.root = BtreePage.allocate(db, 0, this.type, ins);
            this.height = 1;
        } else {
            int result = BtreePage.insert(db, this.root, this, ins, this.height, this.unique, overwrite);
            if (result == 1) {
                this.root = BtreePage.allocate(db, this.root, this.type, ins);
                ++this.height;
            } else {
                if (result == 4) {
                    return -1;
                }
                if (result == 5) {
                    return ins.oldOid;
                }
            }
        }
        ++this.updateCounter;
        ++this.nElems;
        this.modify();
        return 0;
    }

    @Override
    public void remove(Key key, T obj) {
        this.remove(new BtreeKey(this.checkKey(key), obj.getOid()));
    }

    void remove(BtreeKey rem) {
        StorageImpl db = (StorageImpl)this.getStorage();
        if (db == null) {
            throw new StorageError(16);
        }
        if (this.root == 0) {
            throw new StorageError(5);
        }
        int result = BtreePage.remove(db, this.root, this, rem, this.height);
        if (result == 3) {
            throw new StorageError(5);
        }
        --this.nElems;
        if (result == 2) {
            Page pg = db.getPage(this.root);
            if (BtreePage.getnItems(pg) == 0) {
                int newRoot = 0;
                if (this.height != 1) {
                    newRoot = this.type == 8 || this.type == 21 ? BtreePage.getKeyStrOid(pg, 0) : BtreePage.getReference(pg, 1022);
                }
                db.freePage(this.root);
                this.root = newRoot;
                --this.height;
            }
            db.pool.unfix(pg);
        } else if (result == 1) {
            this.root = BtreePage.allocate(db, this.root, this.type, rem);
            ++this.height;
        }
        ++this.updateCounter;
        this.modify();
    }

    @Override
    public T remove(Key key) {
        if (!this.unique) {
            throw new StorageError(4);
        }
        BtreeKey rk = new BtreeKey(this.checkKey(key), 0);
        StorageImpl db = (StorageImpl)this.getStorage();
        this.remove(rk);
        return (T)db.lookupObject(rk.oldOid, null);
    }

    static Key getKeyFromObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return new Key((Byte)o);
        }
        if (o instanceof Short) {
            return new Key((Short)o);
        }
        if (o instanceof Integer) {
            return new Key((Integer)o);
        }
        if (o instanceof Long) {
            return new Key((Long)o);
        }
        if (o instanceof Float) {
            return new Key(((Float)o).floatValue());
        }
        if (o instanceof Double) {
            return new Key((Double)o);
        }
        if (o instanceof Boolean) {
            return new Key((Boolean)o);
        }
        if (o instanceof Character) {
            return new Key(((Character)o).charValue());
        }
        if (o instanceof String) {
            return new Key((String)o);
        }
        if (o instanceof Date) {
            return new Key((Date)o);
        }
        if (o instanceof byte[]) {
            return new Key((byte[])o);
        }
        if (o instanceof Object[]) {
            return new Key((Object[])o);
        }
        if (o instanceof Enum) {
            return new Key((Enum)o);
        }
        if (o instanceof IPersistent) {
            return new Key((IPersistent)o);
        }
        if (o instanceof Comparable) {
            return new Key((Comparable)o);
        }
        throw new StorageError(7);
    }

    @Override
    public ArrayList<T> getPrefixList(String prefix) {
        return this.getList(new Key(prefix.toCharArray(), true), new Key((prefix + '\uffff').toCharArray(), false));
    }

    @Override
    public IPersistent[] getPrefix(String prefix) {
        return this.get(new Key(prefix.toCharArray(), true), new Key((prefix + '\uffff').toCharArray(), false));
    }

    @Override
    public boolean put(Object key, T obj) {
        return this.put(Btree.getKeyFromObject(key), obj);
    }

    @Override
    public T set(Object key, T obj) {
        return this.set(Btree.getKeyFromObject(key), obj);
    }

    @Override
    public void remove(Object key, T obj) {
        this.remove(Btree.getKeyFromObject(key), obj);
    }

    @Override
    public T removeKey(Object key) {
        return this.remove(Btree.getKeyFromObject(key));
    }

    @Override
    public T remove(String key) {
        return this.remove(new Key(key));
    }

    @Override
    public int size() {
        return this.nElems;
    }

    @Override
    public void clear() {
        if (this.root != 0) {
            BtreePage.purge((StorageImpl)this.getStorage(), this.root, this.type, this.height);
            this.root = 0;
            this.nElems = 0;
            this.height = 0;
            ++this.updateCounter;
            this.modify();
        }
    }

    @Override
    public IPersistent[] toPersistentArray() {
        IPersistent[] arr = new IPersistent[this.nElems];
        if (this.root != 0) {
            BtreePage.traverseForward((StorageImpl)this.getStorage(), this.root, this.type, this.height, arr, 0);
        }
        return arr;
    }

    @Override
    public Object[] toArray() {
        return this.toPersistentArray();
    }

    @Override
    public <E> E[] toArray(E[] arr) {
        if (arr.length < this.nElems) {
            arr = (Object[])Array.newInstance(arr.getClass().getComponentType(), this.nElems);
        }
        if (this.root != 0) {
            BtreePage.traverseForward((StorageImpl)this.getStorage(), this.root, this.type, this.height, (IPersistent[])arr, 0);
        }
        if (arr.length > this.nElems) {
            arr[this.nElems] = null;
        }
        return arr;
    }

    @Override
    public void deallocate() {
        if (this.root != 0) {
            BtreePage.purge((StorageImpl)this.getStorage(), this.root, this.type, this.height);
        }
        super.deallocate();
    }

    public int markTree() {
        if (this.root != 0) {
            return BtreePage.markPage((StorageImpl)this.getStorage(), this.root, this.type, this.height);
        }
        return 0;
    }

    protected Object unpackEnum(int val) {
        return val;
    }

    public void export(XMLExporter exporter) throws IOException {
        if (this.root != 0) {
            BtreePage.exportPage((StorageImpl)this.getStorage(), exporter, this.root, this.type, this.height);
        }
    }

    Object unpackKey(StorageImpl db, Page pg, int pos) {
        byte[] data = pg.data;
        int offs = 4 + pos * ClassDescriptor.sizeof[this.type];
        switch (this.type) {
            case 0: {
                return data[offs] != 0;
            }
            case 1: {
                return new Byte(data[offs]);
            }
            case 3: {
                return new Short(Bytes.unpack2(data, offs));
            }
            case 2: {
                return new Character((char)Bytes.unpack2(data, offs));
            }
            case 4: {
                return new Integer(Bytes.unpack4(data, offs));
            }
            case 10: {
                return db.lookupObject(Bytes.unpack4(data, offs), null);
            }
            case 5: {
                return new Long(Bytes.unpack8(data, offs));
            }
            case 9: {
                return new Date(Bytes.unpack8(data, offs));
            }
            case 6: {
                return new Float(Float.intBitsToFloat(Bytes.unpack4(data, offs)));
            }
            case 7: {
                return new Double(Double.longBitsToDouble(Bytes.unpack8(data, offs)));
            }
            case 14: {
                return this.unpackEnum(Bytes.unpack4(data, offs));
            }
            case 8: {
                return Btree.unpackStrKey(pg, pos);
            }
            case 21: {
                return this.unpackByteArrayKey(pg, pos);
            }
        }
        Assert.failed("Invalid type");
        return null;
    }

    static String unpackStrKey(Page pg, int pos) {
        int len = BtreePage.getKeyStrSize(pg, pos);
        int offs = 4 + BtreePage.getKeyStrOffs(pg, pos);
        byte[] data = pg.data;
        char[] sval = new char[len];
        for (int j = 0; j < len; ++j) {
            sval[j] = (char)Bytes.unpack2(data, offs);
            offs += 2;
        }
        return new String(sval);
    }

    Object unpackByteArrayKey(Page pg, int pos) {
        int len = BtreePage.getKeyStrSize(pg, pos);
        int offs = 4 + BtreePage.getKeyStrOffs(pg, pos);
        byte[] val = new byte[len];
        System.arraycopy(pg.data, offs, val, 0, len);
        return val;
    }

    @Override
    public Iterator<T> iterator() {
        return new BtreeIterator();
    }

    @Override
    public IterableIterator<Map.Entry<Object, T>> entryIterator() {
        return new BtreeEntryIterator();
    }

    final int compareByteArrays(Key key, Page pg, int i) {
        return this.compareByteArrays((byte[])key.oval, pg.data, BtreePage.getKeyStrOffs(pg, i) + 4, BtreePage.getKeyStrSize(pg, i));
    }

    @Override
    public IterableIterator<T> iterator(Key from, Key till, int order) {
        return new BtreeSelectionIterator(this.checkKey(from), this.checkKey(till), order);
    }

    @Override
    public IterableIterator<T> prefixIterator(String prefix) {
        return this.iterator(new Key(prefix.toCharArray()), new Key((prefix + '\uffff').toCharArray(), false), 0);
    }

    @Override
    public IterableIterator<Map.Entry<Object, T>> entryIterator(Key from, Key till, int order) {
        return new BtreeSelectionEntryIterator(this.checkKey(from), this.checkKey(till), order);
    }

    @Override
    public IterableIterator<T> iterator(Object from, Object till, int order) {
        return new BtreeSelectionIterator(this.checkKey(Btree.getKeyFromObject(from)), this.checkKey(Btree.getKeyFromObject(till)), order);
    }

    @Override
    public IterableIterator<Map.Entry<Object, T>> entryIterator(Object from, Object till, int order) {
        return new BtreeSelectionEntryIterator(this.checkKey(Btree.getKeyFromObject(from)), this.checkKey(Btree.getKeyFromObject(till)), order);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BtreeSelectionEntryIterator
    extends BtreeSelectionIterator {
        BtreeSelectionEntryIterator(Key from, Key till, int order) {
            super(from, till, order);
        }

        @Override
        protected Object getCurrent(Page pg, int pos) {
            StorageImpl db = (StorageImpl)Btree.this.getStorage();
            switch (Btree.this.type) {
                case 8: {
                    return new BtreeEntry(db, Btree.unpackStrKey(pg, pos), BtreePage.getKeyStrOid(pg, pos));
                }
                case 21: {
                    return new BtreeEntry(db, Btree.this.unpackByteArrayKey(pg, pos), BtreePage.getKeyStrOid(pg, pos));
                }
            }
            return new BtreeEntry(db, Btree.this.unpackKey(db, pg, pos), BtreePage.getReference(pg, 1022 - pos));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BtreeSelectionIterator<E>
    extends IterableIterator<E> {
        int[] pageStack;
        int[] posStack;
        int currPage;
        int currPos;
        int sp;
        int end;
        Key from;
        Key till;
        int order;
        int counter;
        BtreeKey nextKey;
        BtreeKey currKey;

        BtreeSelectionIterator(Key from, Key till, int order) {
            this.from = from;
            this.till = till;
            this.order = order;
            this.reset();
        }

        void reset() {
            this.sp = 0;
            this.counter = Btree.this.updateCounter;
            if (Btree.this.height == 0) {
                return;
            }
            int pageId = Btree.this.root;
            StorageImpl db = (StorageImpl)Btree.this.getStorage();
            if (db == null) {
                throw new StorageError(16);
            }
            int h = Btree.this.height;
            this.pageStack = new int[h];
            this.posStack = new int[h];
            if (Btree.this.type == 8) {
                if (this.order == 0) {
                    Page pg;
                    if (this.from == null) {
                        while (--h >= 0) {
                            this.posStack[this.sp] = 0;
                            this.pageStack[this.sp] = pageId;
                            pg = db.getPage(pageId);
                            pageId = BtreePage.getKeyStrOid(pg, 0);
                            this.end = BtreePage.getnItems(pg);
                            db.pool.unfix(pg);
                            ++this.sp;
                        }
                    } else {
                        int i;
                        int r;
                        int l;
                        while (--h > 0) {
                            this.pageStack[this.sp] = pageId;
                            pg = db.getPage(pageId);
                            l = 0;
                            r = BtreePage.getnItems(pg);
                            while (l < r) {
                                i = l + r >> 1;
                                if (BtreePage.compareStr(this.from, pg, i) >= this.from.inclusion) {
                                    l = i + 1;
                                    continue;
                                }
                                r = i;
                            }
                            Assert.that(r == l);
                            this.posStack[this.sp] = r;
                            pageId = BtreePage.getKeyStrOid(pg, r);
                            db.pool.unfix(pg);
                            ++this.sp;
                        }
                        this.pageStack[this.sp] = pageId;
                        pg = db.getPage(pageId);
                        l = 0;
                        this.end = r = BtreePage.getnItems(pg);
                        while (l < r) {
                            i = l + r >> 1;
                            if (BtreePage.compareStr(this.from, pg, i) >= this.from.inclusion) {
                                l = i + 1;
                                continue;
                            }
                            r = i;
                        }
                        Assert.that(r == l);
                        if (r == this.end) {
                            ++this.sp;
                            this.gotoNextItem(pg, r - 1);
                        } else {
                            this.posStack[this.sp++] = r;
                            db.pool.unfix(pg);
                        }
                    }
                    if (this.sp != 0 && this.till != null) {
                        pg = db.getPage(this.pageStack[this.sp - 1]);
                        if (-BtreePage.compareStr(this.till, pg, this.posStack[this.sp - 1]) >= this.till.inclusion) {
                            this.sp = 0;
                        }
                        db.pool.unfix(pg);
                    }
                } else {
                    Page pg;
                    if (this.till == null) {
                        while (--h > 0) {
                            this.pageStack[this.sp] = pageId;
                            pg = db.getPage(pageId);
                            this.posStack[this.sp] = BtreePage.getnItems(pg);
                            pageId = BtreePage.getKeyStrOid(pg, this.posStack[this.sp]);
                            db.pool.unfix(pg);
                            ++this.sp;
                        }
                        this.pageStack[this.sp] = pageId;
                        pg = db.getPage(pageId);
                        this.posStack[this.sp++] = BtreePage.getnItems(pg) - 1;
                        db.pool.unfix(pg);
                    } else {
                        int i;
                        int r;
                        int l;
                        while (--h > 0) {
                            this.pageStack[this.sp] = pageId;
                            pg = db.getPage(pageId);
                            l = 0;
                            r = BtreePage.getnItems(pg);
                            while (l < r) {
                                i = l + r >> 1;
                                if (BtreePage.compareStr(this.till, pg, i) >= 1 - this.till.inclusion) {
                                    l = i + 1;
                                    continue;
                                }
                                r = i;
                            }
                            Assert.that(r == l);
                            this.posStack[this.sp] = r;
                            pageId = BtreePage.getKeyStrOid(pg, r);
                            db.pool.unfix(pg);
                            ++this.sp;
                        }
                        this.pageStack[this.sp] = pageId;
                        pg = db.getPage(pageId);
                        l = 0;
                        r = BtreePage.getnItems(pg);
                        while (l < r) {
                            i = l + r >> 1;
                            if (BtreePage.compareStr(this.till, pg, i) >= 1 - this.till.inclusion) {
                                l = i + 1;
                                continue;
                            }
                            r = i;
                        }
                        Assert.that(r == l);
                        if (r == 0) {
                            ++this.sp;
                            this.gotoNextItem(pg, r);
                        } else {
                            this.posStack[this.sp++] = r - 1;
                            db.pool.unfix(pg);
                        }
                    }
                    if (this.sp != 0 && this.from != null) {
                        pg = db.getPage(this.pageStack[this.sp - 1]);
                        if (BtreePage.compareStr(this.from, pg, this.posStack[this.sp - 1]) >= this.from.inclusion) {
                            this.sp = 0;
                        }
                        db.pool.unfix(pg);
                    }
                }
            } else if (Btree.this.type == 21) {
                if (this.order == 0) {
                    Page pg;
                    if (this.from == null) {
                        while (--h >= 0) {
                            this.posStack[this.sp] = 0;
                            this.pageStack[this.sp] = pageId;
                            pg = db.getPage(pageId);
                            pageId = BtreePage.getKeyStrOid(pg, 0);
                            this.end = BtreePage.getnItems(pg);
                            db.pool.unfix(pg);
                            ++this.sp;
                        }
                    } else {
                        int i;
                        int r;
                        int l;
                        while (--h > 0) {
                            this.pageStack[this.sp] = pageId;
                            pg = db.getPage(pageId);
                            l = 0;
                            r = BtreePage.getnItems(pg);
                            while (l < r) {
                                i = l + r >> 1;
                                if (Btree.this.compareByteArrays(this.from, pg, i) >= this.from.inclusion) {
                                    l = i + 1;
                                    continue;
                                }
                                r = i;
                            }
                            Assert.that(r == l);
                            this.posStack[this.sp] = r;
                            pageId = BtreePage.getKeyStrOid(pg, r);
                            db.pool.unfix(pg);
                            ++this.sp;
                        }
                        this.pageStack[this.sp] = pageId;
                        pg = db.getPage(pageId);
                        l = 0;
                        this.end = r = BtreePage.getnItems(pg);
                        while (l < r) {
                            i = l + r >> 1;
                            if (Btree.this.compareByteArrays(this.from, pg, i) >= this.from.inclusion) {
                                l = i + 1;
                                continue;
                            }
                            r = i;
                        }
                        Assert.that(r == l);
                        if (r == this.end) {
                            ++this.sp;
                            this.gotoNextItem(pg, r - 1);
                        } else {
                            this.posStack[this.sp++] = r;
                            db.pool.unfix(pg);
                        }
                    }
                    if (this.sp != 0 && this.till != null) {
                        pg = db.getPage(this.pageStack[this.sp - 1]);
                        if (-Btree.this.compareByteArrays(this.till, pg, this.posStack[this.sp - 1]) >= this.till.inclusion) {
                            this.sp = 0;
                        }
                        db.pool.unfix(pg);
                    }
                } else {
                    Page pg;
                    if (this.till == null) {
                        while (--h > 0) {
                            this.pageStack[this.sp] = pageId;
                            pg = db.getPage(pageId);
                            this.posStack[this.sp] = BtreePage.getnItems(pg);
                            pageId = BtreePage.getKeyStrOid(pg, this.posStack[this.sp]);
                            db.pool.unfix(pg);
                            ++this.sp;
                        }
                        this.pageStack[this.sp] = pageId;
                        pg = db.getPage(pageId);
                        this.posStack[this.sp++] = BtreePage.getnItems(pg) - 1;
                        db.pool.unfix(pg);
                    } else {
                        int i;
                        int r;
                        int l;
                        while (--h > 0) {
                            this.pageStack[this.sp] = pageId;
                            pg = db.getPage(pageId);
                            l = 0;
                            r = BtreePage.getnItems(pg);
                            while (l < r) {
                                i = l + r >> 1;
                                if (Btree.this.compareByteArrays(this.till, pg, i) >= 1 - this.till.inclusion) {
                                    l = i + 1;
                                    continue;
                                }
                                r = i;
                            }
                            Assert.that(r == l);
                            this.posStack[this.sp] = r;
                            pageId = BtreePage.getKeyStrOid(pg, r);
                            db.pool.unfix(pg);
                            ++this.sp;
                        }
                        this.pageStack[this.sp] = pageId;
                        pg = db.getPage(pageId);
                        l = 0;
                        r = BtreePage.getnItems(pg);
                        while (l < r) {
                            i = l + r >> 1;
                            if (Btree.this.compareByteArrays(this.till, pg, i) >= 1 - this.till.inclusion) {
                                l = i + 1;
                                continue;
                            }
                            r = i;
                        }
                        Assert.that(r == l);
                        if (r == 0) {
                            ++this.sp;
                            this.gotoNextItem(pg, r);
                        } else {
                            this.posStack[this.sp++] = r - 1;
                            db.pool.unfix(pg);
                        }
                    }
                    if (this.sp != 0 && this.from != null) {
                        pg = db.getPage(this.pageStack[this.sp - 1]);
                        if (Btree.this.compareByteArrays(this.from, pg, this.posStack[this.sp - 1]) >= this.from.inclusion) {
                            this.sp = 0;
                        }
                        db.pool.unfix(pg);
                    }
                }
            } else if (this.order == 0) {
                Page pg;
                if (this.from == null) {
                    while (--h >= 0) {
                        this.posStack[this.sp] = 0;
                        this.pageStack[this.sp] = pageId;
                        pg = db.getPage(pageId);
                        pageId = BtreePage.getReference(pg, 1022);
                        this.end = BtreePage.getnItems(pg);
                        db.pool.unfix(pg);
                        ++this.sp;
                    }
                } else {
                    int i;
                    int r;
                    int l;
                    while (--h > 0) {
                        this.pageStack[this.sp] = pageId;
                        pg = db.getPage(pageId);
                        l = 0;
                        r = BtreePage.getnItems(pg);
                        while (l < r) {
                            i = l + r >> 1;
                            if (BtreePage.compare(this.from, pg, i) >= this.from.inclusion) {
                                l = i + 1;
                                continue;
                            }
                            r = i;
                        }
                        Assert.that(r == l);
                        this.posStack[this.sp] = r;
                        pageId = BtreePage.getReference(pg, 1022 - r);
                        db.pool.unfix(pg);
                        ++this.sp;
                    }
                    this.pageStack[this.sp] = pageId;
                    pg = db.getPage(pageId);
                    l = 0;
                    r = this.end = BtreePage.getnItems(pg);
                    while (l < r) {
                        i = l + r >> 1;
                        if (BtreePage.compare(this.from, pg, i) >= this.from.inclusion) {
                            l = i + 1;
                            continue;
                        }
                        r = i;
                    }
                    Assert.that(r == l);
                    if (r == this.end) {
                        ++this.sp;
                        this.gotoNextItem(pg, r - 1);
                    } else {
                        this.posStack[this.sp++] = r;
                        db.pool.unfix(pg);
                    }
                }
                if (this.sp != 0 && this.till != null) {
                    pg = db.getPage(this.pageStack[this.sp - 1]);
                    if (-BtreePage.compare(this.till, pg, this.posStack[this.sp - 1]) >= this.till.inclusion) {
                        this.sp = 0;
                    }
                    db.pool.unfix(pg);
                }
            } else {
                Page pg;
                if (this.till == null) {
                    while (--h > 0) {
                        this.pageStack[this.sp] = pageId;
                        pg = db.getPage(pageId);
                        this.posStack[this.sp] = BtreePage.getnItems(pg);
                        pageId = BtreePage.getReference(pg, 1022 - this.posStack[this.sp]);
                        db.pool.unfix(pg);
                        ++this.sp;
                    }
                    this.pageStack[this.sp] = pageId;
                    pg = db.getPage(pageId);
                    this.posStack[this.sp++] = BtreePage.getnItems(pg) - 1;
                    db.pool.unfix(pg);
                } else {
                    int i;
                    int r;
                    int l;
                    while (--h > 0) {
                        this.pageStack[this.sp] = pageId;
                        pg = db.getPage(pageId);
                        l = 0;
                        r = BtreePage.getnItems(pg);
                        while (l < r) {
                            i = l + r >> 1;
                            if (BtreePage.compare(this.till, pg, i) >= 1 - this.till.inclusion) {
                                l = i + 1;
                                continue;
                            }
                            r = i;
                        }
                        Assert.that(r == l);
                        this.posStack[this.sp] = r;
                        pageId = BtreePage.getReference(pg, 1022 - r);
                        db.pool.unfix(pg);
                        ++this.sp;
                    }
                    this.pageStack[this.sp] = pageId;
                    pg = db.getPage(pageId);
                    l = 0;
                    r = BtreePage.getnItems(pg);
                    while (l < r) {
                        i = l + r >> 1;
                        if (BtreePage.compare(this.till, pg, i) >= 1 - this.till.inclusion) {
                            l = i + 1;
                            continue;
                        }
                        r = i;
                    }
                    Assert.that(r == l);
                    if (r == 0) {
                        ++this.sp;
                        this.gotoNextItem(pg, r);
                    } else {
                        this.posStack[this.sp++] = r - 1;
                        db.pool.unfix(pg);
                    }
                }
                if (this.sp != 0 && this.from != null) {
                    pg = db.getPage(this.pageStack[this.sp - 1]);
                    if (BtreePage.compare(this.from, pg, this.posStack[this.sp - 1]) >= this.from.inclusion) {
                        this.sp = 0;
                    }
                    db.pool.unfix(pg);
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (this.counter != Btree.this.updateCounter) {
                if (((StorageImpl)Btree.this.getStorage()).concurrentIterator) {
                    this.refresh();
                } else {
                    throw new ConcurrentModificationException();
                }
            }
            return this.sp != 0;
        }

        @Override
        public E next() {
            int pos;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            StorageImpl db = (StorageImpl)Btree.this.getStorage();
            this.currPos = pos = this.posStack[this.sp - 1];
            this.currPage = this.pageStack[this.sp - 1];
            Page pg = db.getPage(this.currPage);
            Object curr = this.getCurrent(pg, pos);
            if (db.concurrentIterator) {
                this.currKey = this.getCurrentKey(pg, pos);
            }
            this.gotoNextItem(pg, pos);
            return (E)curr;
        }

        protected Object getCurrent(Page pg, int pos) {
            StorageImpl db = (StorageImpl)Btree.this.getStorage();
            return db.lookupObject(Btree.this.type == 8 || Btree.this.type == 21 ? BtreePage.getKeyStrOid(pg, pos) : BtreePage.getReference(pg, 1022 - pos), null);
        }

        protected final void gotoNextItem(Page pg, int pos) {
            StorageImpl db = (StorageImpl)Btree.this.getStorage();
            if (Btree.this.type == 8) {
                if (this.order == 0) {
                    if (++pos == this.end) {
                        while (--this.sp != 0) {
                            db.pool.unfix(pg);
                            pos = this.posStack[this.sp - 1];
                            pg = db.getPage(this.pageStack[this.sp - 1]);
                            if (++pos > BtreePage.getnItems(pg)) continue;
                            this.posStack[this.sp - 1] = pos;
                            do {
                                int pageId = BtreePage.getKeyStrOid(pg, pos);
                                db.pool.unfix(pg);
                                pg = db.getPage(pageId);
                                this.end = BtreePage.getnItems(pg);
                                this.pageStack[this.sp] = pageId;
                                pos = 0;
                                this.posStack[this.sp] = 0;
                            } while (++this.sp < this.pageStack.length);
                            break;
                        }
                    } else {
                        this.posStack[this.sp - 1] = pos;
                    }
                    if (this.sp != 0 && this.till != null && -BtreePage.compareStr(this.till, pg, pos) >= this.till.inclusion) {
                        this.sp = 0;
                    }
                } else {
                    if (--pos < 0) {
                        while (--this.sp != 0) {
                            db.pool.unfix(pg);
                            pos = this.posStack[this.sp - 1];
                            pg = db.getPage(this.pageStack[this.sp - 1]);
                            if (--pos < 0) continue;
                            this.posStack[this.sp - 1] = pos;
                            do {
                                int pageId = BtreePage.getKeyStrOid(pg, pos);
                                db.pool.unfix(pg);
                                pg = db.getPage(pageId);
                                this.pageStack[this.sp] = pageId;
                                pos = BtreePage.getnItems(pg);
                                this.posStack[this.sp] = pos--;
                            } while (++this.sp < this.pageStack.length);
                            this.posStack[this.sp - 1] = pos;
                            break;
                        }
                    } else {
                        this.posStack[this.sp - 1] = pos;
                    }
                    if (this.sp != 0 && this.from != null && BtreePage.compareStr(this.from, pg, pos) >= this.from.inclusion) {
                        this.sp = 0;
                    }
                }
            } else if (Btree.this.type == 21) {
                if (this.order == 0) {
                    if (++pos == this.end) {
                        while (--this.sp != 0) {
                            db.pool.unfix(pg);
                            pos = this.posStack[this.sp - 1];
                            pg = db.getPage(this.pageStack[this.sp - 1]);
                            if (++pos > BtreePage.getnItems(pg)) continue;
                            this.posStack[this.sp - 1] = pos;
                            do {
                                int pageId = BtreePage.getKeyStrOid(pg, pos);
                                db.pool.unfix(pg);
                                pg = db.getPage(pageId);
                                this.end = BtreePage.getnItems(pg);
                                this.pageStack[this.sp] = pageId;
                                pos = 0;
                                this.posStack[this.sp] = 0;
                            } while (++this.sp < this.pageStack.length);
                            break;
                        }
                    } else {
                        this.posStack[this.sp - 1] = pos;
                    }
                    if (this.sp != 0 && this.till != null && -Btree.this.compareByteArrays(this.till, pg, pos) >= this.till.inclusion) {
                        this.sp = 0;
                    }
                } else {
                    if (--pos < 0) {
                        while (--this.sp != 0) {
                            db.pool.unfix(pg);
                            pos = this.posStack[this.sp - 1];
                            pg = db.getPage(this.pageStack[this.sp - 1]);
                            if (--pos < 0) continue;
                            this.posStack[this.sp - 1] = pos;
                            do {
                                int pageId = BtreePage.getKeyStrOid(pg, pos);
                                db.pool.unfix(pg);
                                pg = db.getPage(pageId);
                                this.pageStack[this.sp] = pageId;
                                pos = BtreePage.getnItems(pg);
                                this.posStack[this.sp] = pos--;
                            } while (++this.sp < this.pageStack.length);
                            this.posStack[this.sp - 1] = pos;
                            break;
                        }
                    } else {
                        this.posStack[this.sp - 1] = pos;
                    }
                    if (this.sp != 0 && this.from != null && Btree.this.compareByteArrays(this.from, pg, pos) >= this.from.inclusion) {
                        this.sp = 0;
                    }
                }
            } else if (this.order == 0) {
                if (++pos == this.end) {
                    while (--this.sp != 0) {
                        db.pool.unfix(pg);
                        pos = this.posStack[this.sp - 1];
                        pg = db.getPage(this.pageStack[this.sp - 1]);
                        if (++pos > BtreePage.getnItems(pg)) continue;
                        this.posStack[this.sp - 1] = pos;
                        do {
                            int pageId = BtreePage.getReference(pg, 1022 - pos);
                            db.pool.unfix(pg);
                            pg = db.getPage(pageId);
                            this.end = BtreePage.getnItems(pg);
                            this.pageStack[this.sp] = pageId;
                            pos = 0;
                            this.posStack[this.sp] = 0;
                        } while (++this.sp < this.pageStack.length);
                        break;
                    }
                } else {
                    this.posStack[this.sp - 1] = pos;
                }
                if (this.sp != 0 && this.till != null && -BtreePage.compare(this.till, pg, pos) >= this.till.inclusion) {
                    this.sp = 0;
                }
            } else {
                if (--pos < 0) {
                    while (--this.sp != 0) {
                        db.pool.unfix(pg);
                        pos = this.posStack[this.sp - 1];
                        pg = db.getPage(this.pageStack[this.sp - 1]);
                        if (--pos < 0) continue;
                        this.posStack[this.sp - 1] = pos;
                        do {
                            int pageId = BtreePage.getReference(pg, 1022 - pos);
                            db.pool.unfix(pg);
                            pg = db.getPage(pageId);
                            this.pageStack[this.sp] = pageId;
                            pos = BtreePage.getnItems(pg);
                            this.posStack[this.sp] = pos--;
                        } while (++this.sp < this.pageStack.length);
                        this.posStack[this.sp - 1] = pos;
                        break;
                    }
                } else {
                    this.posStack[this.sp - 1] = pos;
                }
                if (this.sp != 0 && this.from != null && BtreePage.compare(this.from, pg, pos) >= this.from.inclusion) {
                    this.sp = 0;
                }
            }
            if (db.concurrentIterator && this.sp != 0) {
                this.nextKey = this.getCurrentKey(pg, pos);
            }
            db.pool.unfix(pg);
        }

        private void refresh() {
            if (this.sp != 0) {
                if (this.nextKey == null) {
                    this.reset();
                } else {
                    Page pg;
                    if (this.order == 0) {
                        this.from = this.nextKey.key;
                    } else {
                        this.till = this.nextKey.key;
                    }
                    this.reset();
                    StorageImpl db = (StorageImpl)Btree.this.getStorage();
                    while (true) {
                        int oid;
                        int pos = this.posStack[this.sp - 1];
                        pg = db.getPage(this.pageStack[this.sp - 1]);
                        int n = oid = Btree.this.type == 8 || Btree.this.type == 21 ? BtreePage.getKeyStrOid(pg, pos) : BtreePage.getReference(pg, 1022 - pos);
                        if (oid == this.nextKey.oid) break;
                        this.gotoNextItem(pg, pos);
                    }
                    db.pool.unfix(pg);
                }
            }
            this.counter = Btree.this.updateCounter;
        }

        BtreeKey getCurrentKey(Page pg, int pos) {
            BtreeKey key;
            switch (Btree.this.type) {
                case 8: {
                    key = new BtreeKey(null, BtreePage.getKeyStrOid(pg, pos));
                    key.getStr(pg, pos);
                    break;
                }
                case 21: {
                    key = new BtreeKey(null, BtreePage.getKeyStrOid(pg, pos));
                    key.getByteArray(pg, pos);
                    break;
                }
                default: {
                    key = new BtreeKey(null, BtreePage.getReference(pg, 1022 - pos));
                    key.extract(pg, 4 + pos * ClassDescriptor.sizeof[Btree.this.type], Btree.this.type);
                }
            }
            return key;
        }

        @Override
        public void remove() {
            if (this.currPage == 0) {
                throw new NoSuchElementException();
            }
            StorageImpl db = (StorageImpl)Btree.this.getStorage();
            if (!db.concurrentIterator) {
                if (this.counter != Btree.this.updateCounter) {
                    throw new ConcurrentModificationException();
                }
                Page pg = db.getPage(this.currPage);
                this.currKey = this.getCurrentKey(pg, this.currPos);
                db.pool.unfix(pg);
                if (this.sp != 0) {
                    int pos = this.posStack[this.sp - 1];
                    pg = db.getPage(this.pageStack[this.sp - 1]);
                    this.nextKey = this.getCurrentKey(pg, pos);
                    db.pool.unfix(pg);
                }
            }
            Btree.this.remove(this.currKey);
            this.refresh();
            this.currPage = 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BtreeEntryIterator
    extends BtreeIterator {
        BtreeEntryIterator() {
        }

        @Override
        protected Object getCurrent(Page pg, int pos) {
            StorageImpl db = (StorageImpl)Btree.this.getStorage();
            if (db == null) {
                throw new StorageError(16);
            }
            switch (Btree.this.type) {
                case 8: {
                    return new BtreeEntry(db, Btree.unpackStrKey(pg, pos), BtreePage.getKeyStrOid(pg, pos));
                }
                case 21: {
                    return new BtreeEntry(db, Btree.this.unpackByteArrayKey(pg, pos), BtreePage.getKeyStrOid(pg, pos));
                }
            }
            return new BtreeEntry(db, Btree.this.unpackKey(db, pg, pos), BtreePage.getReference(pg, 1022 - pos));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BtreeIterator<E>
    extends IterableIterator<E> {
        int[] pageStack;
        int[] posStack;
        int sp;
        int end;
        int counter;

        BtreeIterator() {
            StorageImpl db = (StorageImpl)Btree.this.getStorage();
            if (db == null) {
                throw new StorageError(16);
            }
            int pageId = Btree.this.root;
            int h = Btree.this.height;
            this.counter = Btree.this.updateCounter;
            this.pageStack = new int[h];
            this.posStack = new int[h];
            this.sp = 0;
            while (--h >= 0) {
                this.posStack[this.sp] = 0;
                this.pageStack[this.sp] = pageId;
                Page pg = db.getPage(pageId);
                pageId = this.getReference(pg, 0);
                this.end = BtreePage.getnItems(pg);
                db.pool.unfix(pg);
                ++this.sp;
            }
        }

        protected int getReference(Page pg, int pos) {
            return Btree.this.type == 8 || Btree.this.type == 21 ? BtreePage.getKeyStrOid(pg, pos) : BtreePage.getReference(pg, 1022 - pos);
        }

        @Override
        public boolean hasNext() {
            if (this.counter != Btree.this.updateCounter) {
                throw new ConcurrentModificationException();
            }
            return this.sp > 0 && this.posStack[this.sp - 1] < this.end;
        }

        protected Object getCurrent(Page pg, int pos) {
            StorageImpl db = (StorageImpl)Btree.this.getStorage();
            return db.lookupObject(this.getReference(pg, pos), null);
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            StorageImpl db = (StorageImpl)Btree.this.getStorage();
            int pos = this.posStack[this.sp - 1];
            Page pg = db.getPage(this.pageStack[this.sp - 1]);
            Object curr = this.getCurrent(pg, pos);
            if (++pos == this.end) {
                while (--this.sp != 0) {
                    db.pool.unfix(pg);
                    pos = this.posStack[this.sp - 1];
                    pg = db.getPage(this.pageStack[this.sp - 1]);
                    if (++pos > BtreePage.getnItems(pg)) continue;
                    this.posStack[this.sp - 1] = pos;
                    do {
                        int pageId = this.getReference(pg, pos);
                        db.pool.unfix(pg);
                        pg = db.getPage(pageId);
                        this.end = BtreePage.getnItems(pg);
                        this.pageStack[this.sp] = pageId;
                        pos = 0;
                        this.posStack[this.sp] = 0;
                    } while (++this.sp < this.pageStack.length);
                    break;
                }
            } else {
                this.posStack[this.sp - 1] = pos;
            }
            db.pool.unfix(pg);
            return (E)curr;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BtreeEntry<T>
    implements Map.Entry<Object, T> {
        private Object key;
        private StorageImpl db;
        private int oid;

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return (T)this.db.lookupObject(this.oid, null);
        }

        @Override
        public T setValue(T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.getKey() == null ? e.getKey() == null : this.getKey().equals(e.getKey())) && (this.getValue() == null ? this.getValue() == null : this.getValue().equals(e.getValue()));
        }

        BtreeEntry(StorageImpl db, Object key, int oid) {
            this.db = db;
            this.key = key;
            this.oid = oid;
        }
    }
}

