/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.garret.perst.Assert;
import org.garret.perst.BitIndex;
import org.garret.perst.IPersistent;
import org.garret.perst.IterableIterator;
import org.garret.perst.StorageError;
import org.garret.perst.impl.Btree;
import org.garret.perst.impl.BtreePage;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.Page;
import org.garret.perst.impl.StorageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BitIndexImpl<T extends IPersistent>
extends Btree<T>
implements BitIndex<T> {
    BitIndexImpl() {
        super(4, true);
    }

    @Override
    public int get(T obj) {
        StorageImpl db = (StorageImpl)this.getStorage();
        if (this.root == 0) {
            throw new StorageError(5);
        }
        return BitIndexPage.find(db, this.root, obj.getOid(), this.height);
    }

    @Override
    public void put(T obj, int mask) {
        StorageImpl db = (StorageImpl)this.getStorage();
        if (db == null) {
            throw new StorageError(16);
        }
        if (!obj.isPersistent()) {
            db.makePersistent((IPersistent)obj);
        }
        Key ins = new Key(mask, obj.getOid());
        if (this.root == 0) {
            this.root = BitIndexPage.allocate(db, 0, ins);
            this.height = 1;
        } else {
            int result = BitIndexPage.insert(db, this.root, ins, this.height);
            if (result == 1) {
                this.root = BitIndexPage.allocate(db, this.root, ins);
                ++this.height;
            }
        }
        ++this.updateCounter;
        ++this.nElems;
        this.modify();
    }

    @Override
    public void remove(T obj) {
        StorageImpl db = (StorageImpl)this.getStorage();
        if (db == null) {
            throw new StorageError(16);
        }
        if (this.root == 0) {
            throw new StorageError(5);
        }
        int result = BitIndexPage.remove(db, this.root, obj.getOid(), this.height);
        if (result == 3) {
            throw new StorageError(5);
        }
        --this.nElems;
        if (result == 2) {
            Page pg = db.getPage(this.root);
            if (BitIndexPage.getnItems(pg) == 0) {
                int newRoot = 0;
                if (this.height != 1) {
                    newRoot = BitIndexPage.getItem(pg, 1022);
                }
                db.freePage(this.root);
                this.root = newRoot;
                --this.height;
            }
            db.pool.unfix(pg);
        }
        ++this.updateCounter;
        this.modify();
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(0, 0);
    }

    @Override
    public IterableIterator<T> iterator(int set, int clear) {
        return new BitIndexIterator(set, clear);
    }

    static class BitIndexPage
    extends BtreePage {
        static final int max = 511;

        BitIndexPage() {
        }

        static int getItem(Page pg, int index) {
            return Bytes.unpack4(pg.data, 4 + index * 4);
        }

        static void setItem(Page pg, int index, int mask) {
            Bytes.pack4(pg.data, 4 + index * 4, mask);
        }

        static int allocate(StorageImpl db, int root, Key ins) {
            int pageId = db.allocatePage();
            Page pg = db.putPage(pageId);
            BitIndexPage.setnItems(pg, 1);
            BitIndexPage.setItem(pg, 0, ins.key);
            BitIndexPage.setItem(pg, 1022, ins.oid);
            BitIndexPage.setItem(pg, 1021, root);
            db.pool.unfix(pg);
            return pageId;
        }

        static void memcpy(Page dst_pg, int dst_idx, Page src_pg, int src_idx, int len) {
            System.arraycopy(src_pg.data, 4 + src_idx * 4, dst_pg.data, 4 + dst_idx * 4, len * 4);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static int find(StorageImpl db, int pageId, int oid, int height) {
            Page pg = db.getPage(pageId);
            try {
                int n = BitIndexPage.getnItems(pg);
                int l = 0;
                int r = n;
                if (--height == 0) {
                    while (l < r) {
                        int i = l + r >> 1;
                        if (oid > BitIndexPage.getItem(pg, 1022 - i)) {
                            l = i + 1;
                            continue;
                        }
                        r = i;
                    }
                    if (r < n && BitIndexPage.getItem(pg, 1023 - r - 1) == oid) {
                        int n2 = BitIndexPage.getItem(pg, r);
                        return n2;
                    }
                    throw new StorageError(5);
                }
                while (l < r) {
                    int i = l + r >> 1;
                    if (oid > BitIndexPage.getItem(pg, i)) {
                        l = i + 1;
                        continue;
                    }
                    r = i;
                }
                int n3 = BitIndexPage.find(db, BitIndexPage.getItem(pg, 1023 - r - 1), oid, height);
                return n3;
            }
            finally {
                if (pg != null) {
                    db.pool.unfix(pg);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static int insert(StorageImpl db, int pageId, Key ins, int height) {
            int n;
            Page pg = db.getPage(pageId);
            int l = 0;
            int r = n = BitIndexPage.getnItems(pg);
            int oid = ins.oid;
            try {
                int i;
                if (--height != 0) {
                    while (l < r) {
                        i = l + r >> 1;
                        if (oid > BitIndexPage.getItem(pg, i)) {
                            l = i + 1;
                            continue;
                        }
                        r = i;
                    }
                    Assert.that(l == r);
                    int result = BitIndexPage.insert(db, BitIndexPage.getItem(pg, 1023 - r - 1), ins, height);
                    Assert.that(result != 3);
                    if (result != 1) {
                        int n2 = result;
                        return n2;
                    }
                    ++n;
                } else {
                    while (l < r) {
                        i = l + r >> 1;
                        if (oid > BitIndexPage.getItem(pg, 1022 - i)) {
                            l = i + 1;
                            continue;
                        }
                        r = i;
                    }
                    if (r < n && oid == BitIndexPage.getItem(pg, 1022 - r)) {
                        db.pool.unfix(pg);
                        pg = null;
                        pg = db.putPage(pageId);
                        BitIndexPage.setItem(pg, r, ins.key);
                        i = 5;
                        return i;
                    }
                }
                db.pool.unfix(pg);
                pg = null;
                pg = db.putPage(pageId);
                if (n < 511) {
                    BitIndexPage.memcpy(pg, r + 1, pg, r, n - r);
                    BitIndexPage.memcpy(pg, 1023 - n - 1, pg, 1023 - n, n - r);
                    BitIndexPage.setItem(pg, r, ins.key);
                    BitIndexPage.setItem(pg, 1022 - r, ins.oid);
                    BitIndexPage.setnItems(pg, BitIndexPage.getnItems(pg) + 1);
                    i = 0;
                    return i;
                }
                pageId = db.allocatePage();
                Page b = db.putPage(pageId);
                Assert.that(n == 511);
                int m = 255;
                if (r < m) {
                    BitIndexPage.memcpy(b, 0, pg, 0, r);
                    BitIndexPage.memcpy(b, r + 1, pg, r, m - r - 1);
                    BitIndexPage.memcpy(pg, 0, pg, m - 1, 511 - m + 1);
                    BitIndexPage.memcpy(b, 1023 - r, pg, 1023 - r, r);
                    BitIndexPage.setItem(b, r, ins.key);
                    BitIndexPage.setItem(b, 1022 - r, ins.oid);
                    BitIndexPage.memcpy(b, 1023 - m, pg, 1023 - m + 1, m - r - 1);
                    BitIndexPage.memcpy(pg, 512 + m - 1, pg, 512, 511 - m + 1);
                } else {
                    BitIndexPage.memcpy(b, 0, pg, 0, m);
                    BitIndexPage.memcpy(pg, 0, pg, m, r - m);
                    BitIndexPage.memcpy(pg, r - m + 1, pg, r, 511 - r);
                    BitIndexPage.memcpy(b, 1023 - m, pg, 1023 - m, m);
                    BitIndexPage.memcpy(pg, 1023 - r + m, pg, 1023 - r, r - m);
                    BitIndexPage.setItem(pg, r - m, ins.key);
                    BitIndexPage.setItem(pg, 1022 - r + m, ins.oid);
                    BitIndexPage.memcpy(pg, 512 + m - 1, pg, 512, 511 - r);
                }
                ins.oid = pageId;
                if (height == 0) {
                    ins.key = BitIndexPage.getItem(b, 1023 - m);
                    BitIndexPage.setnItems(pg, 511 - m + 1);
                    BitIndexPage.setnItems(b, m);
                } else {
                    ins.key = BitIndexPage.getItem(b, m - 1);
                    BitIndexPage.setnItems(pg, 511 - m);
                    BitIndexPage.setnItems(b, m - 1);
                }
                db.pool.unfix(b);
                int n3 = 1;
                return n3;
            }
            finally {
                if (pg != null) {
                    db.pool.unfix(pg);
                }
            }
        }

        static int handlePageUnderflow(StorageImpl db, Page pg, int r, int height) {
            int nItems = BitIndexPage.getnItems(pg);
            Page a = db.putPage(BitIndexPage.getItem(pg, 1023 - r - 1));
            int an = BitIndexPage.getnItems(a);
            if (r < nItems) {
                Page b = db.getPage(BitIndexPage.getItem(pg, 1023 - r - 2));
                int bn = BitIndexPage.getnItems(b);
                Assert.that(bn >= an);
                if (height != 1) {
                    BitIndexPage.memcpy(a, an, pg, r, 1);
                    ++an;
                    ++bn;
                }
                if (an + bn > 511) {
                    int i = bn - (an + bn >> 1);
                    db.pool.unfix(b);
                    b = db.putPage(BitIndexPage.getItem(pg, 1023 - r - 2));
                    BitIndexPage.memcpy(a, an, b, 0, i);
                    BitIndexPage.memcpy(b, 0, b, i, bn - i);
                    BitIndexPage.memcpy(a, 1023 - an - i, b, 1023 - i, i);
                    BitIndexPage.memcpy(b, 1023 - bn + i, b, 1023 - bn, bn - i);
                    if (height != 1) {
                        BitIndexPage.memcpy(pg, r, a, an + i - 1, 1);
                    } else {
                        BitIndexPage.memcpy(pg, r, a, 1023 - an - i, 1);
                    }
                    BitIndexPage.setnItems(b, BitIndexPage.getnItems(b) - i);
                    BitIndexPage.setnItems(a, BitIndexPage.getnItems(a) + i);
                    db.pool.unfix(a);
                    db.pool.unfix(b);
                    return 0;
                }
                BitIndexPage.memcpy(a, an, b, 0, bn);
                BitIndexPage.memcpy(a, 1023 - an - bn, b, 1023 - bn, bn);
                db.freePage(BitIndexPage.getItem(pg, 1023 - r - 2));
                BitIndexPage.memcpy(pg, 1023 - nItems, pg, 1023 - nItems - 1, nItems - r - 1);
                BitIndexPage.memcpy(pg, r, pg, r + 1, nItems - r - 1);
                BitIndexPage.setnItems(a, BitIndexPage.getnItems(a) + bn);
                BitIndexPage.setnItems(pg, nItems - 1);
                db.pool.unfix(a);
                db.pool.unfix(b);
                return nItems < 255 ? 2 : 0;
            }
            Page b = db.getPage(BitIndexPage.getItem(pg, 1023 - r));
            int bn = BitIndexPage.getnItems(b);
            Assert.that(bn >= an);
            if (height != 1) {
                ++an;
                ++bn;
            }
            if (an + bn > 511) {
                int i = bn - (an + bn >> 1);
                db.pool.unfix(b);
                b = db.putPage(BitIndexPage.getItem(pg, 1023 - r));
                BitIndexPage.memcpy(a, i, a, 0, an);
                BitIndexPage.memcpy(a, 0, b, bn - i, i);
                BitIndexPage.memcpy(a, 1023 - an - i, a, 1023 - an, an);
                BitIndexPage.memcpy(a, 1023 - i, b, 1023 - bn, i);
                if (height != 1) {
                    BitIndexPage.memcpy(a, i - 1, pg, r - 1, 1);
                    BitIndexPage.memcpy(pg, r - 1, b, bn - i - 1, 1);
                } else {
                    BitIndexPage.memcpy(pg, r - 1, b, 1023 - bn + i, 1);
                }
                BitIndexPage.setnItems(b, BitIndexPage.getnItems(b) - i);
                BitIndexPage.setnItems(a, BitIndexPage.getnItems(a) + i);
                db.pool.unfix(a);
                db.pool.unfix(b);
                return 0;
            }
            BitIndexPage.memcpy(a, bn, a, 0, an);
            BitIndexPage.memcpy(a, 0, b, 0, bn);
            BitIndexPage.memcpy(a, 1023 - an - bn, a, 1023 - an, an);
            BitIndexPage.memcpy(a, 1023 - bn, b, 1023 - bn, bn);
            if (height != 1) {
                BitIndexPage.memcpy(a, bn - 1, pg, r - 1, 1);
            }
            db.freePage(BitIndexPage.getItem(pg, 1023 - r));
            BitIndexPage.setItem(pg, 1023 - r, BitIndexPage.getItem(pg, 1023 - r - 1));
            BitIndexPage.setnItems(a, BitIndexPage.getnItems(a) + bn);
            BitIndexPage.setnItems(pg, nItems - 1);
            db.pool.unfix(a);
            db.pool.unfix(b);
            return nItems < 255 ? 2 : 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static int remove(StorageImpl db, int pageId, int oid, int height) {
            Page pg = db.getPage(pageId);
            try {
                int n = BitIndexPage.getnItems(pg);
                int l = 0;
                int r = n;
                if (--height == 0) {
                    while (l < r) {
                        int i = l + r >> 1;
                        if (oid > BitIndexPage.getItem(pg, 1022 - i)) {
                            l = i + 1;
                            continue;
                        }
                        r = i;
                    }
                    if (r < n && BitIndexPage.getItem(pg, 1023 - r - 1) == oid) {
                        db.pool.unfix(pg);
                        pg = null;
                        pg = db.putPage(pageId);
                        BitIndexPage.memcpy(pg, r, pg, r + 1, n - r - 1);
                        BitIndexPage.memcpy(pg, 1023 - n + 1, pg, 1023 - n, n - r - 1);
                        BitIndexPage.setnItems(pg, --n);
                        int n2 = n < 255 ? 2 : 0;
                        return n2;
                    }
                    int n3 = 3;
                    return n3;
                }
                while (l < r) {
                    int i = l + r >> 1;
                    if (oid > BitIndexPage.getItem(pg, i)) {
                        l = i + 1;
                        continue;
                    }
                    r = i;
                }
                int result = BitIndexPage.remove(db, BitIndexPage.getItem(pg, 1023 - r - 1), oid, height);
                if (result == 2) {
                    db.pool.unfix(pg);
                    pg = null;
                    pg = db.putPage(pageId);
                    int n4 = BitIndexPage.handlePageUnderflow(db, pg, r, height);
                    return n4;
                }
                int n5 = result;
                return n5;
            }
            finally {
                if (pg != null) {
                    db.pool.unfix(pg);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BitIndexIterator<E extends IPersistent>
    extends IterableIterator<E> {
        int[] pageStack;
        int[] posStack;
        int sp = 0;
        int set;
        int clear;
        int counter;

        BitIndexIterator(int set, int clear) {
            Page pg;
            this.counter = BitIndexImpl.this.updateCounter;
            if (BitIndexImpl.this.height == 0) {
                return;
            }
            int pageId = BitIndexImpl.this.root;
            StorageImpl db = (StorageImpl)BitIndexImpl.this.getStorage();
            if (db == null) {
                throw new StorageError(16);
            }
            int h = BitIndexImpl.this.height;
            this.set = set;
            this.clear = clear;
            this.pageStack = new int[h];
            this.posStack = new int[h];
            while (true) {
                this.pageStack[this.sp] = pageId;
                pg = db.getPage(pageId);
                ++this.sp;
                if (--h == 0) break;
                pageId = BitIndexPage.getItem(pg, 1022);
                db.pool.unfix(pg);
            }
            this.gotoNextItem(pg, 0);
        }

        @Override
        public boolean hasNext() {
            if (this.counter != BitIndexImpl.this.updateCounter) {
                throw new ConcurrentModificationException();
            }
            return this.sp != 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            StorageImpl db = (StorageImpl)BitIndexImpl.this.getStorage();
            int pos = this.posStack[this.sp - 1];
            Page pg = db.getPage(this.pageStack[this.sp - 1]);
            IPersistent curr = db.lookupObject(BitIndexPage.getItem(pg, 1022 - pos), null);
            this.gotoNextItem(pg, pos + 1);
            return (E)curr;
        }

        private final void gotoNextItem(Page pg, int pos) {
            StorageImpl db = (StorageImpl)BitIndexImpl.this.getStorage();
            do {
                int end = BitIndexPage.getnItems(pg);
                while (pos < end) {
                    int mask = BitIndexPage.getItem(pg, pos);
                    if ((this.set & mask) == this.set && (this.clear & mask) == 0) {
                        this.posStack[this.sp - 1] = pos;
                        db.pool.unfix(pg);
                        return;
                    }
                    ++pos;
                }
                while (--this.sp != 0) {
                    db.pool.unfix(pg);
                    pos = this.posStack[this.sp - 1];
                    pg = db.getPage(this.pageStack[this.sp - 1]);
                    if (++pos > BitIndexPage.getnItems(pg)) continue;
                    this.posStack[this.sp - 1] = pos;
                    do {
                        int pageId = BitIndexPage.getItem(pg, 1022 - pos);
                        db.pool.unfix(pg);
                        pg = db.getPage(pageId);
                        this.pageStack[this.sp] = pageId;
                        pos = 0;
                        this.posStack[this.sp] = 0;
                    } while (++this.sp < this.pageStack.length);
                }
            } while (this.sp != 0);
            db.pool.unfix(pg);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class Key {
        int key;
        int oid;

        Key(int key, int oid) {
            this.key = key;
            this.oid = oid;
        }
    }
}

