/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class Comparative
extends PostfixMathCommand {
    int id;
    double tolerance;
    public static final int LT = 0;
    public static final int GT = 1;
    public static final int LE = 2;
    public static final int GE = 3;
    public static final int NE = 4;
    public static final int EQ = 5;

    public Comparative(int n) {
        this.id = n;
        this.numberOfParameters = 2;
        this.tolerance = 1.0E-6;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e = stack.pop();
        Object e2 = stack.pop();
        boolean bl = false;
        switch (this.id) {
            case 0: {
                bl = this.lt(e2, e);
                break;
            }
            case 1: {
                bl = this.gt(e2, e);
                break;
            }
            case 2: {
                bl = this.le(e2, e);
                break;
            }
            case 3: {
                bl = this.ge(e2, e);
                break;
            }
            case 4: {
                bl = this.ne(e2, e);
                break;
            }
            case 5: {
                bl = this.eq(e2, e);
            }
        }
        if (bl) {
            stack.push(new Double(1.0));
        } else {
            stack.push(new Double(0.0));
        }
    }

    public boolean lt(Object object, Object object2) throws ParseException {
        if (object instanceof Complex || object2 instanceof Complex) {
            throw new ParseException("< not defined for complex numbers");
        }
        if (object instanceof Number && object2 instanceof Number) {
            double d;
            double d2 = ((Number)object).doubleValue();
            return d2 < (d = ((Number)object2).doubleValue());
        }
        throw new ParseException("< not defined for object of type " + object.getClass().getName() + " and " + object.getClass().getName());
    }

    public boolean gt(Object object, Object object2) throws ParseException {
        if (object instanceof Complex || object2 instanceof Complex) {
            throw new ParseException("> not defined for complex numbers");
        }
        if (object instanceof Number && object2 instanceof Number) {
            double d;
            double d2 = ((Number)object).doubleValue();
            return d2 > (d = ((Number)object2).doubleValue());
        }
        throw new ParseException("> not defined for object of type " + object.getClass().getName() + " and " + object.getClass().getName());
    }

    public boolean le(Object object, Object object2) throws ParseException {
        if (object instanceof Complex || object2 instanceof Complex) {
            throw new ParseException("<= not defined for complex numbers");
        }
        if (object instanceof Number && object2 instanceof Number) {
            double d;
            double d2 = ((Number)object).doubleValue();
            return d2 <= (d = ((Number)object2).doubleValue());
        }
        throw new ParseException("<= not defined for object of type " + object.getClass().getName() + " and " + object.getClass().getName());
    }

    public boolean ge(Object object, Object object2) throws ParseException {
        if (object instanceof Complex || object2 instanceof Complex) {
            throw new ParseException(">= not defined for complex numbers");
        }
        if (object instanceof Number && object2 instanceof Number) {
            double d;
            double d2 = ((Number)object).doubleValue();
            return d2 >= (d = ((Number)object2).doubleValue());
        }
        throw new ParseException(">= not defined for object of type " + object.getClass().getName() + " and " + object.getClass().getName());
    }

    public boolean eq(Object object, Object object2) throws ParseException {
        if (object instanceof Complex && object2 instanceof Complex) {
            return ((Complex)object).equals((Complex)object2, this.tolerance);
        }
        if (object instanceof Complex && object2 instanceof Double) {
            return ((Complex)object).equals(new Complex((Number)object2), this.tolerance);
        }
        if (object2 instanceof Complex && object instanceof Double) {
            return ((Complex)object2).equals(new Complex((Number)object), this.tolerance);
        }
        return object.equals(object2);
    }

    public boolean ne(Object object, Object object2) throws ParseException {
        if (object instanceof Complex && object2 instanceof Complex) {
            return !((Complex)object).equals((Complex)object2, this.tolerance);
        }
        if (object instanceof Complex && object2 instanceof Double) {
            return !((Complex)object).equals(new Complex((Number)object2), this.tolerance);
        }
        if (object2 instanceof Complex && object instanceof Double) {
            return !((Complex)object2).equals(new Complex((Number)object), this.tolerance);
        }
        return !object.equals(object2);
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double d) {
        this.tolerance = d;
    }
}

