/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.garret.perst.JSQLNoSuchFieldException;
import org.garret.perst.JSQLNullPointerException;
import org.garret.perst.impl.FilterIterator;
import org.garret.perst.impl.Node;
import org.garret.perst.impl.QueryImpl;

class InvokeAnyNode
extends Node {
    Node target;
    Node[] arguments;
    Class[] profile;
    String methodName;
    String containsFieldName;

    public boolean equals(Object o) {
        if (!(o instanceof InvokeAnyNode)) {
            return false;
        }
        InvokeAnyNode node = (InvokeAnyNode)o;
        return InvokeAnyNode.equalObjects(node.target, this.target) && Arrays.equals(node.arguments, this.arguments) && Arrays.equals(node.profile, this.profile) && InvokeAnyNode.equalObjects(node.methodName, this.methodName) && InvokeAnyNode.equalObjects(node.containsFieldName, this.containsFieldName);
    }

    Class getType() {
        return Object.class;
    }

    String getFieldName() {
        if (this.target != null) {
            if (this.target.tag != 67) {
                String baseName = this.target.getFieldName();
                return baseName != null ? baseName + "." + this.methodName : null;
            }
            return this.methodName;
        }
        return this.containsFieldName != null ? this.containsFieldName + "." + this.methodName : this.methodName;
    }

    InvokeAnyNode(Node target, String name, Node[] arguments, String containsFieldName) {
        super(19, 102);
        this.target = target;
        this.containsFieldName = containsFieldName;
        this.methodName = name;
        this.arguments = arguments;
        this.profile = new Class[arguments.length];
    }

    Object evaluateObj(FilterIterator t) {
        Class<?> cls;
        Object obj = t.currObj;
        if (this.target != null && (obj = this.target.evaluateObj(t)) == null) {
            throw new JSQLNullPointerException(null, this.methodName);
        }
        Object[] parameters = null;
        int n = this.arguments.length;
        if (n > 0) {
            parameters = new Object[n];
            for (int i = 0; i < n; ++i) {
                Class type;
                Object value;
                Node arg = this.arguments[i];
                switch (arg.type) {
                    case 1: {
                        value = new Long(arg.evaluateInt(t));
                        type = Long.TYPE;
                        break;
                    }
                    case 2: {
                        value = new Double(arg.evaluateReal(t));
                        type = Double.TYPE;
                        break;
                    }
                    case 6: {
                        value = arg.evaluateStr(t);
                        type = String.class;
                        break;
                    }
                    case 0: {
                        value = new Boolean(arg.evaluateBool(t));
                        type = Boolean.TYPE;
                        break;
                    }
                    default: {
                        value = arg.evaluateObj(t);
                        if (value != null) {
                            type = value.getClass();
                            if (type.equals(Long.class) || type.equals(Integer.class) || type.equals(Byte.class) || type.equals(Character.class) || type.equals(Short.class)) {
                                type = Long.TYPE;
                                break;
                            }
                            if (type.equals(Float.class) || type.equals(Double.class)) {
                                type = Double.TYPE;
                                break;
                            }
                            if (!type.equals(Boolean.class)) break;
                            type = Boolean.TYPE;
                            break;
                        }
                        type = Object.class;
                    }
                }
                parameters[i] = value;
                this.profile[i] = type;
            }
        }
        try {
            Method m;
            if (this.target == null && t.containsElem != null && (m = QueryImpl.lookupMethod(t.containsElem.getClass(), this.methodName, this.profile)) != null) {
                return t.query.resolve(m.invoke(t.containsElem, parameters));
            }
            cls = obj.getClass();
            m = QueryImpl.lookupMethod(cls, this.methodName, this.profile);
            if (m != null) {
                return t.query.resolve(m.invoke(t.containsElem, parameters));
            }
        }
        catch (InvocationTargetException x) {
            x.printStackTrace();
            throw new IllegalAccessError();
        }
        catch (IllegalAccessException x) {
            x.printStackTrace();
            throw new IllegalAccessError();
        }
        throw new JSQLNoSuchFieldException(cls, this.methodName);
    }
}

