/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Array;
import org.garret.perst.impl.FilterIterator;
import org.garret.perst.impl.IndexNode;
import org.garret.perst.impl.IndexOutOfRangeError;
import org.garret.perst.impl.Node;

class GetAtNode
extends Node {
    Node left;
    Node right;

    public boolean equals(Object o) {
        return o instanceof GetAtNode && ((GetAtNode)o).left.equals(this.left) && ((GetAtNode)o).right.equals(this.right);
    }

    long evaluateInt(FilterIterator t) {
        Object arr = this.left.evaluateObj(t);
        long idx = this.right.evaluateInt(t);
        if (this.right.tag == 63) {
            try {
                if (idx >= (long)Array.getLength(arr)) {
                    throw new IndexOutOfRangeError(((IndexNode)this.right).loopId);
                }
            }
            catch (IllegalArgumentException x) {
                throw new Error("Argument is not array");
            }
        }
        int index = (int)idx;
        switch (this.tag) {
            case 53: {
                return ((byte[])arr)[index];
            }
            case 54: {
                return ((short[])arr)[index];
            }
            case 55: {
                return ((int[])arr)[index];
            }
            case 56: {
                return ((long[])arr)[index];
            }
            case 52: {
                return ((char[])arr)[index];
            }
            case 50: {
                return ((String)arr).charAt(index);
            }
        }
        throw new Error("Invalid tag " + this.tag);
    }

    double evaluateReal(FilterIterator t) {
        Object arr = this.left.evaluateObj(t);
        long index = this.right.evaluateInt(t);
        if (this.right.tag == 63) {
            try {
                if (index >= (long)Array.getLength(arr)) {
                    throw new IndexOutOfRangeError(((IndexNode)this.right).loopId);
                }
            }
            catch (IllegalArgumentException x) {
                throw new Error("Argument is not array");
            }
        }
        switch (this.tag) {
            case 57: {
                return ((float[])arr)[(int)index];
            }
            case 58: {
                return ((double[])arr)[(int)index];
            }
        }
        throw new Error("Invalid tag " + this.tag);
    }

    boolean evaluateBool(FilterIterator t) {
        boolean[] arr = (boolean[])this.left.evaluateObj(t);
        long index = this.right.evaluateInt(t);
        if (this.right.tag == 63) {
            try {
                if (index >= (long)arr.length) {
                    throw new IndexOutOfRangeError(((IndexNode)this.right).loopId);
                }
            }
            catch (IllegalArgumentException x) {
                throw new Error("Argument is not array");
            }
        }
        return arr[(int)index];
    }

    String evaluateStr(FilterIterator t) {
        String[] arr = (String[])this.left.evaluateObj(t);
        long index = this.right.evaluateInt(t);
        if (this.right.tag == 63) {
            try {
                if (index >= (long)arr.length) {
                    throw new IndexOutOfRangeError(((IndexNode)this.right).loopId);
                }
            }
            catch (IllegalArgumentException x) {
                throw new Error("Argument is not array");
            }
        }
        return arr[(int)index];
    }

    Object evaluateObj(FilterIterator t) {
        Object arr = this.left.evaluateObj(t);
        long index = this.right.evaluateInt(t);
        try {
            if (this.right.tag == 63 && index >= (long)Array.getLength(arr)) {
                throw new IndexOutOfRangeError(((IndexNode)this.right).loopId);
            }
            return Array.get(arr, (int)index);
        }
        catch (IllegalArgumentException x) {
            throw new Error("Argument is not array");
        }
    }

    GetAtNode(int type, int tag, Node base, Node index) {
        super(type, tag);
        this.left = base;
        this.right = index;
    }
}

