/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import java.util.Date;
import java.util.Iterator;
import org.garret.perst.Assert;
import org.garret.perst.Link;
import org.garret.perst.Persistent;
import org.garret.perst.PersistentResource;
import org.garret.perst.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionHistory<V extends Version>
extends PersistentResource {
    Link<V> versions;
    V current;

    public synchronized V getCurrent() {
        return this.current;
    }

    public synchronized void setCurrent(V version) {
        this.current = version;
        this.modify();
    }

    public synchronized V checkout() {
        Assert.that(((Version)this.current).isCheckedIn());
        return (V)((Version)this.current).newVersion();
    }

    public synchronized V getRoot() {
        return (V)((Version)this.versions.get(0));
    }

    public synchronized V getLatestBefore(Date timestamp) {
        int n;
        if (timestamp == null) {
            return (V)((Version)this.versions.get(this.versions.size() - 1));
        }
        int l = 0;
        int r = n = this.versions.size();
        long t = timestamp.getTime();
        while (l < r) {
            int m = l + r >> 1;
            if (((Version)this.versions.get(m)).getDate().getTime() < t) {
                l = m + 1;
                continue;
            }
            r = m;
        }
        return (V)(r > 0 ? (Version)this.versions.get(r - 1) : null);
    }

    public synchronized V getEarliestAfter(Date timestamp) {
        int n;
        if (timestamp == null) {
            return (V)((Version)this.versions.get(0));
        }
        int l = 0;
        int r = n = this.versions.size();
        long t = timestamp.getTime() + 1L;
        while (l < r) {
            int m = l + r >> 1;
            if (((Version)this.versions.get(m)).getDate().getTime() < t) {
                l = m + 1;
                continue;
            }
            r = m;
        }
        return (V)(r < n ? (Version)this.versions.get(r) : null);
    }

    public synchronized V getVersionByLabel(String label) {
        int i = this.versions.size();
        while (--i >= 0) {
            Version v = (Version)this.versions.get(i);
            if (!v.hasLabel(label)) continue;
            return (V)v;
        }
        return null;
    }

    public synchronized V getVersionById(String id) {
        int i = this.versions.size();
        while (--i >= 0) {
            Version v = (Version)this.versions.get(i);
            if (!v.getId().equals(id)) continue;
            return (V)v;
        }
        return null;
    }

    public synchronized Version[] getAllVersions() {
        return this.versions.toArray(new Version[this.versions.size()]);
    }

    public synchronized Iterator<V> iterator() {
        return this.versions.iterator();
    }

    public VersionHistory(V root) {
        this.versions = ((Persistent)root).getStorage().createLink(1);
        this.versions.add(root);
        this.current = root;
        ((Version)this.current).history = this;
    }
}

