/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.utmutils.swing.tabbedwindow;

import biz.netup.swing.JSideMenu;
import biz.netup.swing.JSideMenuGroup;
import biz.netup.swing.JSideMenuItem;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.shortcuts.Shortcuts;
import biz.netup.utmutils.control.trayicon.UTMTrayIcon;
import biz.netup.utmutils.swing.localization.ResourceBundleWrapper;
import biz.netup.utmutils.swing.tab.TabPanel;
import biz.netup.utmutils.swing.tabbedwindow.MainTabbedWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;

public abstract class TabbedWindow
extends JFrame {
    private JSplitPane splitPane;
    private JPanel leftPanel;
    private JScrollPane leftScrollPane;
    private JPanel rightPanel;
    private JPanel bottomPanel;
    protected JPanel mainPanel;
    private JSideMenuItem currentSMI = null;
    private Vector<TabPanel> menuVector;
    protected static final Logger log = Utils.getLogger();
    protected ResourceBundleWrapper resource = Utils.getResource();
    protected int id;
    private boolean opened = false;

    public TabbedWindow() {
        this(0);
    }

    public TabbedWindow(int n) {
        log.log(10, "Constructor for " + this.getWindowTitle());
        this.id = n;
        this.$$$setupUI$$$();
        URL uRL = this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/logo32.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.setIconImage(imageIcon.getImage());
        this.setSize(this.getWindowSize());
        this.leftScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setTitle(Utils.getResource().getString(this.getWindowTitle()));
        this.add(this.mainPanel);
        log.log(10, "Initializing " + this.getWindowTitle());
        this.init();
        log.log(10, "Initializing " + this.getWindowTitle() + " complete");
        if (this.getWindowMenuBar() != null) {
            this.setJMenuBar(this.getWindowMenuBar());
        }
        if (this.getBottomPanel() != null) {
            this.bottomPanel.add(this.getBottomPanel(), "Center");
        }
        log.log(10, "Seting tab panels for " + this.getWindowTitle());
        this.setTabPanels(this.getTabPanels());
        log.log(10, "Seting tab panels for " + this.getWindowTitle() + " complete");
    }

    protected abstract void init();

    protected Component getBottomPanel() {
        return null;
    }

    protected void setTabPanels(Vector<TabPanel> vector) {
        this.menuVector = vector;
        JSideMenu jSideMenu = new JSideMenu();
        LinkedHashMap<String, JSideMenuGroup> linkedHashMap = new LinkedHashMap<String, JSideMenuGroup>();
        for (final TabPanel tabPanel : this.menuVector) {
            JSideMenuGroup jSideMenuGroup;
            if (!tabPanel.isAllowedRefresh()) continue;
            if (linkedHashMap.containsKey(tabPanel.getGroupName())) {
                jSideMenuGroup = (JSideMenuGroup)linkedHashMap.get(tabPanel.getGroupName());
            } else {
                jSideMenuGroup = new JSideMenuGroup(this.resource.getString(tabPanel.getGroupName()));
                jSideMenu.add(jSideMenuGroup);
                linkedHashMap.put(tabPanel.getGroupName(), jSideMenuGroup);
            }
            final JSideMenuItem jSideMenuItem = new JSideMenuItem(this.resource.getString(tabPanel.getTabName()), tabPanel.getSmallIcon());
            tabPanel.setSideMenuItem(jSideMenuItem);
            jSideMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TabbedWindow.this.setTab(tabPanel, jSideMenuItem);
                }
            });
            jSideMenuGroup.add(jSideMenuItem);
            if (this.opened) continue;
            this.opened = true;
            this.setTab(tabPanel, jSideMenuItem);
        }
        log.log(10, "Seting shortcuts for " + this.getWindowTitle());
        this.setShortcuts();
        log.log(10, "Seting shortcuts for " + this.getWindowTitle() + " complete");
        this.leftScrollPane.setViewportView(jSideMenu);
        if (linkedHashMap.size() != 0) {
            ((JSideMenuGroup)linkedHashMap.values().toArray()[0]).setMinimized(false);
        }
    }

    public void setShortcuts() {
        for (TabPanel tabPanel : this.menuVector) {
            if (!tabPanel.isAllowedRefresh()) continue;
            if (Shortcuts.getShortcut(tabPanel.getTabType(), tabPanel.getTabName()) != ' ') {
                this.setShortcut(tabPanel, Shortcuts.getShortcut(tabPanel.getTabType(), tabPanel.getTabName()));
                continue;
            }
            this.removeShortcut(tabPanel);
        }
    }

    private void removeShortcut(TabPanel tabPanel) {
        this.mainPanel.getActionMap().remove(tabPanel.getTabName());
    }

    private void setShortcut(final TabPanel tabPanel, char c) {
        JComponent jComponent = (JComponent)this.getContentPane();
        InputMap inputMap = jComponent.getInputMap(1);
        ActionMap actionMap = jComponent.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("alt " + c), tabPanel.getTabName());
        actionMap.put(tabPanel.getTabName(), new AbstractAction(tabPanel.getTabName()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                tabPanel.getSideMenuItem().doClick();
            }
        });
    }

    public void setTab(TabPanel tabPanel, JSideMenuItem jSideMenuItem) {
        this.splitPane.setRightComponent(tabPanel.getPanel());
        if (this.currentSMI != null) {
            this.currentSMI.clearFont();
        }
        this.currentSMI = jSideMenuItem;
        ((JSideMenuGroup)jSideMenuItem.getParent()).setMinimized(false);
        jSideMenuItem.setBoldFont();
    }

    protected JMenuBar getWindowMenuBar() {
        return null;
    }

    protected abstract Dimension getWindowSize();

    protected abstract String getWindowTitle();

    protected abstract Vector<TabPanel> getTabPanels();

    @Override
    @Deprecated
    public void show() {
        if (this instanceof MainTabbedWindow) {
            UTMTrayIcon.getInstance().registerMain(this);
        } else {
            UTMTrayIcon.getInstance().addFrame(this);
        }
        super.show();
    }

    @Override
    @Deprecated
    public void hide() {
        if (this instanceof MainTabbedWindow) {
            UTMTrayIcon.getInstance().unregisterMain(this);
        } else {
            UTMTrayIcon.getInstance().removeFrame(this);
        }
        super.hide();
    }

    private void $$$setupUI$$$() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)jScrollPane, gridBagConstraints);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jScrollPane.setViewportView(jPanel);
        this.splitPane = new JSplitPane();
        this.splitPane.setDividerSize(0);
        this.splitPane.setEnabled(true);
        this.splitPane.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.splitPane, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.setPreferredSize(new Dimension(200, 320));
        this.splitPane.setLeftComponent(jPanel2);
        this.leftPanel = new JPanel();
        this.leftPanel.setLayout(new BorderLayout(0, 0));
        this.leftPanel.setMinimumSize(new Dimension(250, 5));
        this.leftPanel.setPreferredSize(new Dimension(250, 5));
        jPanel2.add((Component)this.leftPanel, "Center");
        this.leftScrollPane = new JScrollPane();
        this.leftScrollPane.setHorizontalScrollBarPolicy(31);
        this.leftPanel.add((Component)this.leftScrollPane, "Center");
        this.leftScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null));
        this.rightPanel = new JPanel();
        this.rightPanel.setLayout(new BorderLayout(0, 0));
        this.splitPane.setRightComponent(this.rightPanel);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)this.bottomPanel, gridBagConstraints);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

