/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.utmutils.swing.tab;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.logindialog.DialogSplash;
import biz.netup.swing.JSideMenuItem;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.permissions.Permission;
import biz.netup.utmutils.control.permissions.Permissions;
import biz.netup.utmutils.control.shortcuts.Shortcuts;
import biz.netup.utmutils.swing.localization.ResourceBundleWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public abstract class TabPanel {
    protected JPanel mainPanel;
    protected Logger log = Utils.getLogger();
    protected ResourceBundleWrapper resource = Utils.getResource();
    protected int[] refreshPermission;
    protected boolean init = false;
    public static final int NOT_DEFINE = 0;
    public static final int MAIN = 1;
    public static final int USER = 2;
    public static final int DEALER = 3;
    public static final int SERVICE = 4;
    public static final int REPORT = 5;
    protected Icon smallIcon = new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/about/about_24.png"));
    protected Icon bigIcon = new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/about/about.png"));
    private JSideMenuItem sideMenuItem;

    public abstract String getTabName();

    public abstract int getTabType();

    public void setSideMenuItem(JSideMenuItem jSideMenuItem) {
        this.sideMenuItem = jSideMenuItem;
    }

    public JSideMenuItem getSideMenuItem() {
        return this.sideMenuItem;
    }

    public TabPanel() {
        this.$$$setupUI$$$();
        this.log.log(10, "Constructor for " + this.getTabName());
        DialogSplash.setStatus(this.resource.getString("Initializing") + " " + this.getTabName());
        this.log.log(10, "Registering shortcut for " + this.getTabName());
        this.registerShortcut();
        this.log.log(10, "Registering shortcut for " + this.getTabName() + " complete");
    }

    protected void registerShortcut() {
        if (this.isAllowedRefresh()) {
            Shortcuts.addShortcut(this.getTabType(), this.getTabName(), this.getShortcut());
        }
    }

    public void refresh() {
        this.log.log(10, "Refresh " + this.getTabName());
        try {
            this.refreshTab();
        }
        catch (UrfaException urfaException) {
            this.log.error(this.resource.getString(this.getTabName()) + ": " + this.resource.getString("Cannot get data"), urfaException);
        }
        this.log.log(10, "Refresh " + this.getTabName() + " complete");
    }

    protected void applyPermissions() {
    }

    public abstract String getGroupName();

    public char getShortcut() {
        return ' ';
    }

    protected abstract void refreshTab() throws UrfaException;

    public boolean isAllowedRefresh() {
        return this.refreshPermission == null || UrfaManagerImpl.getInstance().isPermitted(this.refreshPermission) || !Utils.isAdmin();
    }

    public JComponent getPanel() {
        if (this.refreshPermission == null || UrfaManagerImpl.getInstance().isPermitted(this.refreshPermission) || !Utils.isAdmin()) {
            if (!this.init) {
                this.log.log(10, "Initializing " + this.getTabName());
                this.init();
                this.log.log(10, "Initializing " + this.getTabName() + " complete");
            }
            return this.mainPanel;
        }
        return new JLabel("");
    }

    protected void init() {
        this.mainPanel.add(this.getMainPanel(), "Center");
        this.refresh();
        this.init = true;
        this.applyPermissions();
    }

    protected abstract Component getMainPanel();

    public int[] getRefreshPermission() {
        return this.refreshPermission;
    }

    public void setRefreshPermission(int[] nArray) {
        this.refreshPermission = nArray;
        if (Permissions.getInstance().isAvailable(this.convert(nArray))) {
            Permissions.getInstance().addPerm(new Permission(this.getTabName(), this.getGroupName(), new Integer[0]), this.getTabType());
            Permissions.getInstance().addPerm(new Permission("Refresh", this.getTabName(), this.convert(nArray)), this.getTabType());
        }
    }

    public Icon getBigIcon() {
        return this.bigIcon;
    }

    public void setBigIcon(Icon icon) {
        this.bigIcon = icon;
    }

    public Icon getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(Icon icon) {
        this.smallIcon = icon;
    }

    public void setReadOnly() {
        TabPanel.setReadOnlyForComponent(this.getPanel());
    }

    private static void setReadOnlyForComponent(Component component) {
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).setEditable(false);
        } else if (!(component instanceof JLabel) && component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                TabPanel.setReadOnlyForComponent(component2);
            }
            component.setEnabled(false);
        }
    }

    public static void unsetReadOnlyForComponent(Component component) {
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).setEditable(true);
        } else if (!(component instanceof JLabel) && component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                TabPanel.unsetReadOnlyForComponent(component2);
            }
            component.setEnabled(true);
        }
    }

    public Integer[] convert(int[] nArray) {
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            integerArray[i] = nArray[i];
        }
        return integerArray;
    }

    public String getHelpTarget() {
        return "";
    }

    private void $$$setupUI$$$() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout(0, 0));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

