/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.utmutils.swing.iptextfield;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

public class IPTextField
extends JTextField {
    String oldValue = "0.0.0.0";
    KeyEvent lastKE;
    private boolean edit = false;
    boolean set = false;

    public IPTextField() {
        this("0.0.0.0");
    }

    public IPTextField(String string) {
        super(IPTextField.validateAnIpAddressWithRegularExpression(string) ? string : "0.0.0.0");
        this.oldValue = string;
        DefaultCaret defaultCaret = new DefaultCaret(){

            @Override
            public void paint(Graphics graphics) {
                char c;
                JTextComponent jTextComponent = this.getComponent();
                int n = this.getDot();
                Rectangle rectangle = null;
                try {
                    rectangle = jTextComponent.modelToView(n);
                    if (rectangle == null) {
                        return;
                    }
                    c = jTextComponent.getText(n, 1).charAt(0);
                }
                catch (BadLocationException badLocationException) {
                    return;
                }
                if (this.x != rectangle.x || this.y != rectangle.y) {
                    this.repaint();
                    this.x = rectangle.x;
                    this.y = rectangle.y;
                    this.height = rectangle.height;
                }
                graphics.setColor(jTextComponent.getCaretColor());
                graphics.setXORMode(jTextComponent.getBackground());
                this.width = graphics.getFontMetrics().charWidth(c);
                if (c == '\t' || c == '\n') {
                    this.width = graphics.getFontMetrics().charWidth(' ');
                }
                if (this.isVisible()) {
                    graphics.fillRect(rectangle.x, rectangle.y, this.width, rectangle.height);
                }
            }
        };
        defaultCaret.setBlinkRate(500);
        this.setCaret(defaultCaret);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (IPTextField.this.edit) {
                    return;
                }
                char c = keyEvent.getKeyChar();
                if (c == '.' || c == ' ') {
                    if (IPTextField.this.getText().substring(IPTextField.this.getCaretPosition()).contains(".")) {
                        IPTextField.this.setCaretPosition(IPTextField.this.getCaretPosition() + IPTextField.this.getText().substring(IPTextField.this.getCaretPosition()).indexOf(46) + 1);
                    } else {
                        IPTextField.this.setCaretPosition(IPTextField.this.getText().length() - 1);
                    }
                    keyEvent.consume();
                } else if (c == '\b') {
                    int n = IPTextField.this.getCaretPosition();
                    if (!IPTextField.validateAnIpAddressWithRegularExpression(IPTextField.this.getText())) {
                        int n2 = 0;
                        for (char c2 : IPTextField.this.getText().toCharArray()) {
                            if ('.' != c2) continue;
                            ++n2;
                        }
                        if (n2 == 3) {
                            IPTextField.this.setText(IPTextField.this.getText().substring(0, IPTextField.this.getCaretPosition()) + "0" + IPTextField.this.getText().substring(IPTextField.this.getCaretPosition()));
                        } else {
                            IPTextField.this.setText(IPTextField.this.getText().substring(0, IPTextField.this.getCaretPosition()) + "." + IPTextField.this.getText().substring(IPTextField.this.getCaretPosition()));
                        }
                    }
                    IPTextField.this.setCaretPosition(n);
                } else if (c == '\u007f') {
                    int n = IPTextField.this.getCaretPosition();
                    if (!IPTextField.validateAnIpAddressWithRegularExpression(IPTextField.this.getText())) {
                        int n3 = 0;
                        for (char c3 : IPTextField.this.getText().toCharArray()) {
                            if ('.' != c3) continue;
                            ++n3;
                        }
                        if (n3 == 3) {
                            IPTextField.this.setText(IPTextField.this.getText().substring(0, IPTextField.this.getCaretPosition()) + "0" + IPTextField.this.getText().substring(IPTextField.this.getCaretPosition()));
                        } else {
                            IPTextField.this.setText(IPTextField.this.getText().substring(0, IPTextField.this.getCaretPosition()) + "." + IPTextField.this.getText().substring(IPTextField.this.getCaretPosition()));
                        }
                    }
                    IPTextField.this.setCaretPosition(n);
                } else if (Character.isDigit(c)) {
                    if (IPTextField.this.getCaretPosition() == IPTextField.this.getText().length()) {
                        if (!IPTextField.validateAnIpAddressWithRegularExpression(IPTextField.this.getText().substring(0, IPTextField.this.getCaretPosition()) + c + IPTextField.this.getText().substring(IPTextField.this.getCaretPosition()))) {
                            keyEvent.consume();
                        }
                    } else if (IPTextField.this.getText().charAt(IPTextField.this.getCaretPosition()) == '.') {
                        if (!IPTextField.validateAnIpAddressWithRegularExpression(IPTextField.this.getText().substring(0, IPTextField.this.getCaretPosition()) + c + IPTextField.this.getText().substring(IPTextField.this.getCaretPosition()))) {
                            if (IPTextField.validateAnIpAddressWithRegularExpression(IPTextField.this.getText().substring(0, IPTextField.this.getCaretPosition() + 1) + c + IPTextField.this.getText().substring(IPTextField.this.getCaretPosition() + 2))) {
                                int n = IPTextField.this.getCaretPosition();
                                IPTextField.this.setText(IPTextField.this.getText().substring(0, IPTextField.this.getCaretPosition() + 1) + c + IPTextField.this.getText().substring(IPTextField.this.getCaretPosition() + 2));
                                IPTextField.this.setCaretPosition(n + 2);
                            }
                            keyEvent.consume();
                        }
                    } else if (!IPTextField.validateAnIpAddressWithRegularExpression(IPTextField.this.getText().substring(0, IPTextField.this.getCaretPosition()) + c + IPTextField.this.getText().substring(IPTextField.this.getCaretPosition() + 1))) {
                        keyEvent.consume();
                    } else {
                        int n = IPTextField.this.getCaretPosition();
                        IPTextField.this.setText(IPTextField.this.getText().substring(0, IPTextField.this.getCaretPosition()) + c + IPTextField.this.getText().substring(IPTextField.this.getCaretPosition() + 1));
                        IPTextField.this.setCaretPosition(n + 1);
                        keyEvent.consume();
                    }
                } else {
                    keyEvent.consume();
                }
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                IPTextField.this.parce();
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                IPTextField.this.parce();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                IPTextField.this.parce();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                IPTextField.this.parce();
            }
        });
    }

    void parce() {
        String string = this.getText();
        if (string.equals(this.oldValue) || this.set) {
            return;
        }
        if (IPTextField.validateAnIpAddressWithRegularExpression(string)) {
            this.oldValue = string;
        }
        if (!IPTextField.validateAnIpAddressWithRegularExpression(string)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IPTextField.this.set = true;
                    int n = IPTextField.this.getCaretPosition();
                    IPTextField.this.setText(IPTextField.this.oldValue);
                    IPTextField.this.setCaretPosition(n > IPTextField.this.oldValue.length() ? IPTextField.this.oldValue.length() : n);
                    IPTextField.this.set = false;
                }
            });
        }
    }

    @Override
    public void setText(String string) {
        if (this.edit) {
            return;
        }
        this.edit = true;
        if (IPTextField.validateAnIpAddressWithRegularExpression(string)) {
            this.oldValue = string;
        } else {
            string = this.oldValue;
        }
        super.setText(string);
        this.edit = false;
    }

    private static boolean validateAnIpAddressWithRegularExpression(String string) {
        Pattern pattern = Pattern.compile("\\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b");
        return pattern.matcher(string).matches();
    }
}

