/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.utmutils.swing.dialog;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.projects.utmadmin.functions.objects.AddressWithMask;
import biz.netup.swing.table.TablePanel;
import biz.netup.utmutils.control.Checkers;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.control.trayicon.UTMTrayIcon;
import biz.netup.utmutils.swing.dialog.DFModel;
import biz.netup.utmutils.swing.hs.BytesTextField;
import biz.netup.utmutils.swing.localization.ResourceBundleWrapper;
import biz.netup.utmutils.swing.tab.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public abstract class FrameModel
extends JFrame
implements DFModel {
    private JPanel contentPane;
    protected JButton buttonOK;
    protected JButton buttonCancel;
    private JPanel mainModelPanel;
    private JPanel surroundPanel;
    protected Logger log = Utils.getLogger();
    protected ResourceBundleWrapper resource = Utils.getResource();
    private boolean okPressed = false;
    protected Map<String, Object> item;
    private boolean addMode;
    protected TabPanel tp;
    protected boolean settingListeners = false;

    public FrameModel() {
    }

    @Override
    public void actionFinished(Map<String, Object> map) {
    }

    @Override
    public JPanel getContentPane() {
        return this.contentPane;
    }

    public JPanel getMainModelPanel() {
        return this.mainModelPanel;
    }

    public FrameModel(Map<String, Object> map) {
        this.$$$setupUI$$$();
        if (map == null) {
            this.addMode = true;
            this.item = new HashMap<String, Object>();
        } else {
            this.addMode = false;
            this.item = map;
        }
        this.mainModelPanel.add(this.getForm(), "Center");
        URL uRL = this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/logo32.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.setSize(this.getPreferredSize());
        this.setMinimumSize(this.getPreferredSize());
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getPreferredSize();
        this.setLocation((dimension.width - dimension2.width) / 2 - 200 < 0 ? 0 : (dimension.width - dimension2.width) / 2 - 200, (dimension.height - dimension2.height) / 2 - 200 < 0 ? 0 : (dimension.height - dimension2.height) / 2 - 200);
        this.setTitle(this.resource.getString(this.getItemName()));
        this.surroundPanel.setBorder(BorderFactory.createTitledBorder(this.resource.getString(this.getItemName()) + " " + this.resource.getString("details")));
        this.setIconImage(imageIcon.getImage());
        this.setContentPane(this.contentPane);
        if (this.isModalDialog()) {
            // empty if block
        }
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameModel.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameModel.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                FrameModel.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameModel.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    protected boolean isModalDialog() {
        return true;
    }

    protected void onOK() {
        try {
            this.log.log(10, "Dialog " + this.getItemName() + " OK pressed");
            this.checkInfo();
            this.save();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void onCancel() {
        this.log.log(10, "Dialog " + this.getItemName() + " Cancel pressed");
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            try {
                this.log.log(10, "Loading dialog " + this.getItemName() + "");
                this.loadInfo();
                this.settingListeners = true;
                this.checkInfo();
                this.settingListeners = false;
                this.pack();
                this.setVisible(true);
                this.log.log(10, "Loading dialog " + this.getItemName() + " complete");
            }
            catch (UrfaException urfaException) {
                this.log.error(this.resource.getString(this.getItemName()) + ": " + this.resource.getString("Cannot load details"), urfaException);
            }
        }
    }

    @Override
    public void save() {
        try {
            this.log.log(10, "Saving dialog " + this.getItemName() + "");
            this.saveInfo();
            this.okPressed = true;
            if (this.tp != null) {
                this.tp.refresh();
            }
            this.dispose();
            this.log.log(10, "Saving dialog " + this.getItemName() + " complete");
        }
        catch (UrfaException urfaException) {
            this.log.error(this.resource.getString(this.getItemName()) + ": " + this.resource.getString("Cannot save details"), urfaException);
        }
    }

    @Override
    public abstract Component getForm();

    @Override
    public abstract String getItemName();

    protected abstract void loadInfo() throws UrfaException;

    protected abstract void saveInfo() throws UrfaException;

    protected abstract void checkInfo() throws IllegalArgumentException;

    protected void checkName(final JTextComponent jTextComponent, String string) throws IllegalArgumentException {
        if (this.settingListeners) {
            jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                void check() {
                    if (jTextComponent.getText().isEmpty()) {
                        jTextComponent.setBackground(new Color(255, 204, 204));
                    } else {
                        jTextComponent.setBackground(Color.WHITE);
                    }
                }
            });
            if (jTextComponent.getText().isEmpty()) {
                jTextComponent.setBackground(new Color(255, 204, 204));
            } else {
                jTextComponent.setBackground(Color.WHITE);
            }
        } else {
            if (jTextComponent.getText().isEmpty()) {
                this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
                jTextComponent.setBackground(new Color(255, 204, 204));
                jTextComponent.requestFocus();
                throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
            }
            jTextComponent.setBackground(Color.WHITE);
        }
    }

    protected void checkName(final JComboBox jComboBox, String string) throws IllegalArgumentException {
        if (this.settingListeners) {
            jComboBox.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    if (jComboBox.getSelectedItem().toString().isEmpty()) {
                        jComboBox.setBackground(new Color(255, 204, 204));
                    } else {
                        jComboBox.setBackground(Color.WHITE);
                    }
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                }
            });
            if (jComboBox.getSelectedItem().toString().isEmpty()) {
                jComboBox.setBackground(new Color(255, 204, 204));
            } else {
                jComboBox.setBackground(Color.WHITE);
            }
        } else {
            if (jComboBox.getSelectedItem().toString().isEmpty()) {
                this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
                jComboBox.setBackground(new Color(255, 204, 204));
                jComboBox.requestFocus();
                throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
            }
            jComboBox.setBackground(Color.WHITE);
        }
    }

    protected void checkBytes(final BytesTextField bytesTextField, String string) throws IllegalArgumentException {
        if (this.settingListeners) {
            bytesTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                void check() {
                    try {
                        bytesTextField.getValue();
                        bytesTextField.setBackground(Color.WHITE);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        bytesTextField.setBackground(new Color(255, 204, 204));
                    }
                }
            });
            try {
                bytesTextField.getValue();
                bytesTextField.setBackground(Color.WHITE);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bytesTextField.setBackground(new Color(255, 204, 204));
            }
        } else {
            try {
                bytesTextField.getValue();
                bytesTextField.setBackground(Color.WHITE);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
                bytesTextField.setBackground(new Color(255, 204, 204));
                bytesTextField.requestFocus();
                throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
            }
        }
    }

    protected void checkLogin(final JTextComponent jTextComponent, String string) throws IllegalArgumentException {
        if (this.settingListeners) {
            jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                void check() {
                    if (!Checkers.loginOk(jTextComponent.getText())) {
                        jTextComponent.setBackground(new Color(255, 204, 204));
                    } else {
                        jTextComponent.setBackground(Color.WHITE);
                    }
                }
            });
            if (!Checkers.loginOk(jTextComponent.getText())) {
                jTextComponent.setBackground(new Color(255, 204, 204));
            } else {
                jTextComponent.setBackground(Color.WHITE);
            }
        } else {
            if (!Checkers.loginOk(jTextComponent.getText())) {
                this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
                jTextComponent.requestFocus();
                jTextComponent.setBackground(new Color(255, 204, 204));
                throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
            }
            jTextComponent.setBackground(Color.WHITE);
        }
    }

    protected void checkInt(final JTextComponent jTextComponent, String string) throws IllegalArgumentException {
        if (this.settingListeners) {
            jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                void check() {
                    try {
                        Integer.parseInt(jTextComponent.getText());
                        jTextComponent.setBackground(Color.WHITE);
                    }
                    catch (NumberFormatException numberFormatException) {
                        jTextComponent.setBackground(new Color(255, 204, 204));
                    }
                }
            });
            try {
                Integer.parseInt(jTextComponent.getText());
                jTextComponent.setBackground(Color.WHITE);
            }
            catch (NumberFormatException numberFormatException) {
                jTextComponent.setBackground(new Color(255, 204, 204));
            }
        } else {
            try {
                Integer.parseInt(jTextComponent.getText());
                jTextComponent.setBackground(Color.WHITE);
            }
            catch (NumberFormatException numberFormatException) {
                this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
                jTextComponent.requestFocus();
                jTextComponent.setBackground(new Color(255, 204, 204));
                throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
            }
        }
    }

    protected void checkLong(final JTextComponent jTextComponent, String string) throws IllegalArgumentException {
        if (this.settingListeners) {
            jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                void check() {
                    try {
                        Long.parseLong(jTextComponent.getText());
                        jTextComponent.setBackground(Color.WHITE);
                    }
                    catch (NumberFormatException numberFormatException) {
                        jTextComponent.setBackground(new Color(255, 204, 204));
                    }
                }
            });
            try {
                Long.parseLong(jTextComponent.getText());
                jTextComponent.setBackground(Color.WHITE);
            }
            catch (NumberFormatException numberFormatException) {
                jTextComponent.setBackground(new Color(255, 204, 204));
            }
        } else {
            try {
                Long.parseLong(jTextComponent.getText());
                jTextComponent.setBackground(Color.WHITE);
            }
            catch (NumberFormatException numberFormatException) {
                this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
                jTextComponent.requestFocus();
                jTextComponent.setBackground(new Color(255, 204, 204));
                throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
            }
        }
    }

    protected void checkIntOrEmpty(final JTextComponent jTextComponent, String string) throws IllegalArgumentException {
        if (this.settingListeners) {
            jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                void check() {
                    if (jTextComponent.getText().isEmpty()) {
                        jTextComponent.setBackground(Color.WHITE);
                        return;
                    }
                    try {
                        Integer.parseInt(jTextComponent.getText());
                        jTextComponent.setBackground(Color.WHITE);
                    }
                    catch (NumberFormatException numberFormatException) {
                        jTextComponent.setBackground(new Color(255, 204, 204));
                    }
                }
            });
            if (jTextComponent.getText().isEmpty()) {
                jTextComponent.setBackground(Color.WHITE);
                return;
            }
            try {
                Integer.parseInt(jTextComponent.getText());
                jTextComponent.setBackground(Color.WHITE);
            }
            catch (NumberFormatException numberFormatException) {
                jTextComponent.setBackground(new Color(255, 204, 204));
            }
        } else {
            if (jTextComponent.getText().isEmpty()) {
                jTextComponent.setBackground(Color.WHITE);
                return;
            }
            try {
                Integer.parseInt(jTextComponent.getText());
                jTextComponent.setBackground(Color.WHITE);
            }
            catch (NumberFormatException numberFormatException) {
                this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
                jTextComponent.requestFocus();
                jTextComponent.setBackground(new Color(255, 204, 204));
                throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
            }
        }
    }

    protected void checkDouble(final JTextComponent jTextComponent, String string) throws IllegalArgumentException {
        jTextComponent.setText(jTextComponent.getText().replace(',', '.'));
        if (this.settingListeners) {
            jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                void check() {
                    try {
                        Double.parseDouble(jTextComponent.getText());
                        jTextComponent.setBackground(Color.WHITE);
                    }
                    catch (NumberFormatException numberFormatException) {
                        jTextComponent.setBackground(new Color(255, 204, 204));
                    }
                }
            });
            try {
                Double.parseDouble(jTextComponent.getText());
                jTextComponent.setBackground(Color.WHITE);
            }
            catch (NumberFormatException numberFormatException) {
                jTextComponent.setBackground(new Color(255, 204, 204));
            }
        } else {
            try {
                Double.parseDouble(jTextComponent.getText());
                jTextComponent.setBackground(Color.WHITE);
            }
            catch (NumberFormatException numberFormatException) {
                this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
                jTextComponent.requestFocus();
                jTextComponent.setBackground(new Color(255, 204, 204));
                throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
            }
        }
    }

    protected void checkIP(final JTextComponent jTextComponent, String string) throws IllegalArgumentException {
        if (this.settingListeners) {
            jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                void check() {
                    if (jTextComponent.getText().isEmpty()) {
                        jTextComponent.setBackground(new Color(255, 204, 204));
                        return;
                    }
                    try {
                        Resolve.parse_ip(jTextComponent.getText());
                        jTextComponent.setBackground(Color.WHITE);
                    }
                    catch (Exception exception) {
                        jTextComponent.setBackground(new Color(255, 204, 204));
                    }
                }
            });
            if (jTextComponent.getText().isEmpty()) {
                jTextComponent.setBackground(new Color(255, 204, 204));
                return;
            }
            try {
                Resolve.parse_ip(jTextComponent.getText());
                jTextComponent.setBackground(Color.WHITE);
            }
            catch (Exception exception) {
                jTextComponent.setBackground(new Color(255, 204, 204));
            }
        } else {
            if (jTextComponent.getText().isEmpty()) {
                this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
                jTextComponent.requestFocus();
                jTextComponent.setBackground(new Color(255, 204, 204));
                throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
            }
            try {
                Resolve.parse_ip(jTextComponent.getText());
                jTextComponent.setBackground(Color.WHITE);
            }
            catch (Exception exception) {
                this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
                jTextComponent.requestFocus();
                jTextComponent.setBackground(new Color(255, 204, 204));
                throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
            }
        }
    }

    protected void checkIPAndType(final JTextComponent jTextComponent, String string, final Integer n) throws IllegalArgumentException {
        if (this.settingListeners) {
            jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                void check() {
                    if (jTextComponent.getText().isEmpty()) {
                        jTextComponent.setBackground(new Color(255, 204, 204));
                        return;
                    }
                    try {
                        AddressWithMask addressWithMask = Resolve.SubnetFromView(jTextComponent.getText());
                        if (n == 6) {
                            if (addressWithMask.address instanceof Inet4Address) {
                                jTextComponent.setBackground(new Color(255, 204, 204));
                                return;
                            }
                        } else if (n == 4 && addressWithMask.address instanceof Inet6Address) {
                            jTextComponent.setBackground(new Color(255, 204, 204));
                            return;
                        }
                        jTextComponent.setBackground(Color.WHITE);
                    }
                    catch (Exception exception) {
                        jTextComponent.setBackground(new Color(255, 204, 204));
                    }
                }
            });
            if (jTextComponent.getText().isEmpty()) {
                jTextComponent.setBackground(new Color(255, 204, 204));
                return;
            }
            try {
                AddressWithMask addressWithMask = Resolve.SubnetFromView(jTextComponent.getText());
                if (n == 6) {
                    if (addressWithMask.address instanceof Inet4Address) {
                        jTextComponent.setBackground(new Color(255, 204, 204));
                        return;
                    }
                } else if (n == 4 && addressWithMask.address instanceof Inet6Address) {
                    jTextComponent.setBackground(new Color(255, 204, 204));
                    return;
                }
                jTextComponent.setBackground(Color.WHITE);
            }
            catch (Exception exception) {
                jTextComponent.setBackground(new Color(255, 204, 204));
            }
        } else {
            if (jTextComponent.getText().isEmpty()) {
                this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
                jTextComponent.requestFocus();
                jTextComponent.setBackground(new Color(255, 204, 204));
                throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
            }
            try {
                AddressWithMask addressWithMask = Resolve.SubnetFromView(jTextComponent.getText());
                if (n == 6) {
                    if (addressWithMask.address instanceof Inet4Address) {
                        this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
                        jTextComponent.requestFocus();
                        jTextComponent.setBackground(new Color(255, 204, 204));
                        throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
                    }
                } else if (n == 4 && addressWithMask.address instanceof Inet6Address) {
                    this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
                    jTextComponent.requestFocus();
                    jTextComponent.setBackground(new Color(255, 204, 204));
                    throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
                }
                jTextComponent.setBackground(Color.WHITE);
            }
            catch (Exception exception) {
                this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
                jTextComponent.requestFocus();
                jTextComponent.setBackground(new Color(255, 204, 204));
                throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
            }
        }
    }

    protected void checkMask(final JTextComponent jTextComponent, String string) throws IllegalArgumentException {
        if (this.settingListeners) {
            jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                void check() {
                    if (jTextComponent.getText().isEmpty()) {
                        jTextComponent.setBackground(new Color(255, 204, 204));
                        return;
                    }
                    try {
                        Resolve.parse_mask(jTextComponent.getText());
                        jTextComponent.setBackground(Color.WHITE);
                    }
                    catch (Exception exception) {
                        jTextComponent.setBackground(new Color(255, 204, 204));
                    }
                }
            });
            if (jTextComponent.getText().isEmpty()) {
                jTextComponent.setBackground(new Color(255, 204, 204));
                return;
            }
            try {
                Resolve.parse_mask(jTextComponent.getText());
                jTextComponent.setBackground(Color.WHITE);
            }
            catch (Exception exception) {
                jTextComponent.setBackground(new Color(255, 204, 204));
            }
        } else {
            if (jTextComponent.getText().isEmpty()) {
                this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
                jTextComponent.requestFocus();
                jTextComponent.setBackground(new Color(255, 204, 204));
                throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
            }
            try {
                Resolve.parse_mask(jTextComponent.getText());
                jTextComponent.setBackground(Color.WHITE);
            }
            catch (Exception exception) {
                this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
                jTextComponent.requestFocus();
                jTextComponent.setBackground(new Color(255, 204, 204));
                throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
            }
        }
    }

    protected void checkIPOrEmpty(final JTextComponent jTextComponent, String string) throws IllegalArgumentException {
        if (this.settingListeners) {
            jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.check();
                }

                void check() {
                    if (jTextComponent.getText().isEmpty()) {
                        jTextComponent.setBackground(Color.WHITE);
                        return;
                    }
                    try {
                        Resolve.parse_ip(jTextComponent.getText());
                        jTextComponent.setBackground(Color.WHITE);
                    }
                    catch (Exception exception) {
                        jTextComponent.setBackground(new Color(255, 204, 204));
                    }
                }
            });
            if (jTextComponent.getText().isEmpty()) {
                jTextComponent.setBackground(Color.WHITE);
                return;
            }
            try {
                Resolve.parse_ip(jTextComponent.getText());
                jTextComponent.setBackground(Color.WHITE);
            }
            catch (Exception exception) {
                jTextComponent.setBackground(new Color(255, 204, 204));
            }
        } else {
            if (jTextComponent.getText().isEmpty()) {
                jTextComponent.setBackground(Color.WHITE);
                return;
            }
            try {
                Resolve.parse_ip(jTextComponent.getText());
                jTextComponent.setBackground(Color.WHITE);
            }
            catch (Exception exception) {
                this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
                jTextComponent.requestFocus();
                jTextComponent.setBackground(new Color(255, 204, 204));
                throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("field is invalid"));
            }
        }
    }

    protected void checkTablePanel(TablePanel tablePanel, String string) throws IllegalArgumentException {
        if (this.settingListeners) {
            return;
        }
        if (tablePanel.getTable().getRowCount() == 0) {
            this.log.log(1, this.resource.getString(string) + " " + this.resource.getString("table is empty"));
            throw new IllegalArgumentException(this.resource.getString(string) + " " + this.resource.getString("table is empty"));
        }
    }

    @Override
    public void setReadOnly() {
        FrameModel.setReadOnlyForComponent(this.mainModelPanel);
        this.buttonOK.setVisible(false);
        this.buttonCancel.setText(this.resource.getString("Close"));
    }

    private static void setReadOnlyForComponent(Component component) {
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).setEditable(false);
        } else if (!(component instanceof JLabel) && component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                FrameModel.setReadOnlyForComponent(component2);
            }
            component.setEnabled(false);
        }
    }

    @Override
    public void run(final TabPanel tabPanel) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    UTMTrayIcon.getInstance().addProcess(this, "Dialog - " + FrameModel.this.resource.getString(FrameModel.this.getItemName()));
                    FrameModel.this.tp = tabPanel;
                    FrameModel.this.loadInfo();
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            FrameModel.this.pack();
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                    FrameModel.this.settingListeners = true;
                    FrameModel.this.checkInfo();
                    FrameModel.this.settingListeners = false;
                    UTMTrayIcon.getInstance().removeProcess(this);
                    FrameModel.this.setVisible(true);
                }
                catch (UrfaException urfaException) {
                    UTMTrayIcon.getInstance().removeProcess(this);
                    FrameModel.this.log.error(FrameModel.this.resource.getString(FrameModel.this.getItemName()) + ": " + FrameModel.this.resource.getString("Cannot load details"), urfaException);
                }
            }
        };
        thread.start();
    }

    @Override
    public boolean isAddMode() {
        return this.addMode;
    }

    @Override
    public void setAddMode(boolean bl) {
        this.addMode = bl;
    }

    @Override
    public Map<String, Object> getItem() {
        return this.item;
    }

    @Override
    public void setItem(Map<String, Object> map) {
        this.item = map;
    }

    @Override
    public boolean isOkPressed() {
        return this.okPressed;
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel.add((Component)jPanel2, "East");
        this.buttonOK = new JButton();
        this.buttonOK.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/ok16.png")));
        this.buttonOK.setText("OK");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.buttonOK, gridBagConstraints);
        this.buttonCancel = new JButton();
        this.buttonCancel.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/cancel16.png")));
        this.$$$loadButtonText$$$(this.buttonCancel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Cancel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.buttonCancel, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        this.surroundPanel = new JPanel();
        this.surroundPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPane.add((Component)this.surroundPanel, gridBagConstraints);
        this.surroundPanel.setBorder(BorderFactory.createTitledBorder("test"));
        this.mainModelPanel = new JPanel();
        this.mainModelPanel.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.surroundPanel.add((Component)this.mainModelPanel, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.surroundPanel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.surroundPanel.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.contentPane.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.contentPane.add((Component)jPanel10, gridBagConstraints);
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

