/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.utmutils.swing.checkboxtree;

import biz.netup.utmutils.swing.checkboxtree.CheckTreeCellRenderer;
import biz.netup.utmutils.swing.checkboxtree.CheckTreeSelectionModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class CheckTreeManager
extends MouseAdapter
implements TreeSelectionListener {
    private CheckTreeSelectionModel selectionModel;
    private JTree tree = new JTree();
    int hotspot;

    public CheckTreeManager(JTree jTree) {
        this.hotspot = new JCheckBox().getPreferredSize().width;
        this.tree = jTree;
        this.selectionModel = new CheckTreeSelectionModel(jTree.getModel());
        jTree.setCellRenderer(new CheckTreeCellRenderer(jTree.getCellRenderer(), this.selectionModel));
        jTree.addMouseListener(this);
        this.selectionModel.addTreeSelectionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        if (mouseEvent.getX() > this.tree.getPathBounds((TreePath)treePath).x + this.hotspot) {
            return;
        }
        if (treePath.equals(this.tree.getPathForRow(0))) {
            return;
        }
        boolean bl = this.selectionModel.isPathSelected(treePath, true);
        this.selectionModel.removeTreeSelectionListener(this);
        try {
            if (bl) {
                this.selectionModel.removeSelectionPath(treePath);
            } else {
                this.selectionModel.addSelectionPath(treePath);
            }
        }
        finally {
            this.selectionModel.addTreeSelectionListener(this);
            this.tree.treeDidChange();
        }
    }

    public CheckTreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.tree.treeDidChange();
    }
}

