/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.utmutils.control.shortcuts;

import biz.netup.control.storage.impl.StorageImpl;
import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.projects.utmadmin.gui.mainframe.MainFrame;
import biz.netup.swing.table.ComboBoxCellEditor;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.shortcuts.Shortcuts;
import biz.netup.utmutils.swing.dialog.DialogModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ShortcutsDialog
extends DialogModel {
    private JTabbedPane tabbedPane1;
    private JPanel panel1;
    private TablePanelImpl mainTable;
    private TablePanelImpl userTable;
    private TablePanelImpl dealerTable;
    private TablePanelImpl serviceTable;
    private JPanel userPanel;
    private JPanel dealerPanel;
    private JPanel servicePanel;
    private JPanel mainWindowPanel;
    private Map<String, Character> lettersMap;

    public ShortcutsDialog() {
        this.$$$setupUI$$$();
    }

    public ShortcutsDialog(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.panel1;
    }

    @Override
    public String getItemName() {
        return "Shortcuts";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        HashMap<String, Object> hashMap;
        Map<String, Character> map = Shortcuts.shortcutsMap.get(1);
        if (map != null) {
            for (String string : map.keySet()) {
                hashMap = new HashMap<String, Object>();
                hashMap.put("tab", string);
                if (map.get(string).equals(Character.valueOf('-'))) {
                    hashMap.put("shortcut", "");
                } else if (map.get(string).equals(Character.valueOf(' '))) {
                    hashMap.put("shortcut", "");
                } else {
                    hashMap.put("shortcut", "[Alt] + " + map.get(string));
                }
                this.mainTable.getTableModel().addRow(hashMap);
            }
        }
        if ((map = Shortcuts.shortcutsMap.get(2)) != null) {
            for (String string : map.keySet()) {
                hashMap = new HashMap();
                hashMap.put("tab", string);
                if (map.get(string).equals(Character.valueOf('-'))) {
                    hashMap.put("shortcut", "");
                } else if (map.get(string).equals(Character.valueOf(' '))) {
                    hashMap.put("shortcut", "");
                } else {
                    hashMap.put("shortcut", "[Alt] + " + map.get(string));
                }
                this.userTable.getTableModel().addRow(hashMap);
            }
        }
        if ((map = Shortcuts.shortcutsMap.get(4)) != null) {
            for (String string : map.keySet()) {
                hashMap = new HashMap();
                hashMap.put("tab", string);
                if (map.get(string).equals(Character.valueOf('-'))) {
                    hashMap.put("shortcut", "");
                } else if (map.get(string).equals(Character.valueOf(' '))) {
                    hashMap.put("shortcut", "");
                } else {
                    hashMap.put("shortcut", "[Alt] + " + map.get(string));
                }
                this.serviceTable.getTableModel().addRow(hashMap);
            }
        }
        if ((map = Shortcuts.shortcutsMap.get(3)) != null) {
            for (String string : map.keySet()) {
                hashMap = new HashMap();
                hashMap.put("tab", string);
                if (map.get(string).equals(Character.valueOf('-'))) {
                    hashMap.put("shortcut", "");
                } else if (map.get(string).equals(Character.valueOf(' '))) {
                    hashMap.put("shortcut", "");
                } else {
                    hashMap.put("shortcut", "[Alt] + " + map.get(string));
                }
                this.dealerTable.getTableModel().addRow(hashMap);
            }
        }
        if (this.serviceTable.getTableModel().getRowCount() == 0) {
            this.tabbedPane1.removeTabAt(3);
        }
        if (this.dealerTable.getTableModel().getRowCount() == 0) {
            this.tabbedPane1.removeTabAt(2);
        }
        if (this.userTable.getTableModel().getRowCount() == 0) {
            this.tabbedPane1.removeTabAt(1);
        }
        if (this.mainTable.getTableModel().getRowCount() == 0) {
            this.tabbedPane1.removeTabAt(0);
        }
    }

    @Override
    protected void saveInfo() throws UrfaException {
        for (Map<String, Object> map : this.mainTable.getTableModel().data) {
            if (' ' != this.lettersMap.get(map.get("shortcut")).charValue()) {
                Shortcuts.writeShortcutToPerst("" + map.get("tab") + 1, this.lettersMap.get(map.get("shortcut")).charValue());
                Shortcuts.addShortcut(1, "" + map.get("tab"), this.lettersMap.get(map.get("shortcut")).charValue());
                continue;
            }
            Shortcuts.writeShortcutToPerst("" + map.get("tab") + 1, '-');
            Shortcuts.addShortcut(1, "" + map.get("tab"), '-');
        }
        for (Map<String, Object> map : this.userTable.getTableModel().data) {
            if (' ' != this.lettersMap.get(map.get("shortcut")).charValue()) {
                Shortcuts.writeShortcutToPerst("" + map.get("tab") + 2, this.lettersMap.get(map.get("shortcut")).charValue());
                Shortcuts.addShortcut(2, "" + map.get("tab"), this.lettersMap.get(map.get("shortcut")).charValue());
                continue;
            }
            Shortcuts.writeShortcutToPerst("" + map.get("tab") + 2, '-');
            Shortcuts.addShortcut(2, "" + map.get("tab"), '-');
        }
        for (Map<String, Object> map : this.dealerTable.getTableModel().data) {
            if (' ' != this.lettersMap.get(map.get("shortcut")).charValue()) {
                Shortcuts.writeShortcutToPerst("" + map.get("tab") + 3, this.lettersMap.get(map.get("shortcut")).charValue());
                Shortcuts.addShortcut(3, "" + map.get("tab"), this.lettersMap.get(map.get("shortcut")).charValue());
                continue;
            }
            Shortcuts.writeShortcutToPerst("" + map.get("tab") + 3, '-');
            Shortcuts.addShortcut(3, "" + map.get("tab"), '-');
        }
        for (Map<String, Object> map : this.serviceTable.getTableModel().data) {
            if (' ' != this.lettersMap.get(map.get("shortcut")).charValue()) {
                Shortcuts.writeShortcutToPerst("" + map.get("tab") + 4, this.lettersMap.get(map.get("shortcut")).charValue());
                Shortcuts.addShortcut(4, "" + map.get("tab"), this.lettersMap.get(map.get("shortcut")).charValue());
                continue;
            }
            Shortcuts.writeShortcutToPerst("" + map.get("tab") + 4, '-');
            Shortcuts.addShortcut(4, "" + map.get("tab"), '-');
        }
        StorageImpl.getInstance().commit();
        ((StorageImpl)StorageImpl.getInstance()).saveSettings();
        MainFrame.getInstance().setShortcuts();
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
    }

    private void createUIComponents() {
        this.createTable();
    }

    private void createTable() {
        this.mainTable = new TablePanelImpl(this.getClass().getName() + "_shortcuts_main", true);
        MapTableModel mapTableModel = this.mainTable.getTableModel();
        mapTableModel.addColumn("tab", "Tab name", true, false);
        mapTableModel.addColumn("shortcut", "Shortcut", true, true);
        this.mainTable.setEditable(true);
        this.mainTable.setAppendable(false);
        this.mainTable.applyTableSettings();
        Character[] characterArray = new Character[]{Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z')};
        this.lettersMap = new LinkedHashMap<String, Character>();
        this.lettersMap.put("", Character.valueOf(' '));
        for (Character c : characterArray) {
            this.lettersMap.put("[Alt] + " + c, c);
        }
        JComboBox jComboBox = new JComboBox();
        for (String string : this.lettersMap.keySet()) {
            jComboBox.addItem(string);
        }
        this.mainTable.setCellEditor("shortcut", new ComboBoxCellEditor(jComboBox, true, false));
        this.mainTable.getTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getColumn() == 1) {
                    ShortcutsDialog.this.checkDuplicateMain(tableModelEvent);
                }
            }
        });
        this.userTable = new TablePanelImpl(this.getClass().getName() + "_shortcuts_user", true);
        mapTableModel = this.userTable.getTableModel();
        mapTableModel.addColumn("tab", "Tab name", true, false);
        mapTableModel.addColumn("shortcut", "Shortcut", true, true);
        this.userTable.setEditable(true);
        this.userTable.setAppendable(false);
        this.userTable.applyTableSettings();
        this.userTable.setCellEditor("shortcut", new ComboBoxCellEditor(jComboBox, true, false));
        this.userTable.getTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getColumn() == 1) {
                    ShortcutsDialog.this.checkDuplicateUser(tableModelEvent);
                }
            }
        });
        this.dealerTable = new TablePanelImpl(this.getClass().getName() + "_shortcuts_dealer", true);
        mapTableModel = this.dealerTable.getTableModel();
        mapTableModel.addColumn("tab", "Tab name", true, false);
        mapTableModel.addColumn("shortcut", "Shortcut", true, true);
        this.dealerTable.setEditable(true);
        this.dealerTable.setAppendable(false);
        this.dealerTable.applyTableSettings();
        this.dealerTable.setCellEditor("shortcut", new ComboBoxCellEditor(jComboBox, true, false));
        this.dealerTable.getTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getColumn() == 1) {
                    ShortcutsDialog.this.checkDuplicateDealer(tableModelEvent);
                }
            }
        });
        this.serviceTable = new TablePanelImpl(this.getClass().getName() + "_shortcuts_service", true);
        mapTableModel = this.serviceTable.getTableModel();
        mapTableModel.addColumn("tab", "Tab name", true, false);
        mapTableModel.addColumn("shortcut", "Shortcut", true, true);
        this.serviceTable.setEditable(true);
        this.serviceTable.setAppendable(false);
        this.serviceTable.applyTableSettings();
        this.serviceTable.setCellEditor("shortcut", new ComboBoxCellEditor(jComboBox, true, false));
        this.serviceTable.getTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getColumn() == 1) {
                    ShortcutsDialog.this.checkDuplicateService(tableModelEvent);
                }
            }
        });
    }

    private void checkDuplicateMain(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getFirstRow() < 0) {
            return;
        }
        String string = this.mainTable.getTableModel().getRow(tableModelEvent.getFirstRow()).get("shortcut").toString();
        if ("".equals(string)) {
            return;
        }
        for (int i = 0; i < this.mainTable.getTableModel().getRowCount(); ++i) {
            if (i == tableModelEvent.getFirstRow() || !string.equals(this.mainTable.getTableModel().getRow(i).get("shortcut"))) continue;
            if (JOptionPane.showConfirmDialog(this, this.resource.getString("Shortcut") + " " + string + " " + this.resource.getString("Shortcut used") + " " + this.mainTable.getTableModel().getRow(i).get("tab") + ". " + this.resource.getString("Duplicate shortcut"), this.resource.getString("Warning"), 0) == 0) {
                this.mainTable.getTableModel().getRow(i).put("shortcut", "");
                continue;
            }
            this.mainTable.getTableModel().getRow(tableModelEvent.getFirstRow()).put("shortcut", "");
        }
    }

    private void checkDuplicateUser(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getFirstRow() < 0) {
            return;
        }
        String string = this.userTable.getTableModel().getRow(tableModelEvent.getFirstRow()).get("shortcut").toString();
        if ("".equals(string)) {
            return;
        }
        for (int i = 0; i < this.userTable.getTableModel().getRowCount(); ++i) {
            if (i == tableModelEvent.getFirstRow() || !string.equals(this.userTable.getTableModel().getRow(i).get("shortcut"))) continue;
            if (JOptionPane.showConfirmDialog(this, this.resource.getString("Shortcut") + " " + string + " " + this.resource.getString("Shortcut used") + " " + this.userTable.getTableModel().getRow(i).get("tab") + ". " + this.resource.getString("Duplicate shortcut"), this.resource.getString("Warning"), 0) == 0) {
                this.userTable.getTableModel().getRow(i).put("shortcut", "");
                continue;
            }
            this.userTable.getTableModel().getRow(tableModelEvent.getFirstRow()).put("shortcut", "");
        }
    }

    private void checkDuplicateDealer(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getFirstRow() < 0) {
            return;
        }
        String string = this.dealerTable.getTableModel().getRow(tableModelEvent.getFirstRow()).get("shortcut").toString();
        if ("".equals(string)) {
            return;
        }
        for (int i = 0; i < this.dealerTable.getTableModel().getRowCount(); ++i) {
            if (i == tableModelEvent.getFirstRow() || !string.equals(this.dealerTable.getTableModel().getRow(i).get("shortcut"))) continue;
            if (JOptionPane.showConfirmDialog(this, this.resource.getString("Shortcut") + " " + string + " " + this.resource.getString("Shortcut used") + " " + this.dealerTable.getTableModel().getRow(i).get("tab") + ". " + this.resource.getString("Duplicate shortcut"), this.resource.getString("Warning"), 0) == 0) {
                this.dealerTable.getTableModel().getRow(i).put("shortcut", "");
                continue;
            }
            this.dealerTable.getTableModel().getRow(tableModelEvent.getFirstRow()).put("shortcut", "");
        }
    }

    private void checkDuplicateService(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getFirstRow() < 0) {
            return;
        }
        String string = this.serviceTable.getTableModel().getRow(tableModelEvent.getFirstRow()).get("shortcut").toString();
        if ("".equals(string)) {
            return;
        }
        for (int i = 0; i < this.serviceTable.getTableModel().getRowCount(); ++i) {
            if (i == tableModelEvent.getFirstRow() || !string.equals(this.serviceTable.getTableModel().getRow(i).get("shortcut"))) continue;
            if (JOptionPane.showConfirmDialog(this, this.resource.getString("Shortcut") + " " + string + " " + this.resource.getString("Shortcut used") + " " + this.serviceTable.getTableModel().getRow(i).get("tab") + ". " + this.resource.getString("Duplicate shortcut"), this.resource.getString("Warning"), 0) == 0) {
                this.serviceTable.getTableModel().getRow(i).put("shortcut", "");
                continue;
            }
            this.serviceTable.getTableModel().getRow(tableModelEvent.getFirstRow()).put("shortcut", "");
        }
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.panel1 = new JPanel();
        this.panel1.setLayout(new BorderLayout(0, 0));
        this.panel1.setMinimumSize(new Dimension(350, 400));
        this.panel1.setPreferredSize(new Dimension(350, 400));
        this.tabbedPane1 = new JTabbedPane();
        this.tabbedPane1.setEnabled(true);
        this.panel1.add((Component)this.tabbedPane1, "Center");
        this.mainWindowPanel = new JPanel();
        this.mainWindowPanel.setLayout(new BorderLayout(0, 0));
        this.tabbedPane1.addTab(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Main window"), this.mainWindowPanel);
        this.mainWindowPanel.add((Component)this.mainTable, "Center");
        this.userPanel = new JPanel();
        this.userPanel.setLayout(new BorderLayout(0, 0));
        this.tabbedPane1.addTab(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("User"), this.userPanel);
        this.userPanel.add((Component)this.userTable, "Center");
        this.dealerPanel = new JPanel();
        this.dealerPanel.setLayout(new BorderLayout(0, 0));
        this.tabbedPane1.addTab(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Dealer"), this.dealerPanel);
        this.dealerPanel.add((Component)this.dealerTable, "Center");
        this.servicePanel = new JPanel();
        this.servicePanel.setLayout(new BorderLayout(0, 0));
        this.tabbedPane1.addTab(ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Service"), this.servicePanel);
        this.servicePanel.add((Component)this.serviceTable, "Center");
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.panel1;
    }
}

