/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.utmutils.control;

import biz.netup.utmutils.control.Data;
import biz.netup.utmutils.control.DataBlock;
import java.util.Vector;
import java.util.regex.Matcher;

public class InformationVolumeParser {
    private static Vector<Data> blocks = null;

    private static void initBlocks() {
        if (blocks != null) {
            return;
        }
        DataBlock dataBlock = new DataBlock("(b|B)", 0);
        DataBlock dataBlock2 = new DataBlock("(kb|Kb|KB|K|k)", 1);
        DataBlock dataBlock3 = new DataBlock("(mb|Mb|MB|M|m)", 2);
        DataBlock dataBlock4 = new DataBlock("(gb|Gb|GB|G|g)", 3);
        blocks = new Vector();
        blocks.add(new Data(dataBlock));
        blocks.add(new Data(dataBlock2));
        blocks.add(new Data(dataBlock2, dataBlock));
        blocks.add(new Data(dataBlock3));
        blocks.add(new Data(dataBlock3, dataBlock));
        blocks.add(new Data(dataBlock3, dataBlock2));
        blocks.add(new Data(dataBlock3, dataBlock2, dataBlock));
        blocks.add(new Data(dataBlock4));
        blocks.add(new Data(dataBlock4, dataBlock));
        blocks.add(new Data(dataBlock4, dataBlock2));
        blocks.add(new Data(dataBlock4, dataBlock2, dataBlock));
        blocks.add(new Data(dataBlock4, dataBlock3));
        blocks.add(new Data(dataBlock4, dataBlock3, dataBlock));
        blocks.add(new Data(dataBlock4, dataBlock3, dataBlock2));
        blocks.add(new Data(dataBlock4, dataBlock3, dataBlock2, dataBlock));
    }

    public ParsingResult parse(String string, int n) {
        InformationVolumeParser.initBlocks();
        ParsingResult parsingResult = new ParsingResult();
        parsingResult.stringVal = string;
        try {
            parsingResult.bytesVal = Long.parseLong(string);
            parsingResult.isSuccess = true;
            return parsingResult;
        }
        catch (NumberFormatException numberFormatException) {
            int n2;
            for (n2 = 0; n2 < blocks.size(); ++n2) {
                Data data = blocks.get(n2);
                Matcher matcher = data.regexp.matcher(string);
                if (!matcher.matches()) continue;
                DataBlock[] dataBlockArray = data.blocks;
                for (int i = 0; i < dataBlockArray.length; ++i) {
                    String string2 = matcher.group(i * 2 + 1);
                    int n3 = Integer.parseInt(string2);
                    parsingResult.bytesVal = (long)((double)parsingResult.bytesVal + (double)n3 * Math.pow(n, dataBlockArray[i].kbFactor));
                }
                break;
            }
            parsingResult.stringVal = string;
            parsingResult.isSuccess = n2 != blocks.size();
            return parsingResult;
        }
    }

    public ParsingResult parse(long l, int n) {
        boolean bl;
        ParsingResult parsingResult = new ParsingResult();
        parsingResult.stringVal = "";
        parsingResult.bytesVal = l;
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        int n2 = n * n * n;
        int n3 = n * n;
        long l2 = l;
        if (l2 == 0L) {
            parsingResult.isSuccess = false;
            return parsingResult;
        }
        long l3 = l2 / (long)n2;
        long l4 = l2 % (long)n2 / (long)n3;
        long l5 = l2 % (long)n3 / (long)n;
        long l6 = l2 % (long)n;
        if (bl) {
            parsingResult.stringVal = parsingResult.stringVal + "-";
        }
        if (l3 != 0L) {
            parsingResult.stringVal = parsingResult.stringVal + l3 + "G ";
        }
        if (l4 != 0L) {
            parsingResult.stringVal = parsingResult.stringVal + l4 + "M ";
        }
        if (l5 != 0L) {
            parsingResult.stringVal = parsingResult.stringVal + l5 + "K ";
        }
        if (l6 != 0L) {
            parsingResult.stringVal = parsingResult.stringVal + l6 + "B";
        }
        parsingResult.stringVal = parsingResult.stringVal.trim();
        parsingResult.isSuccess = true;
        return parsingResult;
    }

    public static class ParsingResult {
        public boolean isSuccess;
        public long bytesVal;
        public String stringVal;
    }
}

