/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.table;

import biz.netup.utmutils.control.Utils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class MapTableModel
extends AbstractTableModel {
    public static final int UNORDERED = 0;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    private Vector<String> columns = new Vector();
    private Vector<String> visibleColumns = new Vector();
    private TreeMap<String, String> columnNames = new TreeMap();
    private TreeMap<String, Boolean> columnEditable = new TreeMap();
    private Map<String, Class<? extends Object>> columnClasses = new TreeMap<String, Class<? extends Object>>();
    public Vector<Map<String, Object>> data = new Vector();
    protected Map<String, Object>[] sortedData = null;
    protected int sortedColumn = -1;
    protected int sortOrder = 0;
    private Map<String, Object> summaryData = new HashMap<String, Object>();
    public Vector<String> summaryColumns = new Vector();
    public String summaryTitleColumn = "";
    public boolean isEditable = false;
    TableRowFilter filter = null;

    public Vector<String> getVisibleColumns() {
        return this.visibleColumns;
    }

    public int getSortedColumn() {
        return this.sortedColumn;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public Class<? extends Object> getColumnClass(int n) {
        String string = this.visibleColumns.get(n);
        return this.getColumnClass(string);
    }

    public Class<? extends Object> getColumnClass(String string) {
        Class<? extends Object> clazz = this.columnClasses.get(string);
        if (clazz == null) {
            clazz = Object.class;
        }
        return clazz;
    }

    public Map<String, Object> getSummary() {
        if (this.summaryColumns.size() == 0) {
            return this.summaryData;
        }
        if (this.summaryData.size() != 0) {
            return this.summaryData;
        }
        GenerateTotal generateTotal = new GenerateTotal();
        this.summaryData = generateTotal.getSummary();
        return this.summaryData;
    }

    public void setColumnClass(String string, Class<? extends Object> clazz) {
        this.columnClasses.put(string, clazz);
    }

    @Override
    public int getColumnCount() {
        return this.visibleColumns.size();
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames.get(this.visibleColumns.get(n));
    }

    public String getColumnId(int n) {
        return this.visibleColumns.get(n);
    }

    public int getColumnIndex(String string) {
        for (int i = 0; i < this.visibleColumns.size(); ++i) {
            if (!this.visibleColumns.get(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    public String getColumnId(String string) {
        for (String string2 : this.columnNames.keySet()) {
            if (!this.columnNames.get(string2).equals(string)) continue;
            return string2;
        }
        return "";
    }

    @Override
    public int getRowCount() {
        if (null == this.sortedData) {
            this.setColumnSortOrder(this.sortedColumn, this.sortOrder);
        }
        return this.sortedData.length + 1;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n == this.sortedData.length) {
            return "";
        }
        String string = this.visibleColumns.get(n2);
        Map<String, Object> map = this.getRow(n);
        return map == null ? null : map.get(string);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        Map<String, Object> map = this.getRow(n);
        if (null != map && map.containsKey("X-EDITABLE")) {
            Map map2 = (Map)map.get("X-EDITABLE");
            if (map2.containsKey(this.visibleColumns.get(n2))) {
                return this.isEditable && (Boolean)map2.get(this.visibleColumns.get(n2)) != false;
            }
            if (map2.containsKey("X-DEFAULT")) {
                return this.isEditable && (Boolean)map2.get("X-DEFAULT") != false;
            }
        }
        return this.isEditable && this.columnEditable.get(this.visibleColumns.get(n2)) != false;
    }

    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        String string = this.visibleColumns.get(n2);
        Map<String, Object> map = this.getRow(n);
        if (map == null) {
            map = new TreeMap<String, Object>();
            map.put(string, object);
            this.addRow(map);
        } else {
            Object object2 = map.get(string);
            if (object != object2 || null != object && !object.equals(object2)) {
                map.put(string, object);
                this.fireTableCellUpdated(n, n2);
            }
        }
    }

    public void addColumn(String string, String string2, boolean bl, boolean bl2) {
        this.columns.add(string);
        try {
            string2 = Utils.getResource().getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.columnNames.put(string, string2);
        this.columnEditable.put(string, bl2);
        if (bl) {
            this.visibleColumns.add(string);
            this.fireTableStructureChanged();
        }
    }

    public void setEditable(String string, boolean bl) {
        this.columnEditable.put(string, bl);
    }

    public void setVisible(String string, boolean bl) {
        if (bl) {
            this.visibleColumns.add(string);
            this.fireTableStructureChanged();
        }
    }

    public void removeColumn(String string) {
        try {
            this.columns.remove(string);
            this.columnNames.remove(string);
            this.columnEditable.remove(string);
            this.visibleColumns.remove(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fireTableStructureChanged();
    }

    public void setVisibleColumns(String[] stringArray) {
        this.visibleColumns.removeAllElements();
        for (String string : stringArray) {
            if (!this.columns.contains(string)) continue;
            this.visibleColumns.add(string);
        }
        this.fireTableStructureChanged();
    }

    public void setColumnVisible(String string, boolean bl) {
        if (bl) {
            if (!this.visibleColumns.contains(string)) {
                this.visibleColumns.add(string);
                this.fireTableStructureChanged();
            }
        } else if (this.visibleColumns.contains(string)) {
            this.visibleColumns.remove(string);
            this.fireTableStructureChanged();
        }
    }

    public boolean isColumnVisible(String string) {
        return this.visibleColumns.contains(string);
    }

    public Map<String, String> getAllColumns() {
        return (Map)this.columnNames.clone();
    }

    public synchronized void addRow(Map<String, Object> map) {
        this.summaryData.clear();
        this.data.add(map);
        if (this.sortedData == null) {
            this.setColumnSortOrder(this.sortedColumn, this.sortOrder);
            return;
        }
        if (null == this.filter || this.filter.isRowShown(map)) {
            Map[] mapArray = new Map[this.sortedData.length + 1];
            for (int i = 0; i < this.sortedData.length; ++i) {
                mapArray[i] = this.sortedData[i];
            }
            mapArray[i] = map;
            this.sortedData = mapArray;
            int n = this.sortedData.length;
            this.sortedColumn = -1;
            this.sortOrder = 0;
            this.fireTableRowsInserted(n - 1, n - 1);
        }
    }

    public synchronized void removeAllRows() {
        int n = this.data.size();
        this.sortedData = null;
        this.data.clear();
        this.fireTableRowsDeleted(0, n > 0 ? n - 1 : 0);
    }

    public synchronized void removeRow(Map<String, Object> map) {
        this.data.remove(map);
        this.setColumnSortOrder(this.sortedColumn, this.sortOrder);
    }

    public Map<String, Object> getRow(int n) {
        if (this.sortedData == null) {
            this.setColumnSortOrder(this.sortedColumn, this.sortOrder);
        }
        if (this.sortedData != null && 0 <= n && n < this.sortedData.length) {
            return this.sortedData[n];
        }
        return null;
    }

    public int getColumnSortOrder(int n) {
        return n == this.sortedColumn ? this.sortOrder : 0;
    }

    public void setFilter(TableRowFilter tableRowFilter) {
        this.summaryData.clear();
        this.filter = tableRowFilter;
        this.setColumnSortOrder(this.sortedColumn, this.sortOrder);
    }

    public TableRowFilter getFilter() {
        return this.filter;
    }

    public void setColumnSortOrder(int n, int n2) {
        this.setColumnSortOrder(n, n < 0 ? "" : this.visibleColumns.get(n), n2);
    }

    public void setColumnSortOrder(String string, int n) {
        this.setColumnSortOrder(-1, string, n);
    }

    private void setColumnSortOrder(int n, String string, int n2) {
        int n3;
        int n4 = n3 = null == this.sortedData ? 1 : this.sortedData.length;
        if (null == this.filter) {
            this.sortedData = new Map[this.data.size()];
            for (int i = 0; i < this.data.size(); ++i) {
                this.sortedData[i] = this.data.get(i);
            }
        } else {
            Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
            for (Map<String, Object> map : this.data) {
                if (!this.filter.isRowShown(map)) continue;
                vector.add(map);
            }
            this.sortedData = new Map[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                this.sortedData[i] = (Map)vector.get(i);
            }
        }
        if (n2 == 1 || n2 == 2) {
            Arrays.sort(this.sortedData, new RowComparator(string, n2));
            this.sortedColumn = n;
            this.sortOrder = n2;
        } else {
            this.sortedColumn = n;
            this.sortOrder = 0;
        }
        if (n3 > 0) {
            this.fireTableRowsDeleted(0, n3 - 1);
        }
        this.fireTableRowsInserted(0, 0 == this.sortedData.length ? 0 : this.sortedData.length - 1);
    }

    protected class GenerateTotal {
        GenerateTotal() {
        }

        private void processRow(Map<String, Object> map, Map<String, Object> map2) {
            for (String string : MapTableModel.this.summaryColumns) {
                Object object = map2.get(string);
                Object object2 = map.get(string);
                if (null == object) continue;
                if (object instanceof Integer) {
                    if (object2 == null) {
                        map.put(string, new Integer((Integer)object));
                        continue;
                    }
                    map.put(string, new Integer((Integer)object2 + (Integer)object));
                    continue;
                }
                if (object instanceof Long) {
                    if (object2 == null) {
                        map.put(string, new Long((Long)object));
                        continue;
                    }
                    map.put(string, new Long((Long)object2 + (Long)object));
                    continue;
                }
                if (!(object instanceof Double)) continue;
                if (object2 == null) {
                    map.put(string, new Double((Double)object));
                    continue;
                }
                map.put(string, new Double((Double)object2 + (Double)object));
            }
        }

        public Map<String, Object> getSummary() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (!"".equals(MapTableModel.this.summaryTitleColumn)) {
                String string = ResourceBundle.getBundle(MapTableModel.class.getName()).getString("Total");
                hashMap.put(MapTableModel.this.summaryTitleColumn, "<HTML><B>" + string + "</B></HTML>");
            }
            for (int i = 0; i < MapTableModel.this.data.size(); ++i) {
                Map<String, Object> map = MapTableModel.this.getRow(i);
                this.processRow(hashMap, map);
            }
            return hashMap;
        }
    }

    public static interface TableRowFilter {
        public boolean isRowShown(Map<String, Object> var1);
    }

    private class RowComparator
    implements Comparator<Map<String, Object>> {
        private String column;
        private int order;

        public RowComparator(String string, int n) {
            this.column = string;
            this.order = n;
        }

        @Override
        public int compare(Map<String, Object> map, Map<String, Object> map2) {
            if ("NO_SORT".equals(map.get("X-SORT"))) {
                return 0;
            }
            if ("NO_SORT".equals(map2.get("X-SORT"))) {
                return 0;
            }
            Comparable comparable = (Comparable)map.get(this.column);
            Comparable comparable2 = (Comparable)map2.get(this.column);
            if (comparable == null && comparable2 == null) {
                return 0;
            }
            if (comparable == null) {
                return this.order == 2 ? 1 : -1;
            }
            if (comparable2 == null) {
                return this.order == 2 ? -1 : 1;
            }
            return this.order == 2 ? comparable2.compareTo(comparable) : comparable.compareTo(comparable2);
        }
    }
}

