/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.table;

import biz.netup.swing.AutoCompletion;
import biz.netup.swing.JEntityComboBox;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ComboBoxCellEditor
extends DefaultCellEditor {
    private JComboBox cb;

    public ComboBoxCellEditor(JComboBox jComboBox, boolean bl, boolean bl2) {
        super(jComboBox);
        this.cb = jComboBox;
        this.clickCountToStart = 2;
        this.cb.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                ComboBoxCellEditor.this.cb.repaint();
            }
        });
        Component component = this.cb.getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            ActionListener[] actionListenerArray = (ActionListener[])component;
            actionListenerArray.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (10 == keyEvent.getKeyCode()) {
                        ComboBoxCellEditor.this.stopCellEditing();
                    }
                }
            });
        }
        this.cb.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (focusEvent.getOppositeComponent() != ComboBoxCellEditor.this.cb.getEditor().getEditorComponent()) {
                    ComboBoxCellEditor.this.stopCellEditing();
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (ComboBoxCellEditor.this.cb.isEditable()) {
                    ComboBoxCellEditor.this.cb.getEditor().getEditorComponent().requestFocus();
                }
            }
        });
        this.cb.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (focusEvent.getOppositeComponent() != ComboBoxCellEditor.this.cb) {
                    ComboBoxCellEditor.this.stopCellEditing();
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                try {
                    ComboBoxCellEditor.this.cb.showPopup();
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    // empty catch block
                }
            }
        });
        this.cb.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (27 == keyEvent.getKeyCode()) {
                    keyEvent.consume();
                    ComboBoxCellEditor.this.cancelCellEditing();
                }
            }
        });
        this.cb.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                ComboBoxCellEditor.this.stopCellEditing();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object object) {
                ComboBoxCellEditor.this.setValue(ComboBoxCellEditor.this, object);
            }

            @Override
            public Object getCellEditorValue() {
                return ComboBoxCellEditor.this.getValue(ComboBoxCellEditor.this);
            }

            @Override
            public boolean shouldSelectCell(EventObject eventObject) {
                if (eventObject instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    return mouseEvent.getID() != 506;
                }
                return true;
            }

            @Override
            public boolean stopCellEditing() {
                if (ComboBoxCellEditor.this.cb.isEditable()) {
                    ComboBoxCellEditor.this.cb.actionPerformed(new ActionEvent(ComboBoxCellEditor.this, 0, ""));
                }
                return super.stopCellEditing();
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!ComboBoxCellEditor.this.cb.isEditable()) {
                    this.stopCellEditing();
                }
            }
        };
        for (ActionListener actionListener : this.cb.getActionListeners()) {
            this.cb.removeActionListener(actionListener);
        }
        this.cb.addActionListener(this.delegate);
        if (bl) {
            this.cb.putClientProperty("JComboBox.isTableCellEditor", Boolean.FALSE);
        } else {
            this.cb.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        }
        if (bl) {
            AutoCompletion.enable(this.cb, bl2);
        }
    }

    public JComboBox getComboBox() {
        return this.cb;
    }

    public void setValue(ComboBoxCellEditor comboBoxCellEditor, Object object) {
        comboBoxCellEditor.getComboBox().setSelectedItem(object);
    }

    public Object getValue(ComboBoxCellEditor comboBoxCellEditor) {
        if (comboBoxCellEditor.getComboBox() instanceof JEntityComboBox) {
            return ((JEntityComboBox)comboBoxCellEditor.getComboBox()).getEntity();
        }
        return comboBoxCellEditor.getComboBox().getSelectedItem();
    }
}

