/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.plaf.looks.windows;

import biz.netup.swing.plaf.looks.BorderStyle;
import biz.netup.swing.plaf.looks.HeaderStyle;
import biz.netup.swing.plaf.looks.windows.WindowsBorders;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.swing.plaf.metal.MetalToolBarUI;

public final class WindowsToolBarUI
extends MetalToolBarUI {
    private PropertyChangeListener listener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsToolBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.installSpecialBorder();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.listener = this.createBorderStyleListener();
        this.toolBar.addPropertyChangeListener(this.listener);
    }

    @Override
    protected void uninstallListeners() {
        this.toolBar.removePropertyChangeListener(this.listener);
        super.uninstallListeners();
    }

    private PropertyChangeListener createBorderStyleListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("jgoodies.headerStyle") || string.equals("jgoodies.windows.borderStyle")) {
                    WindowsToolBarUI.this.installSpecialBorder();
                }
            }
        };
    }

    private void installSpecialBorder() {
        String string;
        BorderStyle borderStyle = BorderStyle.from(this.toolBar, "jgoodies.windows.borderStyle");
        if (borderStyle == BorderStyle.EMPTY) {
            string = "emptyBorder";
        } else if (borderStyle == BorderStyle.SEPARATOR) {
            string = "separatorBorder";
        } else if (borderStyle == BorderStyle.ETCHED) {
            string = "etchedBorder";
        } else if (HeaderStyle.from(this.toolBar) == HeaderStyle.BOTH) {
            string = "headerBorder";
        } else {
            return;
        }
        LookAndFeel.installBorder(this.toolBar, "ToolBar." + string);
    }

    protected BasicToolBarUI.DockingListener createDockingListener(JToolBar jToolBar) {
        return new BasicToolBarUI.DockingListener(this, jToolBar);
    }

    @Override
    protected Border createRolloverBorder() {
        return WindowsBorders.getRolloverButtonBorder();
    }

    @Override
    protected void setBorderToRollover(Component component) {
        if (component instanceof AbstractButton) {
            super.setBorderToRollover(component);
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                super.setBorderToRollover(container.getComponent(i));
            }
        }
    }
}

