/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.filter.impl;

import biz.netup.swing.datetime.JDateTime;
import biz.netup.swing.datetime.Manual;
import biz.netup.swing.datetime.TimeSpan;
import biz.netup.swing.filter.TimeFilter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TimeFilterImpl
extends JPanel
implements TimeFilter {
    private boolean showTime = true;
    private boolean showButton = true;
    private JButton jButtonCreate;
    private JComboBox jComboBoxTimeSpan;
    private JDateTime jDateTimeFrom;
    private JDateTime jDateTimeTo;
    private Manual manualItem = null;
    private boolean updating_ = false;
    private static final ResourceBundle resource_ = ResourceBundle.getBundle(TimeFilterImpl.class.getName());

    public TimeFilterImpl() {
        this(true);
    }

    public TimeFilterImpl(boolean bl) {
        this.showTime = bl;
        this.initComponents();
        this.update();
    }

    public TimeFilterImpl(boolean bl, boolean bl2) {
        this.showButton = bl2;
        this.initComponents();
        this.update();
    }

    private void initComponents() {
        this.jComboBoxTimeSpan = new JComboBox();
        this.jDateTimeFrom = new JDateTime(this.showTime);
        this.jDateTimeTo = new JDateTime(this.showTime);
        this.jButtonCreate = new JButton();
        this.setLayout(new BoxLayout(this, 1));
        this.jComboBoxTimeSpan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TimeFilterImpl.this.update();
            }
        });
        this.jDateTimeFrom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TimeFilterImpl.this.update();
            }
        });
        this.jDateTimeTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TimeFilterImpl.this.update();
            }
        });
        this.jButtonCreate.setText(resource_.getString("Create"));
        this.jButtonCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TimeFilterImpl.this.update();
            }
        });
        this.jDateTimeFrom.getButton().setText("");
        this.jDateTimeFrom.getButton().setIcon(JDateTime.fromIcon);
        this.jDateTimeTo.getButton().setText("");
        this.jDateTimeTo.getButton().setIcon(JDateTime.toIcon);
        this.add(this.jComboBoxTimeSpan);
        this.add(Box.createVerticalStrut(8));
        this.add(this.jDateTimeFrom);
        this.add(Box.createVerticalStrut(8));
        this.add(this.jDateTimeTo);
        this.add(Box.createVerticalStrut(8));
        this.jButtonCreate.setAlignmentX(0.0f);
        this.add(this.jButtonCreate);
        if (!this.showButton) {
            this.jButtonCreate.setVisible(false);
        }
    }

    private void update() {
        if (this.updating_) {
            return;
        }
        this.updating_ = true;
        TimeSpan timeSpan = (TimeSpan)this.jComboBoxTimeSpan.getSelectedItem();
        if (timeSpan != null) {
            Date date = timeSpan.from(this.jDateTimeFrom.getDate(), this.jDateTimeTo.getDate());
            Date date2 = timeSpan.to(this.jDateTimeFrom.getDate(), this.jDateTimeTo.getDate());
            if (!timeSpan.fromEnabled()) {
                this.jDateTimeFrom.setDate(date);
            }
            if (!timeSpan.toEnabled()) {
                this.jDateTimeTo.setDate(date2);
            }
            this.jDateTimeFrom.setEnabled(this.isEnabled() && timeSpan.fromEnabled());
            this.jDateTimeTo.setEnabled(this.isEnabled() && timeSpan.toEnabled());
        }
        this.updating_ = false;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.jButtonCreate.setEnabled(bl);
        this.jComboBoxTimeSpan.setEnabled(bl);
        TimeSpan timeSpan = (TimeSpan)this.jComboBoxTimeSpan.getSelectedItem();
        if (null != timeSpan) {
            this.jDateTimeFrom.setEnabled(bl && timeSpan.fromEnabled());
            this.jDateTimeTo.setEnabled(bl && timeSpan.toEnabled());
        } else {
            this.jDateTimeFrom.setEnabled(bl);
            this.jDateTimeTo.setEnabled(bl);
        }
    }

    @Override
    public void addTimeSpan(TimeSpan timeSpan) {
        this.jComboBoxTimeSpan.addItem(timeSpan);
        this.update();
        if (timeSpan instanceof Manual) {
            this.manualItem = (Manual)timeSpan;
        }
    }

    @Override
    public void setDate(Date date, Date date2) {
        if (this.manualItem == null) {
            throw new IllegalStateException("TimeFilterImpl: Manual item is not added by addTimeSpan(...)");
        }
        this.jComboBoxTimeSpan.setSelectedItem(this.manualItem);
        this.jDateTimeFrom.setDate(date);
        this.jDateTimeTo.setDate(date2);
    }

    @Override
    public Date getBeginDate() {
        return this.jDateTimeFrom.getDate();
    }

    @Override
    public Date getEndDate() {
        return this.jDateTimeTo.getDate();
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.jButtonCreate.addActionListener(actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.jButtonCreate.removeActionListener(actionListener);
    }

    @Override
    public ActionListener[] getActionListeners() {
        return this.jButtonCreate.getActionListeners();
    }

    public JButton getButton() {
        return this.jButtonCreate;
    }
}

