/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.filter.impl;

import biz.netup.swing.datetime.JDateTime;
import biz.netup.swing.datetime.Manual;
import biz.netup.swing.datetime.TimeSpan;
import biz.netup.swing.filter.TimeFilter;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TimeFilterHorizontalImpl
extends JPanel
implements TimeFilter {
    private JComboBox jComboBoxTimeSpan;
    private JDateTime jDateTimeFrom;
    private JDateTime jDateTimeTo;
    private Manual manualItem = null;
    private boolean showTime = true;
    private boolean updating_ = false;

    public TimeFilterHorizontalImpl() {
        this(true);
    }

    public TimeFilterHorizontalImpl(boolean bl) {
        this.showTime = bl;
        this.initComponents();
        this.update();
    }

    private void initComponents() {
        this.jComboBoxTimeSpan = new JComboBox();
        this.jDateTimeFrom = new JDateTime(this.showTime);
        this.jDateTimeTo = new JDateTime(this.showTime);
        this.setLayout(new FlowLayout(0, 2, 2));
        this.jComboBoxTimeSpan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TimeFilterHorizontalImpl.this.update();
            }
        });
        this.jDateTimeFrom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TimeFilterHorizontalImpl.this.update();
            }
        });
        this.jDateTimeFrom.getButton().setText("");
        this.jDateTimeFrom.getButton().setIcon(JDateTime.fromIcon);
        this.jDateTimeTo.getButton().setText("");
        this.jDateTimeTo.getButton().setIcon(JDateTime.toIcon);
        this.add(this.jComboBoxTimeSpan);
        this.add(this.jDateTimeFrom);
        this.add(this.jDateTimeTo);
    }

    private void update() {
        if (this.updating_) {
            return;
        }
        this.updating_ = true;
        TimeSpan timeSpan = (TimeSpan)this.jComboBoxTimeSpan.getSelectedItem();
        if (timeSpan != null) {
            Date date = timeSpan.from(this.jDateTimeFrom.getDate(), this.jDateTimeTo.getDate());
            Date date2 = timeSpan.to(this.jDateTimeFrom.getDate(), this.jDateTimeTo.getDate());
            if (!timeSpan.fromEnabled()) {
                this.jDateTimeFrom.setDate(date);
            }
            if (!timeSpan.toEnabled()) {
                this.jDateTimeTo.setDate(date2);
            }
            this.jDateTimeFrom.setEnabled(this.isEnabled() && timeSpan.fromEnabled());
            this.jDateTimeTo.setEnabled(this.isEnabled() && timeSpan.toEnabled());
        }
        this.updating_ = false;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.jComboBoxTimeSpan.setEnabled(bl);
        TimeSpan timeSpan = (TimeSpan)this.jComboBoxTimeSpan.getSelectedItem();
        if (null != timeSpan) {
            this.jDateTimeFrom.setEnabled(bl && timeSpan.fromEnabled());
            this.jDateTimeTo.setEnabled(bl && timeSpan.toEnabled());
        } else {
            this.jDateTimeFrom.setEnabled(bl);
            this.jDateTimeTo.setEnabled(bl);
        }
    }

    @Override
    public void addTimeSpan(TimeSpan timeSpan) {
        this.jComboBoxTimeSpan.addItem(timeSpan);
        this.update();
        if (timeSpan instanceof Manual) {
            this.manualItem = (Manual)timeSpan;
        }
    }

    @Override
    public void setDate(Date date, Date date2) {
        if (this.manualItem == null) {
            throw new IllegalStateException("TimeFilter2Impl: Manual item is not added by addTimeSpan(...)");
        }
        this.jComboBoxTimeSpan.setSelectedItem(this.manualItem);
        this.jDateTimeFrom.setDate(date);
        this.jDateTimeTo.setDate(date2);
    }

    @Override
    public Date getBeginDate() {
        return this.jDateTimeFrom.getDate();
    }

    @Override
    public Date getEndDate() {
        return this.jDateTimeTo.getDate();
    }

    @Override
    public ActionListener[] getActionListeners() {
        return null;
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
    }

    public JDateTime getJDateTimeFrom() {
        return this.jDateTimeFrom;
    }

    public JDateTime getJDateTimeTo() {
        return this.jDateTimeTo;
    }

    public JComboBox getJComboBoxTimeSpan() {
        return this.jComboBoxTimeSpan;
    }
}

