/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.filter.impl;

import biz.netup.swing.filter.SimpleFilter;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SimpleFilterExtImpl
extends JPanel
implements SimpleFilter {
    private static final ResourceBundle RESOURCE = ResourceBundle.getBundle(SimpleFilterExtImpl.class.getName());
    private static final long FILTERING_DELAY = 1000L;
    private static final int MODE_ENTIRE = 1;
    private static final int MODE_AND = 2;
    private static final int MODE_OR = 3;
    private int mode = 2;
    private JButton btnClear;
    private JTextField textSimpleFilter;
    private FilterDocumentListener panelTimer;
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private TablePanel table;
    public MapTableModel.TableRowFilter tableFilter = new TableFilter();
    public static final Icon icon = new ImageIcon(SimpleFilterExtImpl.class.getResource("magnifier.png"));
    public static final Icon iconHover = new ImageIcon(SimpleFilterExtImpl.class.getResource("magnifier_.png"));
    private JPopupMenu menu;

    public SimpleFilterExtImpl(TablePanel tablePanel) {
        super(new GridBagLayout());
        this.table = tablePanel;
        this.btnClear = new JButton(icon);
        this.btnClear.setFocusable(false);
        this.add((Component)this.btnClear, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 3), 0, 0));
        final Border border = this.btnClear.getBorder();
        final Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = border.getBorderInsets(null);
        final Insets insets3 = new Insets(-insets2.top, -insets2.left, -insets2.bottom, -insets2.right);
        final EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, 0);
        this.btnClear.setMargin(insets);
        this.btnClear.setBorder(emptyBorder);
        this.btnClear.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                SimpleFilterExtImpl.this.btnClear.setIcon(iconHover);
                SimpleFilterExtImpl.this.btnClear.setMargin(insets3);
                SimpleFilterExtImpl.this.btnClear.setBorder(border);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                SimpleFilterExtImpl.this.btnClear.setIcon(icon);
                SimpleFilterExtImpl.this.btnClear.setMargin(insets);
                SimpleFilterExtImpl.this.btnClear.setBorder(emptyBorder);
            }
        });
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimpleFilterExtImpl.this.textSimpleFilter.setText("");
            }
        });
        this.btnClear.setToolTipText(RESOURCE.getString("clear_filter"));
        this.textSimpleFilter = new JTextField();
        this.textSimpleFilter.setToolTipText(RESOURCE.getString("tooltip"));
        this.panelTimer = new FilterDocumentListener();
        this.textSimpleFilter.getDocument().addDocumentListener(this.panelTimer);
        this.textSimpleFilter.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (10 == keyEvent.getKeyCode()) {
                    SimpleFilterExtImpl.this.table.getTable().grabFocus();
                    SimpleFilterExtImpl.this.table.getTable().getSelectionModel().setSelectionInterval(0, 0);
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.menu = new JPopupMenu();
        final JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(RESOURCE.getString("entire"));
        final JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(RESOURCE.getString("or"));
        final JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem(RESOURCE.getString("and"));
        jRadioButtonMenuItem3.setSelected(true);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jRadioButtonMenuItem == actionEvent.getSource()) {
                    SimpleFilterExtImpl.this.mode = 1;
                }
                if (jRadioButtonMenuItem2 == actionEvent.getSource()) {
                    SimpleFilterExtImpl.this.mode = 3;
                }
                if (jRadioButtonMenuItem3 == actionEvent.getSource()) {
                    SimpleFilterExtImpl.this.mode = 2;
                }
                jRadioButtonMenuItem.setSelected(SimpleFilterExtImpl.this.mode == 1);
                jRadioButtonMenuItem2.setSelected(SimpleFilterExtImpl.this.mode == 3);
                jRadioButtonMenuItem3.setSelected(SimpleFilterExtImpl.this.mode == 2);
                SimpleFilterExtImpl.this.setText(SimpleFilterExtImpl.this.getText());
            }
        };
        jRadioButtonMenuItem.addActionListener(actionListener);
        jRadioButtonMenuItem3.addActionListener(actionListener);
        jRadioButtonMenuItem2.addActionListener(actionListener);
        JMenuItem jMenuItem = new JMenuItem("<html><font color='black'>" + RESOURCE.getString("header"));
        jMenuItem.setBackground(UIManager.getColor("JButton.background"));
        jMenuItem.setEnabled(false);
        this.menu.add(jMenuItem);
        this.menu.add(jRadioButtonMenuItem3);
        this.menu.add(jRadioButtonMenuItem);
        this.menu.add(jRadioButtonMenuItem2);
        this.textSimpleFilter.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (SimpleFilterExtImpl.this.menu.isPopupTrigger(mouseEvent)) {
                    this.popup(mouseEvent);
                }
            }

            private void popup(MouseEvent mouseEvent) {
                SimpleFilterExtImpl.this.menu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.add((Component)this.textSimpleFilter, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        new Timer().schedule((TimerTask)this.panelTimer, 0L, 500L);
    }

    @Override
    public String getText() {
        return this.textSimpleFilter.getText();
    }

    public void setText(String string) {
        this.textSimpleFilter.setText(string);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.textSimpleFilter.setEnabled(bl);
        this.btnClear.setEnabled(bl);
    }

    public void updateFilter() {
        this.table.getTableModel().setFilter(this.tableFilter);
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    @Override
    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listeners.toArray();
    }

    public class TableFilter
    implements MapTableModel.TableRowFilter {
        @Override
        public boolean isRowShown(Map<String, Object> map) {
            String string;
            int n;
            int n2 = SimpleFilterExtImpl.this.table.getTableModel().getColumnCount() - 1;
            String string2 = SimpleFilterExtImpl.this.getText().toLowerCase();
            Vector<String> vector = new Vector<String>();
            if (SimpleFilterExtImpl.this.mode == 1) {
                vector.add(string2);
            } else {
                String[] stringArray;
                String[] stringArray2 = stringArray = string2.split(" ");
                int n3 = stringArray2.length;
                for (n = 0; n < n3; ++n) {
                    string = stringArray2[n];
                    if ("".equals(string)) continue;
                    vector.add(string);
                }
            }
            int n4 = vector.size();
            if (0 == vector.size()) {
                return true;
            }
            boolean bl = true;
            if (map.containsKey("X-STATUS")) {
                return true;
            }
            while (n2 >= 0) {
                String string3 = SimpleFilterExtImpl.this.table.getTableModel().getColumnId(n2);
                for (n = vector.size() - 1; n >= 0; --n) {
                    string = (String)vector.get(n);
                    if (null == map.get(string3) || !map.get(string3).toString().toLowerCase().contains(string)) continue;
                    vector.remove(n);
                }
                bl &= null == map.get(string3);
                --n2;
            }
            if (3 == SimpleFilterExtImpl.this.mode && vector.size() < n4) {
                return true;
            }
            return 0 == vector.size() || bl;
        }
    }

    private class FilterDocumentListener
    extends TimerTask
    implements DocumentListener {
        long lastModification = 0L;
        long lastSearch = 0L;

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        private void update(DocumentEvent documentEvent) {
            this.lastModification = Calendar.getInstance().getTimeInMillis();
        }

        @Override
        public void run() {
            long l = Calendar.getInstance().getTimeInMillis();
            if (l - this.lastModification > 1000L && this.lastSearch < this.lastModification) {
                this.lastSearch = l;
                if (0 == SimpleFilterExtImpl.this.listeners.size()) {
                    SimpleFilterExtImpl.this.table.getTableModel().setFilter(SimpleFilterExtImpl.this.tableFilter);
                }
                for (ActionListener actionListener : SimpleFilterExtImpl.this.listeners) {
                    actionListener.actionPerformed(new ActionEvent(this, 1001, "Filter"));
                }
            }
        }
    }
}

