/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.filter.impl;

import biz.netup.swing.filter.AdvancedFilter;
import biz.netup.swing.filter.entities.Field;
import biz.netup.swing.filter.entities.Logic;
import biz.netup.swing.filter.entities.Operation;
import biz.netup.swing.filter.entities.Value;
import biz.netup.swing.filter.impl.MaskedDocumentFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.AbstractDocument;
import org.apache.log4j.Logger;

public class AdvancedFilterImpl
extends JPanel
implements AdvancedFilter {
    private static final Logger LOGGER = Logger.getLogger(AdvancedFilterImpl.class);
    private static final ResourceBundle RESOURCE = ResourceBundle.getBundle(AdvancedFilterImpl.class.getName());
    private FilterTableModel filterTableModel;
    private JTable filterTable;
    private JButton performButton;
    private JButton clearButton;
    private List<ActionListener> actionListeners = new LinkedList<ActionListener>();
    private Vector<Field> fields = new Vector();
    private static final int C_LOGIC = 0;
    private static final int C_FIELD = 1;
    private static final int C_OPERATION = 2;
    private static final int C_VALUE = 3;
    private Color oddRowColor;
    private Color evenRowColor;
    private Color shadowRowColor;
    private static final String[] columnToolTips = new String[]{RESOURCE.getString("logic_ToolTip"), RESOURCE.getString("field_ToolTip"), RESOURCE.getString("operation_ToolTip"), RESOURCE.getString("value_ToolTip")};
    private PopupMenuListener fastPopupHider = new PopupMenuListener(){

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            AdvancedFilterImpl.this.stopEditing();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    };

    private void performActions() {
        for (ActionListener actionListener : this.actionListeners) {
            actionListener.actionPerformed(new ActionEvent(this, 1001, "perform"));
        }
    }

    public AdvancedFilterImpl() {
        super(new GridBagLayout());
        LOGGER.debug("Constructor");
        this.performButton = new JButton(RESOURCE.getString("button_Perform"));
        this.performButton.setToolTipText(RESOURCE.getString("perform_ToolTip"));
        LOGGER.debug("Init AdvancedFilter components");
        this.oddRowColor = new Color(new Integer(RESOURCE.getString("oddRowColor_R")), new Integer(RESOURCE.getString("oddRowColor_G")), new Integer(RESOURCE.getString("oddRowColor_B")));
        this.evenRowColor = new Color(new Integer(RESOURCE.getString("evenRowColor_R")), new Integer(RESOURCE.getString("evenRowColor_G")), new Integer(RESOURCE.getString("evenRowColor_B")));
        this.shadowRowColor = new Color(new Integer(RESOURCE.getString("shadowRowColor_R")), new Integer(RESOURCE.getString("shadowRowColor_G")), new Integer(RESOURCE.getString("shadowRowColor_B")));
        for (int i = 0; i < columnToolTips.length; ++i) {
            if (!columnToolTips[i].equals("")) continue;
            AdvancedFilterImpl.columnToolTips[i] = null;
        }
        this.filterTableModel = new FilterTableModel();
        this.filterTable = new JTable(this.filterTableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (!this.getModel().isCellEditable(n, n2)) {
                    component.setBackground(AdvancedFilterImpl.this.shadowRowColor);
                } else if (n % 2 == 0) {
                    component.setBackground(AdvancedFilterImpl.this.evenRowColor);
                } else {
                    component.setBackground(AdvancedFilterImpl.this.oddRowColor);
                }
                return component;
            }

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent mouseEvent) {
                        Point point = mouseEvent.getPoint();
                        int n = this.columnModel.getColumnIndexAtX(point.x);
                        int n2 = this.columnModel.getColumn(n).getModelIndex();
                        return columnToolTips[n2];
                    }
                };
            }
        };
        this.filterTable.getTableHeader().setReorderingAllowed(false);
        this.filterTable.setRowSelectionAllowed(false);
        this.filterTable.setDefaultEditor(Logic.class, new LogicEditor());
        this.filterTable.setDefaultEditor(Field.class, new FieldEditor());
        this.filterTable.setDefaultEditor(Operation.class, new OperationEditor());
        this.filterTable.setDefaultEditor(Value.class, new ValueEditor());
        this.filterTable.addMouseListener(new MouseAdapter(){
            JPopupMenu menu = new JPopupMenu();
            int row;
            JMenuItem deleteItem = new JMenuItem(AdvancedFilterImpl.access$500().getString("popup_Delete"));
            JMenuItem insertItem = new JMenuItem(AdvancedFilterImpl.access$500().getString("popup_Insert"));
            {
                this.deleteItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        LOGGER.info("Remove row " + row);
                        AdvancedFilterImpl.this.filterTableModel.removeRow(row);
                    }
                });
                this.insertItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        LOGGER.info("Insert row " + row);
                        AdvancedFilterImpl.this.filterTableModel.insertRowAt(row);
                    }
                });
                this.menu.add(this.deleteItem);
                this.menu.add(this.insertItem);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (this.menu.isPopupTrigger(mouseEvent)) {
                    this.popup(mouseEvent);
                }
            }

            private void popup(MouseEvent mouseEvent) {
                this.row = AdvancedFilterImpl.this.filterTable.rowAtPoint(mouseEvent.getPoint());
                if (this.row < 0) {
                    return;
                }
                LOGGER.info("Popup for row = " + this.row);
                this.menu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.actionListeners.add(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LOGGER.debug("Stop editing action");
                AdvancedFilterImpl.this.stopEditing();
            }
        });
        this.clearButton = new JButton(RESOURCE.getString("button_Clear"));
        this.clearButton.setToolTipText(RESOURCE.getString("clear_ToolTip"));
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LOGGER.debug("Clear button pressed");
                int n = JOptionPane.showConfirmDialog(AdvancedFilterImpl.this, new JLabel(RESOURCE.getString("clear_Confirm_Text")), RESOURCE.getString("clear_Confirm_Title"), 0);
                if (n == 0) {
                    LOGGER.debug("Clear button confirmed");
                    AdvancedFilterImpl.this.stopEditing();
                    AdvancedFilterImpl.this.filterTableModel.removeAllRows();
                }
            }
        });
        this.performButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LOGGER.debug("Perform button pressed");
                int n = JOptionPane.showConfirmDialog(AdvancedFilterImpl.this, new JLabel(RESOURCE.getString("perform_Confirm_Text")), RESOURCE.getString("perform_Confirm_Title"), 0);
                if (n == 0) {
                    LOGGER.debug("Perform button confirmed");
                    AdvancedFilterImpl.this.performActions();
                }
            }
        });
        this.add((Component)this.filterTable.getTableHeader(), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.filterTable, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.clearButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.performButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
    }

    private boolean checkValue(Value value, String string) {
        Pattern pattern = Pattern.compile(string);
        for (int i = 0; i < value.label.length(); ++i) {
            if (pattern.matcher(value.label.subSequence(i, i + 1)).matches()) continue;
            return false;
        }
        return true;
    }

    private void stopEditing() {
        LOGGER.debug("Stop editing");
        if (this.filterTable.getCellEditor() != null) {
            this.filterTable.getCellEditor().stopCellEditing();
        }
        this.filterTableModel.fireTableDataChanged();
    }

    private Field getAvailableField(Field field) {
        for (Field field2 : this.fields) {
            if (!field.name.equals(field2.name)) continue;
            return field2;
        }
        return null;
    }

    private Field createSelectedField(Field field) {
        Logic[] logicArray = new Logic[]{field.logics[0]};
        Operation[] operationArray = new Operation[]{field.operations[0]};
        Value[] valueArray = new Value[]{!field.isEditable ? field.values[0] : new Value(-1, "")};
        return new Field(field.name, field.label, logicArray, operationArray, valueArray, field.valueMask);
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        LOGGER.info("Add action listener");
        this.actionListeners.add(actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        LOGGER.info("Removing action listener");
        int n = this.actionListeners.indexOf(actionListener);
        if (n > 0) {
            LOGGER.info("Removed!");
            this.actionListeners.remove(n);
        }
    }

    @Override
    public ActionListener[] getActionListeners() {
        LOGGER.info("Get action listeners");
        if (this.actionListeners.size() > 1) {
            return (ActionListener[])this.actionListeners.subList(1, this.actionListeners.size()).toArray();
        }
        return new ActionListener[0];
    }

    @Override
    public void setAvailableFields(Vector<Field> vector) {
        LOGGER.info("Set available fields [" + vector.size() + "]");
        this.fields = vector;
    }

    @Override
    public void addAvailableField(Field field) {
        LOGGER.info("Add available field (name = " + field.name + ", label = " + field.label);
        if (this.fields.indexOf(field) < 0) {
            this.fields.add(field);
        }
    }

    @Override
    public void removeAvailableField(Field field) {
        LOGGER.info("Add available field (name = " + field.name + ", label = " + field.label);
        this.fields.remove(field);
    }

    @Override
    public Vector<Field> getSelectedFields() {
        LOGGER.info("Get selected fields");
        return this.filterTableModel.getSelectedFields();
    }

    @Override
    public void setSelectedFields(Vector<Field> vector) {
        LOGGER.info("Set selected fields [" + vector.size() + "]");
        this.filterTableModel.setSelectedFields(vector);
    }

    private class FilterTableModel
    extends AbstractTableModel {
        private String[] columnNames;
        private Vector<Field> data = new Vector();
        private Class[] columnClasses;

        public FilterTableModel() {
            this.columnNames = new String[]{RESOURCE.getString("Column_Logic"), RESOURCE.getString("Column_Field"), RESOURCE.getString("Column_Operation"), RESOURCE.getString("Column_Value")};
            this.columnClasses = new Class[]{Logic.class, Field.class, Operation.class, Value.class};
        }

        public void insertRowAt(int n) {
            this.data.add(n, AdvancedFilterImpl.this.createSelectedField((Field)AdvancedFilterImpl.this.fields.firstElement()));
            this.fireTableRowsInserted(n, n);
            AdvancedFilterImpl.this.filterTable.editCellAt(n, 1);
            ((JComboBox)AdvancedFilterImpl.this.filterTable.getEditorComponent()).showPopup();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.columnClasses[n];
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            return this.data.size() + 1;
        }

        public int getCompleteRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.data.size() <= n) {
                return "";
            }
            switch (n2) {
                case 0: {
                    return this.getLogic(n);
                }
                case 1: {
                    return this.getField(n);
                }
                case 2: {
                    return this.getOperation(n);
                }
                case 3: {
                    return this.getValue(n);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (object == null) {
                return;
            }
            if (n2 < 0 || n2 > 3) {
                return;
            }
            Field field = this.getRow(n);
            if (field == null) {
                if (n2 != 1) {
                    throw new RuntimeException("AdvancedFilter internal error: setValueAt() was called for new row, but value is not field.");
                }
                this.addRow(AdvancedFilterImpl.this.createSelectedField((Field)object));
            } else {
                Object object2 = this.getValueAt(n, n2);
                if (object.equals(object2)) {
                    return;
                }
                switch (n2) {
                    case 0: {
                        field.logics[0] = (Logic)object;
                        break;
                    }
                    case 1: {
                        Field field2 = this.data.get(n);
                        Logic logic = field2.logics[0];
                        Operation operation = field2.operations[0];
                        Field field3 = (Field)object;
                        Logic[] logicArray = new Logic[]{field3.logics[0]};
                        Operation[] operationArray = new Operation[]{field3.operations[0]};
                        Value[] valueArray = new Value[]{field2.values[0]};
                        for (Logic logic2 : field3.logics) {
                            if (logic2 != logic) continue;
                            logicArray[0] = logic;
                        }
                        for (Operation operation2 : field3.operations) {
                            if (operation2 != operation) continue;
                            operationArray[0] = operation;
                        }
                        if (!AdvancedFilterImpl.this.checkValue(valueArray[0], field3.valueMask)) {
                            valueArray[0] = new Value(-1, "");
                        }
                        if (!field3.isEditable) {
                            valueArray[0] = field3.values[0];
                        }
                        Field field4 = new Field(field3.name, field3.label, logicArray, operationArray, valueArray, field3.valueMask);
                        this.data.set(n, field4);
                        break;
                    }
                    case 2: {
                        field.operations[0] = (Operation)object;
                        break;
                    }
                    case 3: {
                        field.values[0] = (Value)object;
                    }
                }
                this.fireTableRowsUpdated(n, n);
            }
        }

        private void addRow(Field field) {
            this.data.add(field);
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
        }

        public void removeAllRows() {
            int n = this.data.size();
            this.data.clear();
            this.fireTableRowsDeleted(0, n > 0 ? n - 1 : 0);
        }

        private Field getRow(int n) {
            if (n < this.data.size()) {
                return this.data.get(n);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 1) {
                return true;
            }
            if (n == 0 && n2 == 0) {
                return false;
            }
            return this.data.size() > n;
        }

        public void removeRow(int n) {
            if (this.data.size() <= n) {
                return;
            }
            this.data.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        public Logic getLogic(int n) {
            if (n == 0) {
                return null;
            }
            return this.data.get((int)n).logics[0];
        }

        public Field getField(int n) {
            return this.data.get(n);
        }

        public Operation getOperation(int n) {
            return this.data.get((int)n).operations[0];
        }

        public Value getValue(int n) {
            return this.data.get((int)n).values[0];
        }

        public Vector<Field> getSelectedFields() {
            return this.data;
        }

        public void setSelectedFields(Vector<Field> vector) {
            this.data = vector;
            this.fireTableDataChanged();
        }
    }

    private class ValueEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JTextField textField;
        private JComboBox comboBox = new JComboBox();
        private MaskedDocumentFilter valueFilter;
        private boolean isCombo = false;

        public ValueEditor() {
            this.textField = new JTextField();
            this.valueFilter = new MaskedDocumentFilter();
            ((AbstractDocument)((JTextField)this.comboBox.getEditor().getEditorComponent()).getDocument()).setDocumentFilter(this.valueFilter);
            ((JTextField)this.comboBox.getEditor().getEditorComponent()).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ValueEditor.this.comboBox.setSelectedItem(ValueEditor.this.comboBox.getEditor().getItem());
                    ValueEditor.this.stopCellEditing();
                }
            });
            this.comboBox.addPopupMenuListener(AdvancedFilterImpl.this.fastPopupHider);
            ((AbstractDocument)this.textField.getDocument()).setDocumentFilter(this.valueFilter);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object == null) {
                object = new String();
            }
            Field field = AdvancedFilterImpl.this.getAvailableField(AdvancedFilterImpl.this.filterTableModel.getField(n));
            this.valueFilter.setMaskPattern(field.valueMask);
            LOGGER.debug("Value editor created");
            if (field.values.length == 0) {
                this.textField.setText(object.toString());
                this.isCombo = false;
                return this.textField;
            }
            this.comboBox.removeAllItems();
            for (Value value : field.values) {
                this.comboBox.addItem(value);
            }
            this.comboBox.setEditable(field.isEditable);
            this.comboBox.setSelectedItem(object);
            this.isCombo = true;
            return this.comboBox;
        }

        @Override
        public Value getCellEditorValue() {
            if (this.isCombo) {
                if (this.comboBox.isEditable()) {
                    String string = this.comboBox.getEditor().getItem().toString();
                    for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
                        if (!this.comboBox.getItemAt(i).toString().equals(string)) continue;
                        return (Value)this.comboBox.getItemAt(i);
                    }
                    return new Value(-1, string);
                }
                return (Value)this.comboBox.getSelectedItem();
            }
            return new Value(-1, this.textField.getText());
        }
    }

    private class OperationEditor
    extends DefaultCellEditor {
        private JComboBox comboBox;

        public OperationEditor() {
            super(new JComboBox());
            this.comboBox = (JComboBox)this.editorComponent;
            this.comboBox.setEditable(false);
            this.comboBox.addPopupMenuListener(AdvancedFilterImpl.this.fastPopupHider);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Operation operation = object instanceof Operation ? (Operation)object : (Operation)this.comboBox.getSelectedItem();
            this.comboBox.removeAllItems();
            Field field = AdvancedFilterImpl.this.filterTableModel.getField(n);
            Field field2 = AdvancedFilterImpl.this.getAvailableField(field);
            for (Operation operation2 : field2.operations) {
                this.comboBox.addItem(operation2);
            }
            this.comboBox.setSelectedItem(operation);
            if (this.comboBox.getSelectedIndex() < 0) {
                this.comboBox.setSelectedIndex(0);
            }
            LOGGER.debug("Operation editor created");
            return this.comboBox;
        }
    }

    private class FieldEditor
    extends DefaultCellEditor {
        JComboBox comboBox;

        public FieldEditor() {
            super(new JComboBox());
            this.comboBox = (JComboBox)this.editorComponent;
            this.comboBox.setEditable(false);
            this.comboBox.addPopupMenuListener(AdvancedFilterImpl.this.fastPopupHider);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Field field = object instanceof Field ? AdvancedFilterImpl.this.getAvailableField((Field)object) : (Field)this.comboBox.getSelectedItem();
            this.comboBox.removeAllItems();
            if (AdvancedFilterImpl.this.fields.size() == 0) {
                return this.comboBox;
            }
            for (Field field2 : AdvancedFilterImpl.this.fields) {
                this.comboBox.addItem(field2);
            }
            this.comboBox.setSelectedItem(field);
            if (this.comboBox.getSelectedIndex() < 0) {
                this.comboBox.setSelectedIndex(0);
            }
            LOGGER.debug("Field editor created");
            return this.comboBox;
        }
    }

    private class LogicEditor
    extends DefaultCellEditor {
        JComboBox comboBox;

        public LogicEditor() {
            super(new JComboBox());
            this.comboBox = (JComboBox)this.editorComponent;
            this.comboBox.setEditable(false);
            this.comboBox.addPopupMenuListener(AdvancedFilterImpl.this.fastPopupHider);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Logic logic = object instanceof Logic ? (Logic)object : (Logic)this.comboBox.getSelectedItem();
            this.comboBox.removeAllItems();
            Field field = AdvancedFilterImpl.this.filterTableModel.getField(n);
            Field field2 = AdvancedFilterImpl.this.getAvailableField(field);
            for (int i = 0; i < field2.logics.length; ++i) {
                this.comboBox.addItem(field2.logics[i]);
            }
            this.comboBox.setSelectedItem(logic);
            if (this.comboBox.getSelectedIndex() < 0) {
                this.comboBox.setSelectedIndex(0);
            }
            LOGGER.debug("Logic editor created");
            return this.comboBox;
        }
    }
}

